"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Optimization = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Manufacturing = require("..");
const joins = {
    collectionJoins: {
        optimizationLines: {
            optimizationCode: 'optimizationCode',
        },
    },
};
let Optimization = class Optimization extends xtrem_core_1.Node {
};
exports.Optimization = Optimization;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OPTCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Optimization.prototype, "optimizationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OPTDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Optimization.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SETTIMTYP',
        dataType: () => sageX3ManufacturingData.enums.setupTimeTypeDatatype,
    })
], Optimization.prototype, "setupTimeType", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.OptimizationLine,
        isMutable: true,
        dependsOn: ['optimizationCode'],
    })
], Optimization.prototype, "optimizationLines", void 0);
exports.Optimization = Optimization = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GFSOPTMAT',
        keyPropertyNames: ['optimizationCode'],
        indexes: [
            {
                orderBy: {
                    optimizationCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.GfsaActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Optimization);
//# sourceMappingURL=optimization.js.map