"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkCenterExtension = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3Manufacturing = require("..");
const joins = {
    referenceJoins: {
        optimizationCode: {
            optimizationCode: 'optimizationCode',
        },
    },
    collectionJoins: {
        workOrderOperationLines: {
            manufacturingSite: 'manufacturingSite',
            expectedWorkCenter: 'code',
        },
    },
};
let WorkCenterExtension = class WorkCenterExtension extends xtrem_core_1.NodeExtension {
};
exports.WorkCenterExtension = WorkCenterExtension;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WSTTYP',
        dataType: () => sageX3ManufacturingData.enums.workCenterTypeDatatype,
    })
], WorkCenterExtension.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPTCOD',
        columnType: 'string',
        node: () => sageX3Manufacturing.nodes.Optimization,
        serviceOptions: () => [sageX3System.serviceOptions.GfsaActivityCode],
    })
], WorkCenterExtension.prototype, "optimizationCode", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Manufacturing.nodes.WorkOrderOperationLine,
        dependsOn: ['manufacturingSite', 'code'],
    })
], WorkCenterExtension.prototype, "workOrderOperationLines", void 0);
exports.WorkCenterExtension = WorkCenterExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3ManufacturingData.nodes.WorkCenter,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], WorkCenterExtension);
//# sourceMappingURL=work-center-extension.js.map