"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorkOrderOperationsList = void 0;
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
/** Function gets operations for a given work order number of a given page ( i.e. passing the 'this' keyword ) -
 *      Returns list of operations */
async function getWorkOrderOperationsList(woNumber, page) {
    try {
        const operationsList = (0, xtrem_client_1.extractEdges)(await page.$.graph
            .node('@sage/x3-manufacturing/WorkOrderOperationLine')
            .query(ui.queryUtils.edgesSelector({
            operationNumber: true,
            operationDescription: true,
            expectedWorkCenter: {
                code: true,
            },
            operationUnit: {
                code: true,
            },
            expectedQuantity: true,
            completedQuantity: true,
            timeUnit: true,
            setupTime: true,
            runTime: true,
            operationStatus: true,
        }, {
            filter: {
                workOrder: {
                    number: woNumber,
                },
            },
            first: 1000,
        }))
            .execute());
        return operationsList;
    }
    catch (err) {
        page.$.showToast(ui.localize('@sage/x3-manufacturing/pages__adc_time_tracking___cannot_retrieve_operations', 'Cannot retrieve operations.'), { type: 'error', timeout: 5000 });
        return [];
    }
}
exports.getWorkOrderOperationsList = getWorkOrderOperationsList;
//# sourceMappingURL=work-order-operations-list.js.map