"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readParameterValue = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
async function readParameterValue(parameter, user, stockSite, pageInstance) {
    try {
        // Note that all parameter values are stored as strings.  They can have different meanings such as a local menu option.
        let resp = '';
        // Check parameter level
        const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
            .node('@sage/x3-system/GeneralParameter')
            .query(ui.queryUtils.edgesSelector({
            _id: true,
            definitionLevel: true,
        }, {
            filter: {
                code: parameter,
            },
        }))
            .execute());
        // Call appropriate function depending on parameter level
        if (typesLib.eq(response[0].definitionLevel, 'user')) {
            resp = (await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .queries.getGeneralParameterUserValue(true, {
                user: user,
                site: stockSite,
                parameter: parameter,
            })
                .execute());
        }
        else {
            resp = (await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .queries.getGeneralParameterValue(true, {
                code: stockSite,
                parameter: parameter,
            })
                .execute());
        }
        return resp;
    }
    catch (e) {
        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/dialog-error-title', 'Error'), ui.localize('@sage/x3-manufacturing/utils-error-reading-parameter-value', 'Error reading parameter value: {{ param }}', { param: parameter }));
        return '';
    }
}
exports.readParameterValue = readParameterValue;
//# sourceMappingURL=read-parameter.js.map