import { GraphApi, WorkOrderInput, WorkOrderMaterialLineInput, WorkOrderProductLineInput } from '@sage/x3-manufacturing-api';
import { integer } from '@sage/xtrem-client';
import { Page } from '@sage/xtrem-ui';
export interface materialsConsumptionDetail {
    workOrder: string;
    product: string;
    description: string;
    unit: string;
    quantity: number;
    status: string;
    location: {
        code: string;
    };
    lot: {
        code: string;
    };
    sublot: string;
    serialNumber: {
        code: string;
    };
    licensePlateNumber: {
        code: string;
        container: {
            code: string;
        };
    };
    closeWoLine: boolean;
    lineNumber: integer;
    bomSequence: integer;
    bomNumber: {
        code: string;
        description1: string;
    };
    bomAlternative: integer;
    trackingDate: string;
}
export declare function validate(page: Page): Promise<boolean>;
export type MaterialsConsumptionSession = {
    username: string;
    workOrder: WorkOrderInput;
    product: WorkOrderMaterialLineInput;
    transaction: string;
    unplannedMaterials: boolean;
    productsReleased: WorkOrderProductLineInput;
    detail: materialsConsumptionDetail[];
    productCode: string;
    productDescription: string;
    trackingDate: string;
    materialsConsumptionSite: string;
    numberProductsReleased: number;
};
export declare class MaterialsConsumptionDetailsRecordManager {
    private page;
    constructor(page: Page<GraphApi>, cleanupIncompleteSessionLines?: boolean);
    private static readonly WORK_ORDER_KEY;
    private _materialsConsumptionSession;
    get materialsConsumptionSession(): MaterialsConsumptionSession | null;
    set materialsConsumptionSession(materialsConsumptionSession: MaterialsConsumptionSession | null);
    private _checkStorage;
    private _cleanupSession;
    clearSession(): void;
    loadMaterialsConsumptionDetails(page: {
        product: {
            value: string;
        };
        description: {
            value: string;
        };
        unit: {
            value: string;
        };
        quantity: {
            value: number;
        };
        status: {
            value: string;
        };
        location: {
            value: string;
        };
        lot: {
            value: {
                lot?: string;
            };
        };
        sublot: {
            value: string;
        };
        serialNumber: {
            value: {
                code?: string;
            };
        };
        closeWoLine: {
            value: boolean;
        };
        licensePlateNumber: {
            value: string;
        };
        lineNumber: {
            value: integer;
        };
        bomSequence: {
            value: integer;
        };
        bomNumber: {
            value: string;
        };
        bomAlternative: {
            value: integer;
        };
        trackingDate: {
            value: string;
        };
    }, addNewDetail?: boolean): void;
}
//# sourceMappingURL=materials-consumption-details-control.d.ts.map