"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSelectedStockSite = void 0;
const ui = require("@sage/xtrem-ui");
async function errorSelectedStockSite(pageInstance) {
    pageInstance.$.dialog.message('error', ui.localize('@sage/x3-manufacturing/dialog-error-location-inquiry-title', 'Error'), ui.localize('@sage/x3-manufacturing/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));
}
async function getSelectedStockSite(pageInstance) {
    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');
    if (!selectedSite) {
        await errorSelectedStockSite(pageInstance);
        return null;
    }
    else {
        return selectedSite.toString();
    }
}
exports.getSelectedStockSite = getSelectedStockSite;
//# sourceMappingURL=get-selected-stock-site.js.map