"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatImportMessagefile = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
async function formatImportMessagefile(result, severityCode, importName) {
    let trackingMessageArray;
    if (typesLib.strictEq(typeof severityCode, 'undefined')) {
        trackingMessageArray = JSON.stringify(result.diagnoses, ['message']);
    }
    else {
        const filteredTrackingMessageArray = result.diagnoses?.filter((diagnoses) => {
            if (diagnoses && typesLib.gt(diagnoses.severity, severityCode)) {
                return true;
            }
        }) ?? [];
        trackingMessageArray = JSON.stringify(filteredTrackingMessageArray, ['message']);
    }
    let msg;
    msg = trackingMessageArray.replace(/[^\.^\-\p{L}\p{M}\/'\/!\w\s]/gu, '');
    msg = msg.replace(/messagedescription/g, ' ');
    msg = msg.replace(/message/g, ' ');
    msg = msg.replace(/\//g, ' ');
    return msg;
}
exports.formatImportMessagefile = formatImportMessagefile;
//# sourceMappingURL=format-import-message-file.js.map