"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkCenter = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ManufacturingData = require("..");
const joins = {
    referenceJoins: {
        manufacturingSite: {
            code: 'manufacturingSite',
        },
        workCenterGroup: {
            code: 'workCenterGroup',
        },
        weeklyStructure: {
            code: 'weeklyStructure',
        },
    },
};
let WorkCenter = class WorkCenter extends xtrem_core_1.Node {
};
exports.WorkCenter = WorkCenter;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkCenter.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WCRFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], WorkCenter.prototype, "manufacturingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WCR',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenterGroup,
    })
], WorkCenter.prototype, "workCenterGroup", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VLTCCE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkCenter.prototype, "costingDimension", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TWD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.WeeklyStructure,
    })
], WorkCenter.prototype, "weeklyStructure", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EFF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkCenter.prototype, "efficiencyInPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkCenter.prototype, "shrinkageInPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WSTNBR',
    })
], WorkCenter.prototype, "numberOfResources", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLEPCTAUT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkCenter.prototype, "automaticClosingPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QLFLEV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], WorkCenter.prototype, "qualificationLevel", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTHOUTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkCenter.prototype, "totalExpectedTimeInHours", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLHOUTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], WorkCenter.prototype, "totalTimeCompleteInHours", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CONSTRAINT',
    })
], WorkCenter.prototype, "isConstraint", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCCP',
    })
], WorkCenter.prototype, "isRccp", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RUNBRKFLG',
    })
], WorkCenter.prototype, "isRunDuringEmployeeBreak", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WSTDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], WorkCenter.prototype, "description", void 0);
exports.WorkCenter = WorkCenter = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'WORKSTATIO',
        keyPropertyNames: ['code', 'manufacturingSite'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    manufacturingSite: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['code'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], WorkCenter);
//# sourceMappingURL=work-center.js.map