"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Team = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ManufacturingData = require("..");
const joins = {
    referenceJoins: {
        userCode: {
            code: 'userCode',
        },
        site: {
            code: 'site',
        },
        workCenterGroup: {
            code: 'workCenterGroup',
        },
    },
    collectionJoins: {
        teamEmployees: {
            teamId: 'teamId',
        },
    },
};
let Team = class Team extends xtrem_core_1.Node {
};
exports.Team = Team;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EMPNUM',
    })
], Team.prototype, "teamId", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EMPDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Team.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EMPSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Team.prototype, "employeeShortDesignation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EMPTYP',
        dataType: () => sageX3MasterData.enums.employeeTypeDatatype,
    })
], Team.prototype, "teamType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], Team.prototype, "userCode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Team.prototype, "laborRate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], Team.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEFFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Team.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFWST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Team.prototype, "workCenter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEFWCR',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenterGroup,
    })
], Team.prototype, "workCenterGroup", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ManufacturingData.nodes.TeamEmployee,
        isMutable: true,
        dependsOn: ['teamId'],
    })
], Team.prototype, "teamEmployees", void 0);
exports.Team = Team = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABMAT',
        keyPropertyNames: ['teamId'],
        indexes: [
            {
                orderBy: {
                    teamId: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Team);
//# sourceMappingURL=team.js.map