"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeamEmployee = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ManufacturingData = require("..");
const joins = {
    referenceJoins: {
        teamId: {
            teamId: 'teamId',
        },
        employeeId: {
            teamId: 'employeeId',
        },
    },
};
let TeamEmployee = class TeamEmployee extends xtrem_core_1.Node {
};
exports.TeamEmployee = TeamEmployee;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEAMNUM',
        columnType: 'integer',
        node: () => sageX3ManufacturingData.nodes.EmployeeId,
    })
], TeamEmployee.prototype, "teamId", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEAMLIN',
    })
], TeamEmployee.prototype, "teamLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EMPNUM',
        columnType: 'integer',
        node: () => sageX3ManufacturingData.nodes.EmployeeId,
    })
], TeamEmployee.prototype, "employeeId", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], TeamEmployee.prototype, "startDate", void 0);
exports.TeamEmployee = TeamEmployee = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SFTTEM',
        keyPropertyNames: ['teamId', 'teamLine'],
        indexes: [
            {
                orderBy: {
                    teamId: 1,
                    teamLine: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TeamEmployee);
//# sourceMappingURL=team-employee.js.map