import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
export declare class StockJournalImport extends Node {
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly isUpdated: Promise<boolean>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly effectiveDate: Promise<date | null>;
    readonly sequence: Promise<integer | null>;
    readonly index: Promise<integer | null>;
    readonly fifoDate: Promise<date | null>;
    readonly fifoTime: Promise<string>;
    readonly fifoTier: Promise<decimal | null>;
    readonly owner: Promise<string>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly supplierLot: Promise<string>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly serialNumber: Promise<string>;
    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly movementDescription: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentId: Promise<string>;
    readonly documentLine: Promise<integer | null>;
    readonly documentTypeOriginal: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentIdOriginal: Promise<string>;
    readonly documentLineOriginal: Promise<integer | null>;
    readonly documentSequenceOriginal: Promise<integer | null>;
    readonly adjustementType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly adjustementDocumentId: Promise<string>;
    readonly adjustementDocumentLineId: Promise<integer | null>;
    readonly lotCustomField1: Promise<string>;
    readonly lotCustomField2: Promise<string>;
    readonly lotCustomField3: Promise<decimal | null>;
    readonly lotCustomField4: Promise<date | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly orginialPackingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly originalPackingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly orderAmount: Promise<decimal | null>;
    readonly movementValue: Promise<decimal | null>;
    readonly orderVariance: Promise<decimal | null>;
    readonly movementVariance: Promise<decimal | null>;
    readonly orderCost: Promise<decimal | null>;
    readonly valuedCost: Promise<decimal | null>;
    readonly costSource: Promise<sageX3StockData.enums.CostSource | null>;
    readonly secondaryMovementValue: Promise<decimal | null>;
    readonly secondaryMovementVariance: Promise<decimal | null>;
    readonly secondaryValuedCost: Promise<decimal | null>;
    readonly secondaryCostSource: Promise<sageX3StockData.enums.CostSource | null>;
    readonly isAdjusted: Promise<boolean>;
    readonly varianceNotAbsorbed: Promise<decimal | null>;
    readonly secondaryVarianceNotAbsorbed: Promise<decimal | null>;
    readonly expirationDate: Promise<date | null>;
    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
    readonly potency: Promise<decimal | null>;
    readonly internationalUnitPotency: Promise<decimal | null>;
    readonly activQuantity: Promise<decimal | null>;
    readonly qualityAnalysisRequestId: Promise<string>;
    readonly isPrinted: Promise<boolean>;
    readonly isAdjustedMovement: Promise<boolean>;
    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
    readonly numberOfLabels: Promise<integer | null>;
    readonly financialSite: Reference<sageX3System.nodes.Site | null>;
    readonly hasStockInterfacePosted: Promise<boolean>;
    readonly hasStockAccountingPosted: Promise<boolean>;
    readonly hasStockAccountingPostedSecondary: Promise<boolean>;
    readonly identifier1: Promise<string>;
    readonly identifier2: Promise<string>;
    readonly intercompany: Promise<boolean>;
    readonly useByDate: Promise<date | null>;
    readonly recontrolDate: Promise<date | null>;
    readonly accountingDate: Promise<date | null>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Promise<string>;
    readonly startingSerialNumber: Promise<string>;
    readonly stockCustomField1: Promise<string>;
    readonly endingSerialNumber: Promise<string>;
    readonly stockCustomField2: Promise<string>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly expirationDateString: Promise<string>;
}
//# sourceMappingURL=stock-journal-import.d.ts.map