declare module '@sage/x3-manufacturing-api-partial' {
    import type { AutomaticJournal, Package as SageX3FinanceData$Package } from '@sage/x3-finance-data-api';
    import type { Package as SageX3InvoicingData$Package } from '@sage/x3-invoicing-data-api';
    import type {
        AssignmentInput,
        Package as SageX3ManufacturingData$Package,
        WorkCenter,
        WorkCenterGroup,
        WorkCenterInput,
    } from '@sage/x3-manufacturing-data-api';
    import type {
        Address,
        BomCodes,
        BomRouting,
        BusinessPartner,
        Container,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategory,
        ProductSite,
        TechnicalSheet,
        UnitOfMeasure,
        WeeklyStructure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3PhysicalFlowsData$Package, Packaging } from '@sage/x3-physical-flows-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type { Package as SageX3SalesData$Package } from '@sage/x3-sales-data-api';
    import type { Package as SageX3Stock$Package } from '@sage/x3-stock-api';
    import type {
        LicensePlateNumber,
        Location,
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        ProductSiteDefaultLocations,
        ProductSiteDefaultLocationsBinding,
        ProductSiteDefaultLocationsInput,
        ProductSiteInternalContainers,
        ProductSiteInternalContainersBinding,
        ProductSiteInternalContainersInput,
        Stock,
        StockJournal,
        StockJournalInput,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type { Access, MiscellaneousTable, Package as SageX3System$Package, Site, User } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface ManufacturingProductType$Enum {
        product: 1;
        byProduct: 2;
    }
    export type ManufacturingProductType = keyof ManufacturingProductType$Enum;
    export interface WorkOrderField$Enum {
        customerNameNumber: 1;
        customerName: 2;
        projectTaskNumber: 3;
        productCategory: 4;
        productLine: 5;
        statisticalAnalysis1: 6;
        statisticalAnalysis2: 7;
        statisticalAnalysis3: 8;
        salesOrderNumber: 9;
    }
    export type WorkOrderField = keyof WorkOrderField$Enum;
    export interface WorkOrderOperationField$Enum {
        laborCenter: 1;
        technicalSheet: 2;
        operationPlanNumber: 3;
        fixture: 4;
        program: 5;
        groupingCriterion: 6;
        distinctionCriteria: 7;
    }
    export type WorkOrderOperationField = keyof WorkOrderOperationField$Enum;
    export interface AttributeLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        attributeCode: Attribute;
        attributeValue: string;
        attributeValueDescription: string;
    }
    export interface AttributeLineInput extends ClientNodeInput {
        attributeCode?: string;
        attributeValue?: string;
        attributeValueDescription?: string;
    }
    export interface AttributeLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        attributeCode: Attribute;
        attributeValue: string;
        attributeValueDescription: string;
    }
    export interface AttributeLine$Lookups {
        attributeCode: QueryOperation<Attribute>;
    }
    export interface AttributeLine$Operations {
        query: QueryOperation<AttributeLine>;
        read: ReadOperation<AttributeLine>;
        aggregate: {
            read: AggregateReadOperation<AttributeLine>;
            query: AggregateQueryOperation<AttributeLine>;
        };
        lookups(dataOrId: string | { data: AttributeLineInput }): AttributeLine$Lookups;
        getDefaults: GetDefaultsOperation<AttributeLine>;
    }
    export interface Attribute extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        attributeCode: string;
        localizedDescription: string;
        attributeLines: ClientCollection<AttributeLine>;
    }
    export interface AttributeInput extends ClientNodeInput {
        attributeCode?: string;
        localizedDescription?: string;
        attributeLines?: Partial<AttributeLineInput>[];
    }
    export interface AttributeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        attributeCode: string;
        localizedDescription: string;
        attributeLines: ClientCollection<AttributeLine>;
    }
    export interface Attribute$Operations {
        query: QueryOperation<Attribute>;
        read: ReadOperation<Attribute>;
        aggregate: {
            read: AggregateReadOperation<Attribute>;
            query: AggregateQueryOperation<Attribute>;
        };
        getDefaults: GetDefaultsOperation<Attribute>;
    }
    export interface CapacityVariationCapacityVariationGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workCenter: string;
        manufacturingSite: string;
        startDate: string;
        endDate: string;
        reason: MiscellaneousTable;
        weeklyStructure: WeeklyStructure;
        numberOfResources: integer;
        text: string;
    }
    export interface CapacityVariationCapacityVariationGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        workCenter?: string;
        manufacturingSite?: string;
        startDate?: string;
        endDate?: string;
        reason?: string;
        weeklyStructure?: string;
        numberOfResources?: integer | string;
        text?: string;
    }
    export interface CapacityVariationCapacityVariationGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workCenter: string;
        manufacturingSite: string;
        startDate: string;
        endDate: string;
        reason: MiscellaneousTable;
        weeklyStructure: WeeklyStructure;
        numberOfResources: integer;
        text: string;
    }
    export interface CapacityVariationCapacityVariationGroups$Lookups {
        reason: QueryOperation<MiscellaneousTable>;
        weeklyStructure: QueryOperation<WeeklyStructure>;
    }
    export interface CapacityVariationCapacityVariationGroups$Operations {
        query: QueryOperation<CapacityVariationCapacityVariationGroups>;
        read: ReadOperation<CapacityVariationCapacityVariationGroups>;
        aggregate: {
            read: AggregateReadOperation<CapacityVariationCapacityVariationGroups>;
            query: AggregateQueryOperation<CapacityVariationCapacityVariationGroups>;
        };
        lookups(
            dataOrId: string | { data: CapacityVariationCapacityVariationGroupsInput },
        ): CapacityVariationCapacityVariationGroups$Lookups;
        getDefaults: GetDefaultsOperation<CapacityVariationCapacityVariationGroups>;
    }
    export interface CapacityVariation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workCenter: string;
        manufacturingSite: Site;
        capacityVariationGroups: ClientCollection<CapacityVariationCapacityVariationGroups>;
    }
    export interface CapacityVariationInput extends ClientNodeInput {
        workCenter?: string;
        manufacturingSite?: string;
        capacityVariationGroups?: Partial<CapacityVariationCapacityVariationGroupsInput>[];
    }
    export interface CapacityVariationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workCenter: string;
        manufacturingSite: Site;
        capacityVariationGroups: ClientCollection<CapacityVariationCapacityVariationGroupsBinding>;
    }
    export interface CapacityVariation$Lookups {
        manufacturingSite: QueryOperation<Site>;
    }
    export interface CapacityVariation$Operations {
        query: QueryOperation<CapacityVariation>;
        read: ReadOperation<CapacityVariation>;
        aggregate: {
            read: AggregateReadOperation<CapacityVariation>;
            query: AggregateQueryOperation<CapacityVariation>;
        };
        lookups(dataOrId: string | { data: CapacityVariationInput }): CapacityVariation$Lookups;
        getDefaults: GetDefaultsOperation<CapacityVariation>;
    }
    export interface FiniteSchedulerCustomValueLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        workOrderCustomField: WorkOrderField;
        workOrderOperationCustomField: WorkOrderOperationField;
    }
    export interface FiniteSchedulerCustomValueLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        workOrderCustomField?: WorkOrderField;
        workOrderOperationCustomField?: WorkOrderOperationField;
    }
    export interface FiniteSchedulerCustomValueLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        workOrderCustomField: WorkOrderField;
        workOrderOperationCustomField: WorkOrderOperationField;
    }
    export interface FiniteSchedulerCustomValueLines$Operations {
        query: QueryOperation<FiniteSchedulerCustomValueLines>;
        read: ReadOperation<FiniteSchedulerCustomValueLines>;
        aggregate: {
            read: AggregateReadOperation<FiniteSchedulerCustomValueLines>;
            query: AggregateQueryOperation<FiniteSchedulerCustomValueLines>;
        };
        getDefaults: GetDefaultsOperation<FiniteSchedulerCustomValueLines>;
    }
    export interface FiniteSchedulerCustomValue extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        default: boolean;
        lines: ClientCollection<FiniteSchedulerCustomValueLines>;
    }
    export interface FiniteSchedulerCustomValueInput extends ClientNodeInput {
        site?: string;
        default?: boolean | string;
        lines?: Partial<FiniteSchedulerCustomValueLinesInput>[];
    }
    export interface FiniteSchedulerCustomValueBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        default: boolean;
        lines: ClientCollection<FiniteSchedulerCustomValueLinesBinding>;
    }
    export interface FiniteSchedulerCustomValue$Lookups {
        site: QueryOperation<Site>;
    }
    export interface FiniteSchedulerCustomValue$Operations {
        query: QueryOperation<FiniteSchedulerCustomValue>;
        read: ReadOperation<FiniteSchedulerCustomValue>;
        aggregate: {
            read: AggregateReadOperation<FiniteSchedulerCustomValue>;
            query: AggregateQueryOperation<FiniteSchedulerCustomValue>;
        };
        lookups(dataOrId: string | { data: FiniteSchedulerCustomValueInput }): FiniteSchedulerCustomValue$Lookups;
        getDefaults: GetDefaultsOperation<FiniteSchedulerCustomValue>;
    }
    export interface FiniteSchedulerObject extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        object: string;
        identifier1: string;
        identifier2: string;
        information1: string;
        information2: string;
        information3: string;
        information4: string;
        createDate: string;
        deletionFlag: boolean;
    }
    export interface FiniteSchedulerObjectInput extends ClientNodeInput {
        site?: string;
        object?: string;
        identifier1?: string;
        identifier2?: string;
        information1?: string;
        information2?: string;
        information3?: string;
        information4?: string;
        createDate?: string;
        deletionFlag?: boolean | string;
    }
    export interface FiniteSchedulerObjectBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        object: string;
        identifier1: string;
        identifier2: string;
        information1: string;
        information2: string;
        information3: string;
        information4: string;
        createDate: string;
        deletionFlag: boolean;
    }
    export interface FiniteSchedulerObject$Mutations {
        maintainFiniteSchedulerObject: Node$Operation<
            {
                parameters?: {
                    object: string;
                    site: string;
                    timestamp: string;
                    oStatus: integer | string;
                    oMessage: string;
                };
            },
            {
                oStatus: integer;
                oMessage: string;
            }
        >;
    }
    export interface FiniteSchedulerObject$Lookups {
        site: QueryOperation<Site>;
    }
    export interface FiniteSchedulerObject$Operations {
        query: QueryOperation<FiniteSchedulerObject>;
        read: ReadOperation<FiniteSchedulerObject>;
        aggregate: {
            read: AggregateReadOperation<FiniteSchedulerObject>;
            query: AggregateQueryOperation<FiniteSchedulerObject>;
        };
        mutations: FiniteSchedulerObject$Mutations;
        lookups(dataOrId: string | { data: FiniteSchedulerObjectInput }): FiniteSchedulerObject$Lookups;
        getDefaults: GetDefaultsOperation<FiniteSchedulerObject>;
    }
    export interface OptimizationLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        optimizationCode: Optimization;
        lineNumber: string;
        setupTimeCode: SetupTime;
    }
    export interface OptimizationLineInput extends ClientNodeInput {
        optimizationCode?: string;
        lineNumber?: string;
        setupTimeCode?: string;
    }
    export interface OptimizationLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        optimizationCode: Optimization;
        lineNumber: string;
        setupTimeCode: SetupTime;
    }
    export interface OptimizationLine$Lookups {
        optimizationCode: QueryOperation<Optimization>;
        setupTimeCode: QueryOperation<SetupTime>;
    }
    export interface OptimizationLine$Operations {
        query: QueryOperation<OptimizationLine>;
        read: ReadOperation<OptimizationLine>;
        aggregate: {
            read: AggregateReadOperation<OptimizationLine>;
            query: AggregateQueryOperation<OptimizationLine>;
        };
        lookups(dataOrId: string | { data: OptimizationLineInput }): OptimizationLine$Lookups;
        getDefaults: GetDefaultsOperation<OptimizationLine>;
    }
    export interface Optimization extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        optimizationCode: string;
        localizedDescription: string;
        setupTimeType: SetupTimeType;
        optimizationLines: ClientCollection<OptimizationLine>;
    }
    export interface OptimizationInput extends ClientNodeInput {
        optimizationCode?: string;
        localizedDescription?: string;
        setupTimeType?: SetupTimeType;
        optimizationLines?: Partial<OptimizationLineInput>[];
    }
    export interface OptimizationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        optimizationCode: string;
        localizedDescription: string;
        setupTimeType: SetupTimeType;
        optimizationLines: ClientCollection<OptimizationLine>;
    }
    export interface Optimization$Operations {
        query: QueryOperation<Optimization>;
        read: ReadOperation<Optimization>;
        aggregate: {
            read: AggregateReadOperation<Optimization>;
            query: AggregateQueryOperation<Optimization>;
        };
        getDefaults: GetDefaultsOperation<Optimization>;
    }
    export interface ProductSiteAttribute extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: ProductSite;
        stockSite: Site;
        attributeCode: Attribute;
        attributeValue: AttributeLine;
    }
    export interface ProductSiteAttributeInput extends ClientNodeInput {
        product?: string;
        stockSite?: string;
        attributeCode?: string;
        attributeValue?: string;
    }
    export interface ProductSiteAttributeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: ProductSite;
        stockSite: Site;
        attributeCode: Attribute;
        attributeValue: AttributeLine;
    }
    export interface ProductSiteAttribute$Lookups {
        product: QueryOperation<ProductSite>;
        stockSite: QueryOperation<Site>;
        attributeCode: QueryOperation<Attribute>;
        attributeValue: QueryOperation<AttributeLine>;
    }
    export interface ProductSiteAttribute$Operations {
        query: QueryOperation<ProductSiteAttribute>;
        read: ReadOperation<ProductSiteAttribute>;
        aggregate: {
            read: AggregateReadOperation<ProductSiteAttribute>;
            query: AggregateQueryOperation<ProductSiteAttribute>;
        };
        lookups(dataOrId: string | { data: ProductSiteAttributeInput }): ProductSiteAttribute$Lookups;
        getDefaults: GetDefaultsOperation<ProductSiteAttribute>;
    }
    export interface RoutingHeader extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        routing: Product;
        routingCode: BomRouting;
        site: Site;
        description: string;
        useStatus: UseStatus;
        isValidated: boolean;
        validityStartDate: string;
        validityEndDate: string;
        timeUnit: TimeUnitCode;
        workOrderManagementMode: WorkOrderManagementMode;
        routingHeaderText: string;
        routingHeaderPlan: string;
        routingHeaderImage: string;
        minimumReleaseQuantity: string;
        maximumReleaseQuantity: string;
        lastReleaseQuantity: string;
        lastReleaseDate: string;
        journalNumberConfig: string;
        accessCode: Access;
    }
    export interface RoutingHeaderInput extends ClientNodeInput {
        routing?: string;
        routingCode?: integer | string;
        site?: string;
        description?: string;
        useStatus?: UseStatus;
        isValidated?: boolean | string;
        validityStartDate?: string;
        validityEndDate?: string;
        timeUnit?: TimeUnitCode;
        workOrderManagementMode?: WorkOrderManagementMode;
        routingHeaderText?: string;
        routingHeaderPlan?: string;
        routingHeaderImage?: string;
        minimumReleaseQuantity?: decimal | string;
        maximumReleaseQuantity?: decimal | string;
        lastReleaseQuantity?: decimal | string;
        lastReleaseDate?: string;
        journalNumberConfig?: string;
        accessCode?: string;
    }
    export interface RoutingHeaderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        routing: Product;
        routingCode: BomRouting;
        site: Site;
        description: string;
        useStatus: UseStatus;
        isValidated: boolean;
        validityStartDate: string;
        validityEndDate: string;
        timeUnit: TimeUnitCode;
        workOrderManagementMode: WorkOrderManagementMode;
        routingHeaderText: string;
        routingHeaderPlan: string;
        routingHeaderImage: string;
        minimumReleaseQuantity: string;
        maximumReleaseQuantity: string;
        lastReleaseQuantity: string;
        lastReleaseDate: string;
        journalNumberConfig: string;
        accessCode: Access;
    }
    export interface RoutingHeader$Lookups {
        routing: QueryOperation<Product>;
        routingCode: QueryOperation<BomRouting>;
        site: QueryOperation<Site>;
        accessCode: QueryOperation<Access>;
    }
    export interface RoutingHeader$Operations {
        query: QueryOperation<RoutingHeader>;
        read: ReadOperation<RoutingHeader>;
        aggregate: {
            read: AggregateReadOperation<RoutingHeader>;
            query: AggregateQueryOperation<RoutingHeader>;
        };
        lookups(dataOrId: string | { data: RoutingHeaderInput }): RoutingHeader$Lookups;
        getDefaults: GetDefaultsOperation<RoutingHeader>;
    }
    export interface RoutingOperation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        routing: Product;
        routingCode: RoutingHeader;
        operationNumber: integer;
        alternateIndex: integer;
        startDate: string;
        endDate: string;
        standardOperation: StandardOperations;
        mainWorkCenter: WorkCenter;
        laborWorkCenter: WorkCenter;
        laborTimeSetupFactor: string;
        laborRunTimeFactor: string;
        operationDescription: string;
        stockOperationConversion: string;
        stockOperationFormula: string;
        operationPlan: string;
        operationImage: string;
        technicalSheet: string;
        tools: Product;
        fixture: string;
        program: string;
        numberOfRessources: integer;
        numberLaborRessources: integer;
        efficiencyPercentage: string;
        shrinkagePercentage: string;
        runTimeType: RunTimeType;
        managementUnit: OperationTimeCodes;
        baseQuantity: string;
        preparationTime: string;
        setupTime: string;
        runTime: string;
        rate: string;
        waitingTime: string;
        postRunTime: string;
        subcontractCode: Subcontracting;
        subcontractedProducts: Product;
        subcontractWorkCenter: WorkCenter;
        businessPartner: BusinessPartner;
        businessPartnerAddress: Address;
        referencePrice: string;
        splitting: Splitting;
        maximumSplits: integer;
        operationSuffix: integer;
        isRoutingCodeOperation: boolean;
        machineRestriction: string;
        groupingCriterion: string;
        groupingFormula: string;
        distinctionCriteria: string;
        distinctionFormula: string;
        groupSetupTime: string;
    }
    export interface RoutingOperationInput extends ClientNodeInput {
        site?: string;
        routing?: string;
        routingCode?: string;
        operationNumber?: integer | string;
        alternateIndex?: integer | string;
        startDate?: string;
        endDate?: string;
        standardOperation?: string;
        mainWorkCenter?: string;
        laborWorkCenter?: string;
        laborTimeSetupFactor?: decimal | string;
        laborRunTimeFactor?: decimal | string;
        operationDescription?: string;
        stockOperationConversion?: decimal | string;
        stockOperationFormula?: string;
        operationPlan?: string;
        operationImage?: string;
        technicalSheet?: string;
        tools?: string;
        fixture?: string;
        program?: string;
        numberOfRessources?: integer | string;
        numberLaborRessources?: integer | string;
        efficiencyPercentage?: decimal | string;
        shrinkagePercentage?: decimal | string;
        runTimeType?: RunTimeType;
        managementUnit?: OperationTimeCodes;
        baseQuantity?: decimal | string;
        preparationTime?: decimal | string;
        setupTime?: decimal | string;
        runTime?: decimal | string;
        rate?: decimal | string;
        waitingTime?: decimal | string;
        postRunTime?: decimal | string;
        subcontractCode?: Subcontracting;
        subcontractedProducts?: string;
        subcontractWorkCenter?: string;
        businessPartner?: string;
        businessPartnerAddress?: string;
        referencePrice?: decimal | string;
        splitting?: Splitting;
        maximumSplits?: integer | string;
        operationSuffix?: integer | string;
        isRoutingCodeOperation?: boolean | string;
        machineRestriction?: string;
        groupingCriterion?: string;
        groupingFormula?: string;
        distinctionCriteria?: string;
        distinctionFormula?: string;
        groupSetupTime?: decimal | string;
    }
    export interface RoutingOperationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        routing: Product;
        routingCode: RoutingHeader;
        operationNumber: integer;
        alternateIndex: integer;
        startDate: string;
        endDate: string;
        standardOperation: StandardOperations;
        mainWorkCenter: WorkCenter;
        laborWorkCenter: WorkCenter;
        laborTimeSetupFactor: string;
        laborRunTimeFactor: string;
        operationDescription: string;
        stockOperationConversion: string;
        stockOperationFormula: string;
        operationPlan: string;
        operationImage: string;
        technicalSheet: string;
        tools: Product;
        fixture: string;
        program: string;
        numberOfRessources: integer;
        numberLaborRessources: integer;
        efficiencyPercentage: string;
        shrinkagePercentage: string;
        runTimeType: RunTimeType;
        managementUnit: OperationTimeCodes;
        baseQuantity: string;
        preparationTime: string;
        setupTime: string;
        runTime: string;
        rate: string;
        waitingTime: string;
        postRunTime: string;
        subcontractCode: Subcontracting;
        subcontractedProducts: Product;
        subcontractWorkCenter: WorkCenter;
        businessPartner: BusinessPartner;
        businessPartnerAddress: Address;
        referencePrice: string;
        splitting: Splitting;
        maximumSplits: integer;
        operationSuffix: integer;
        isRoutingCodeOperation: boolean;
        machineRestriction: string;
        groupingCriterion: string;
        groupingFormula: string;
        distinctionCriteria: string;
        distinctionFormula: string;
        groupSetupTime: string;
    }
    export interface RoutingOperation$Lookups {
        site: QueryOperation<Site>;
        routing: QueryOperation<Product>;
        routingCode: QueryOperation<RoutingHeader>;
        standardOperation: QueryOperation<StandardOperations>;
        mainWorkCenter: QueryOperation<WorkCenter>;
        laborWorkCenter: QueryOperation<WorkCenter>;
        tools: QueryOperation<Product>;
        subcontractedProducts: QueryOperation<Product>;
        subcontractWorkCenter: QueryOperation<WorkCenter>;
        businessPartner: QueryOperation<BusinessPartner>;
        businessPartnerAddress: QueryOperation<Address>;
    }
    export interface RoutingOperation$Operations {
        query: QueryOperation<RoutingOperation>;
        read: ReadOperation<RoutingOperation>;
        aggregate: {
            read: AggregateReadOperation<RoutingOperation>;
            query: AggregateQueryOperation<RoutingOperation>;
        };
        lookups(dataOrId: string | { data: RoutingOperationInput }): RoutingOperation$Lookups;
        getDefaults: GetDefaultsOperation<RoutingOperation>;
    }
    export interface RoutingScheduling extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        routing: Product;
        routingCode: integer;
        operationNumber: integer;
        downstreamOperation: integer;
        milestone: ScheduleType;
        isProductionStep: boolean;
        schedulingCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        numberOfOverlappingLots: string;
    }
    export interface RoutingSchedulingInput extends ClientNodeInput {
        site?: string;
        routing?: string;
        routingCode?: integer | string;
        operationNumber?: integer | string;
        downstreamOperation?: integer | string;
        milestone?: ScheduleType;
        isProductionStep?: boolean | string;
        schedulingCode?: SchedulingCode;
        overlappingTime?: decimal | string;
        overlappingQuantity?: decimal | string;
        numberOfOverlappingLots?: decimal | string;
    }
    export interface RoutingSchedulingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        routing: Product;
        routingCode: integer;
        operationNumber: integer;
        downstreamOperation: integer;
        milestone: ScheduleType;
        isProductionStep: boolean;
        schedulingCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        numberOfOverlappingLots: string;
    }
    export interface RoutingScheduling$Lookups {
        site: QueryOperation<Site>;
        routing: QueryOperation<Product>;
    }
    export interface RoutingScheduling$Operations {
        query: QueryOperation<RoutingScheduling>;
        read: ReadOperation<RoutingScheduling>;
        aggregate: {
            read: AggregateReadOperation<RoutingScheduling>;
            query: AggregateQueryOperation<RoutingScheduling>;
        };
        lookups(dataOrId: string | { data: RoutingSchedulingInput }): RoutingScheduling$Lookups;
        getDefaults: GetDefaultsOperation<RoutingScheduling>;
    }
    export interface RoutingVersion extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: RoutingHeader;
        site: Site;
        majorVersion: string;
        minorVersion: string;
        sequence: integer;
        useStatus: UseStatus;
        routingCode: integer;
        startDate: string;
        endDate: string;
        isDerogation: boolean;
        exceptionDate: string;
    }
    export interface RoutingVersionInput extends ClientNodeInput {
        product?: string;
        site?: string;
        majorVersion?: string;
        minorVersion?: string;
        sequence?: integer | string;
        useStatus?: UseStatus;
        routingCode?: integer | string;
        startDate?: string;
        endDate?: string;
        isDerogation?: boolean | string;
        exceptionDate?: string;
    }
    export interface RoutingVersionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: RoutingHeader;
        site: Site;
        majorVersion: string;
        minorVersion: string;
        sequence: integer;
        useStatus: UseStatus;
        routingCode: integer;
        startDate: string;
        endDate: string;
        isDerogation: boolean;
        exceptionDate: string;
    }
    export interface RoutingVersion$Lookups {
        product: QueryOperation<RoutingHeader>;
        site: QueryOperation<Site>;
    }
    export interface RoutingVersion$Operations {
        query: QueryOperation<RoutingVersion>;
        read: ReadOperation<RoutingVersion>;
        aggregate: {
            read: AggregateReadOperation<RoutingVersion>;
            query: AggregateQueryOperation<RoutingVersion>;
        };
        lookups(dataOrId: string | { data: RoutingVersionInput }): RoutingVersion$Lookups;
        getDefaults: GetDefaultsOperation<RoutingVersion>;
    }
    export interface SetupTimeException extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        setupTimeCode: SetupTime;
        lineNumber: string;
        fromAttributeValue: string;
        toAttributeValue: string;
        setupTime: string;
    }
    export interface SetupTimeExceptionInput extends ClientNodeInput {
        setupTimeCode?: string;
        lineNumber?: string;
        fromAttributeValue?: string;
        toAttributeValue?: string;
        setupTime?: decimal | string;
    }
    export interface SetupTimeExceptionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        setupTimeCode: SetupTime;
        lineNumber: string;
        fromAttributeValue: string;
        toAttributeValue: string;
        setupTime: string;
    }
    export interface SetupTimeException$Lookups {
        setupTimeCode: QueryOperation<SetupTime>;
    }
    export interface SetupTimeException$Operations {
        query: QueryOperation<SetupTimeException>;
        read: ReadOperation<SetupTimeException>;
        aggregate: {
            read: AggregateReadOperation<SetupTimeException>;
            query: AggregateQueryOperation<SetupTimeException>;
        };
        lookups(dataOrId: string | { data: SetupTimeExceptionInput }): SetupTimeException$Lookups;
        getDefaults: GetDefaultsOperation<SetupTimeException>;
    }
    export interface SetupTime extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        setupTimeCode: string;
        localizedDescription: string;
        attributeCode: Attribute;
        setupTimeDifferent: string;
        setupTimeSame: string;
        setupTimeExceptions: ClientCollection<SetupTimeException>;
    }
    export interface SetupTimeInput extends ClientNodeInput {
        setupTimeCode?: string;
        localizedDescription?: string;
        attributeCode?: string;
        setupTimeDifferent?: decimal | string;
        setupTimeSame?: decimal | string;
        setupTimeExceptions?: Partial<SetupTimeExceptionInput>[];
    }
    export interface SetupTimeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        setupTimeCode: string;
        localizedDescription: string;
        attributeCode: Attribute;
        setupTimeDifferent: string;
        setupTimeSame: string;
        setupTimeExceptions: ClientCollection<SetupTimeException>;
    }
    export interface SetupTime$Lookups {
        attributeCode: QueryOperation<Attribute>;
    }
    export interface SetupTime$Operations {
        query: QueryOperation<SetupTime>;
        read: ReadOperation<SetupTime>;
        aggregate: {
            read: AggregateReadOperation<SetupTime>;
            query: AggregateQueryOperation<SetupTime>;
        };
        lookups(dataOrId: string | { data: SetupTimeInput }): SetupTime$Lookups;
        getDefaults: GetDefaultsOperation<SetupTime>;
    }
    export interface StandardOperations extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        site: Site;
        description: string;
        mainWorkCenter: WorkCenter;
        workCenterGroup: WorkCenterGroup;
        mainWorkCenterType: WorkCenterType;
        laborWorkCenter: WorkCenter;
        laborWorkCenterGroup: WorkCenterGroup;
        laborWorkCenterType: WorkCenterType;
        laborTimeSetupFactor: string;
        laborRunTimeFactor: string;
        timeUnit: TimeUnitCode;
        managementUnit: OperationTimeCodes;
        baseQuantity: string;
        operationUom: UnitOfMeasure;
        operationPlan: string;
        operationImage: string;
        operationText: string;
        technicalSheet: TechnicalSheet;
        tools: Product;
        fixture: string;
        program: string;
        numberOfRessources: integer;
        numberLaborRessources: integer;
        efficiencyPercentage: string;
        shrinkagePercentage: string;
        runTimeType: RunTimeType;
        preparationTime: string;
        setupTime: string;
        runTime: string;
        rate: string;
        waitingTime: string;
        postRunTime: string;
        subcontractCode: Subcontracting;
        subcontractedProducts: Product;
        subcontractWorkCenter: WorkCenter;
        subcontractWorkCenterGroup: WorkCenterGroup;
        businessPartner: BusinessPartner;
        businessPartnerAddress: Address;
        referencePrice: string;
        splitting: Splitting;
        maximumSplits: integer;
        machineRestriction: string;
        groupingCriterion: string;
        groupingFormula: string;
        groupSetupTime: string;
    }
    export interface StandardOperationsInput extends ClientNodeInput {
        code?: integer | string;
        site?: string;
        description?: string;
        mainWorkCenter?: string;
        workCenterGroup?: string;
        mainWorkCenterType?: WorkCenterType;
        laborWorkCenter?: string;
        laborWorkCenterGroup?: string;
        laborWorkCenterType?: WorkCenterType;
        laborTimeSetupFactor?: decimal | string;
        laborRunTimeFactor?: decimal | string;
        timeUnit?: TimeUnitCode;
        managementUnit?: OperationTimeCodes;
        baseQuantity?: decimal | string;
        operationUom?: string;
        operationPlan?: string;
        operationImage?: string;
        operationText?: string;
        technicalSheet?: string;
        tools?: string;
        fixture?: string;
        program?: string;
        numberOfRessources?: integer | string;
        numberLaborRessources?: integer | string;
        efficiencyPercentage?: decimal | string;
        shrinkagePercentage?: decimal | string;
        runTimeType?: RunTimeType;
        preparationTime?: decimal | string;
        setupTime?: decimal | string;
        runTime?: decimal | string;
        rate?: decimal | string;
        waitingTime?: decimal | string;
        postRunTime?: decimal | string;
        subcontractCode?: Subcontracting;
        subcontractedProducts?: string;
        subcontractWorkCenter?: string;
        subcontractWorkCenterGroup?: string;
        businessPartner?: string;
        businessPartnerAddress?: string;
        referencePrice?: decimal | string;
        splitting?: Splitting;
        maximumSplits?: integer | string;
        machineRestriction?: string;
        groupingCriterion?: string;
        groupingFormula?: string;
        groupSetupTime?: decimal | string;
    }
    export interface StandardOperationsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        site: Site;
        description: string;
        mainWorkCenter: WorkCenter;
        workCenterGroup: WorkCenterGroup;
        mainWorkCenterType: WorkCenterType;
        laborWorkCenter: WorkCenter;
        laborWorkCenterGroup: WorkCenterGroup;
        laborWorkCenterType: WorkCenterType;
        laborTimeSetupFactor: string;
        laborRunTimeFactor: string;
        timeUnit: TimeUnitCode;
        managementUnit: OperationTimeCodes;
        baseQuantity: string;
        operationUom: UnitOfMeasure;
        operationPlan: string;
        operationImage: string;
        operationText: string;
        technicalSheet: TechnicalSheet;
        tools: Product;
        fixture: string;
        program: string;
        numberOfRessources: integer;
        numberLaborRessources: integer;
        efficiencyPercentage: string;
        shrinkagePercentage: string;
        runTimeType: RunTimeType;
        preparationTime: string;
        setupTime: string;
        runTime: string;
        rate: string;
        waitingTime: string;
        postRunTime: string;
        subcontractCode: Subcontracting;
        subcontractedProducts: Product;
        subcontractWorkCenter: WorkCenter;
        subcontractWorkCenterGroup: WorkCenterGroup;
        businessPartner: BusinessPartner;
        businessPartnerAddress: Address;
        referencePrice: string;
        splitting: Splitting;
        maximumSplits: integer;
        machineRestriction: string;
        groupingCriterion: string;
        groupingFormula: string;
        groupSetupTime: string;
    }
    export interface StandardOperations$Lookups {
        site: QueryOperation<Site>;
        mainWorkCenter: QueryOperation<WorkCenter>;
        workCenterGroup: QueryOperation<WorkCenterGroup>;
        laborWorkCenter: QueryOperation<WorkCenter>;
        laborWorkCenterGroup: QueryOperation<WorkCenterGroup>;
        operationUom: QueryOperation<UnitOfMeasure>;
        technicalSheet: QueryOperation<TechnicalSheet>;
        tools: QueryOperation<Product>;
        subcontractedProducts: QueryOperation<Product>;
        subcontractWorkCenter: QueryOperation<WorkCenter>;
        subcontractWorkCenterGroup: QueryOperation<WorkCenterGroup>;
        businessPartner: QueryOperation<BusinessPartner>;
        businessPartnerAddress: QueryOperation<Address>;
    }
    export interface StandardOperations$Operations {
        query: QueryOperation<StandardOperations>;
        read: ReadOperation<StandardOperations>;
        aggregate: {
            read: AggregateReadOperation<StandardOperations>;
            query: AggregateQueryOperation<StandardOperations>;
        };
        lookups(dataOrId: string | { data: StandardOperationsInput }): StandardOperations$Lookups;
        getDefaults: GetDefaultsOperation<StandardOperations>;
    }
    export interface TransactionProductionReporting extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        type: integer;
        transaction: string;
        localizedDescription: string;
        description: string;
        accessCode: Access;
        isActive: boolean;
        group: SiteGroupings;
        isWorkOrderTracking: boolean;
        isRoutingTracking: boolean;
        isWorkCenterTracking: boolean;
        isBomTracking: boolean;
        employeeEntry: EnterMeasurement;
        isProductionReporting: boolean;
        isMaterialConsumption: boolean;
        stockWithdrawalMode: StockWithdrawalMode;
        sortCriteria1: OperationSortCriteria;
        sortCriteria2: OperationSortCriteria;
        materialConsumption: MaterialConsumptionMode;
        isManualOnly: boolean;
        releaseQuantity: DefaultQuantity;
        isUnitCanBeModified: boolean;
        defaultUnit: EntryUnit;
        isPreloading: boolean;
        automaticJournal: AutomaticJournal;
        isUOMEntry: boolean;
        isEnterPac: boolean;
        labelPrinting: LabelPrinting;
        formTableEntryModePrinting: FormOrTableEntryMode;
        isNumberOfPrints: boolean;
        formTableEntryModeNumberOfPrints: FormOrTableEntryMode;
        entryModeAvailableStock: EntryMode;
        formTableEntryModeAvailableStock: FormOrTableEntryMode;
        isExpiration: boolean;
        isPotency: boolean;
        isLotCustomText1: boolean;
        isLotCustomText2: boolean;
        isLotCustomNumber: boolean;
        isLotCustomDate: boolean;
        entryModeAnalyticalDimension: EntryMode;
        isAutomaticIssue: boolean;
        isReceiptAtDock: boolean;
        materialFilterOperation: FilterOperations;
        productFilterOperation: FilterOperations;
        entryModeWarehouse: EntryMode;
        isSingleWarehouse: boolean;
        unplannedMaterials: boolean;
        unplannedOperations: boolean;
    }
    export interface TransactionProductionReportingInput extends ClientNodeInput {
        type?: integer | string;
        transaction?: string;
        localizedDescription?: string;
        description?: string;
        accessCode?: string;
        isActive?: boolean | string;
        group?: string;
        isWorkOrderTracking?: boolean | string;
        isRoutingTracking?: boolean | string;
        isWorkCenterTracking?: boolean | string;
        isBomTracking?: boolean | string;
        employeeEntry?: EnterMeasurement;
        isProductionReporting?: boolean | string;
        isMaterialConsumption?: boolean | string;
        stockWithdrawalMode?: StockWithdrawalMode;
        sortCriteria1?: OperationSortCriteria;
        sortCriteria2?: OperationSortCriteria;
        materialConsumption?: MaterialConsumptionMode;
        isManualOnly?: boolean | string;
        releaseQuantity?: DefaultQuantity;
        isUnitCanBeModified?: boolean | string;
        defaultUnit?: EntryUnit;
        isPreloading?: boolean | string;
        automaticJournal?: string;
        isUOMEntry?: boolean | string;
        isEnterPac?: boolean | string;
        labelPrinting?: LabelPrinting;
        formTableEntryModePrinting?: FormOrTableEntryMode;
        isNumberOfPrints?: boolean | string;
        formTableEntryModeNumberOfPrints?: FormOrTableEntryMode;
        entryModeAvailableStock?: EntryMode;
        formTableEntryModeAvailableStock?: FormOrTableEntryMode;
        isExpiration?: boolean | string;
        isPotency?: boolean | string;
        isLotCustomText1?: boolean | string;
        isLotCustomText2?: boolean | string;
        isLotCustomNumber?: boolean | string;
        isLotCustomDate?: boolean | string;
        entryModeAnalyticalDimension?: EntryMode;
        isAutomaticIssue?: boolean | string;
        isReceiptAtDock?: boolean | string;
        materialFilterOperation?: FilterOperations;
        productFilterOperation?: FilterOperations;
        entryModeWarehouse?: EntryMode;
        isSingleWarehouse?: boolean | string;
        unplannedMaterials?: boolean | string;
        unplannedOperations?: boolean | string;
    }
    export interface TransactionProductionReportingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        type: integer;
        transaction: string;
        localizedDescription: string;
        description: string;
        accessCode: Access;
        isActive: boolean;
        group: SiteGroupings;
        isWorkOrderTracking: boolean;
        isRoutingTracking: boolean;
        isWorkCenterTracking: boolean;
        isBomTracking: boolean;
        employeeEntry: EnterMeasurement;
        isProductionReporting: boolean;
        isMaterialConsumption: boolean;
        stockWithdrawalMode: StockWithdrawalMode;
        sortCriteria1: OperationSortCriteria;
        sortCriteria2: OperationSortCriteria;
        materialConsumption: MaterialConsumptionMode;
        isManualOnly: boolean;
        releaseQuantity: DefaultQuantity;
        isUnitCanBeModified: boolean;
        defaultUnit: EntryUnit;
        isPreloading: boolean;
        automaticJournal: AutomaticJournal;
        isUOMEntry: boolean;
        isEnterPac: boolean;
        labelPrinting: LabelPrinting;
        formTableEntryModePrinting: FormOrTableEntryMode;
        isNumberOfPrints: boolean;
        formTableEntryModeNumberOfPrints: FormOrTableEntryMode;
        entryModeAvailableStock: EntryMode;
        formTableEntryModeAvailableStock: FormOrTableEntryMode;
        isExpiration: boolean;
        isPotency: boolean;
        isLotCustomText1: boolean;
        isLotCustomText2: boolean;
        isLotCustomNumber: boolean;
        isLotCustomDate: boolean;
        entryModeAnalyticalDimension: EntryMode;
        isAutomaticIssue: boolean;
        isReceiptAtDock: boolean;
        materialFilterOperation: FilterOperations;
        productFilterOperation: FilterOperations;
        entryModeWarehouse: EntryMode;
        isSingleWarehouse: boolean;
        unplannedMaterials: boolean;
        unplannedOperations: boolean;
    }
    export interface TransactionProductionReporting$Lookups {
        accessCode: QueryOperation<Access>;
        group: QueryOperation<SiteGroupings>;
        automaticJournal: QueryOperation<AutomaticJournal>;
    }
    export interface TransactionProductionReporting$Operations {
        query: QueryOperation<TransactionProductionReporting>;
        read: ReadOperation<TransactionProductionReporting>;
        aggregate: {
            read: AggregateReadOperation<TransactionProductionReporting>;
            query: AggregateQueryOperation<TransactionProductionReporting>;
        };
        lookups(
            dataOrId: string | { data: TransactionProductionReportingInput },
        ): TransactionProductionReporting$Lookups;
        getDefaults: GetDefaultsOperation<TransactionProductionReporting>;
    }
    export interface WorkCenterReplacementWorkCenterReplacementLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workCenter: string;
        manufacturingSite: string;
        replacementworkCenter: WorkCenter;
        replacementworkCenterDescription: string;
        workCenterGroup: WorkCenterGroup;
        workCenterType: WorkCenterType;
        priority: integer;
    }
    export interface WorkCenterReplacementWorkCenterReplacementLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        workCenter?: string;
        manufacturingSite?: string;
        replacementworkCenter?: string;
        replacementworkCenterDescription?: string;
        workCenterGroup?: string;
        workCenterType?: WorkCenterType;
        priority?: integer | string;
    }
    export interface WorkCenterReplacementWorkCenterReplacementLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workCenter: string;
        manufacturingSite: string;
        replacementworkCenter: WorkCenter;
        replacementworkCenterDescription: string;
        workCenterGroup: WorkCenterGroup;
        workCenterType: WorkCenterType;
        priority: integer;
    }
    export interface WorkCenterReplacementWorkCenterReplacementLines$Lookups {
        replacementworkCenter: QueryOperation<WorkCenter>;
        workCenterGroup: QueryOperation<WorkCenterGroup>;
    }
    export interface WorkCenterReplacementWorkCenterReplacementLines$Operations {
        query: QueryOperation<WorkCenterReplacementWorkCenterReplacementLines>;
        read: ReadOperation<WorkCenterReplacementWorkCenterReplacementLines>;
        aggregate: {
            read: AggregateReadOperation<WorkCenterReplacementWorkCenterReplacementLines>;
            query: AggregateQueryOperation<WorkCenterReplacementWorkCenterReplacementLines>;
        };
        lookups(
            dataOrId: string | { data: WorkCenterReplacementWorkCenterReplacementLinesInput },
        ): WorkCenterReplacementWorkCenterReplacementLines$Lookups;
        getDefaults: GetDefaultsOperation<WorkCenterReplacementWorkCenterReplacementLines>;
    }
    export interface WorkCenterReplacement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workCenter: string;
        manufacturingSite: Site;
        workCenterReplacementLines: ClientCollection<WorkCenterReplacementWorkCenterReplacementLines>;
    }
    export interface WorkCenterReplacementInput extends ClientNodeInput {
        workCenter?: string;
        manufacturingSite?: string;
        workCenterReplacementLines?: Partial<WorkCenterReplacementWorkCenterReplacementLinesInput>[];
    }
    export interface WorkCenterReplacementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workCenter: string;
        manufacturingSite: Site;
        workCenterReplacementLines: ClientCollection<WorkCenterReplacementWorkCenterReplacementLinesBinding>;
    }
    export interface WorkCenterReplacement$Lookups {
        manufacturingSite: QueryOperation<Site>;
    }
    export interface WorkCenterReplacement$Operations {
        query: QueryOperation<WorkCenterReplacement>;
        read: ReadOperation<WorkCenterReplacement>;
        aggregate: {
            read: AggregateReadOperation<WorkCenterReplacement>;
            query: AggregateQueryOperation<WorkCenterReplacement>;
        };
        lookups(dataOrId: string | { data: WorkCenterReplacementInput }): WorkCenterReplacement$Lookups;
        getDefaults: GetDefaultsOperation<WorkCenterReplacement>;
    }
    export interface WorkOrderMaterialLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        number: WorkOrder;
        lineNumber: WorkOrderProductLine;
        bomSequence: integer;
        product: Product;
        productionSite: Site;
        requirementDate: string;
        bomOperationNumber: integer;
        cumulTotalQuantity: string;
        bomUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        bomUnitStockFactor: string;
        requiredQuantity: string;
        consumedQuantity: string;
        allocatedQuantity: string;
        shortageQuantity: string;
        location: Location;
        materialStatus: ProductionStatus;
        componentType: ComponentType;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
    }
    export interface WorkOrderMaterialLineInput extends ClientNodeInput {
        number?: string;
        lineNumber?: integer | string;
        bomSequence?: integer | string;
        product?: string;
        productionSite?: string;
        requirementDate?: string;
        bomOperationNumber?: integer | string;
        cumulTotalQuantity?: decimal | string;
        bomUnit?: string;
        stockUnit?: string;
        bomUnitStockFactor?: decimal | string;
        requiredQuantity?: decimal | string;
        consumedQuantity?: decimal | string;
        allocatedQuantity?: decimal | string;
        shortageQuantity?: decimal | string;
        location?: string;
        materialStatus?: ProductionStatus;
        componentType?: ComponentType;
        majorProductVersion?: string;
        minorProductVersion?: string;
    }
    export interface WorkOrderMaterialLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        number: WorkOrder;
        lineNumber: WorkOrderProductLine;
        bomSequence: integer;
        product: Product;
        productionSite: Site;
        requirementDate: string;
        bomOperationNumber: integer;
        cumulTotalQuantity: string;
        bomUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        bomUnitStockFactor: string;
        requiredQuantity: string;
        consumedQuantity: string;
        allocatedQuantity: string;
        shortageQuantity: string;
        location: Location;
        materialStatus: ProductionStatus;
        componentType: ComponentType;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
    }
    export interface WorkOrderMaterialLine$Lookups {
        number: QueryOperation<WorkOrder>;
        lineNumber: QueryOperation<WorkOrderProductLine>;
        product: QueryOperation<Product>;
        productionSite: QueryOperation<Site>;
        bomUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        location: QueryOperation<Location>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
    }
    export interface WorkOrderMaterialLine$Operations {
        query: QueryOperation<WorkOrderMaterialLine>;
        read: ReadOperation<WorkOrderMaterialLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderMaterialLine>;
            query: AggregateQueryOperation<WorkOrderMaterialLine>;
        };
        lookups(dataOrId: string | { data: WorkOrderMaterialLineInput }): WorkOrderMaterialLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderMaterialLine>;
    }
    export interface WorkOrderMaterialTrackingLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        mfgTrackingNumber: string;
        materialTrackingLine: integer;
        workOrder: string;
        lineNumber: integer;
        bomNumber: Product;
        bomAlternative: BomCodes;
        product: ProductSite;
        productionSite: Site;
        consumedQuantity: string;
        bomSequence: integer;
        preferredLot: string;
        project: ProjectLink;
        stockJournal: ClientCollection<StockJournal>;
        workOrderMaterialTracking: WorkOrderMaterialTracking;
    }
    export interface WorkOrderMaterialTrackingLineInput extends ClientNodeInput {
        mfgTrackingNumber?: string;
        materialTrackingLine?: integer | string;
        workOrder?: string;
        lineNumber?: integer | string;
        bomNumber?: string;
        bomAlternative?: integer | string;
        product?: string;
        productionSite?: string;
        consumedQuantity?: decimal | string;
        bomSequence?: integer | string;
        preferredLot?: string;
        project?: string;
        stockJournal?: Partial<StockJournalInput>[];
        workOrderMaterialTracking?: string;
        balance?: decimal | string;
        postingDate?: string;
        transaction?: string;
    }
    export interface WorkOrderMaterialTrackingLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        mfgTrackingNumber: string;
        materialTrackingLine: integer;
        workOrder: string;
        lineNumber: integer;
        bomNumber: Product;
        bomAlternative: BomCodes;
        product: ProductSite;
        productionSite: Site;
        consumedQuantity: string;
        bomSequence: integer;
        preferredLot: string;
        project: ProjectLink;
        stockJournal: ClientCollection<StockJournal>;
        workOrderMaterialTracking: WorkOrderMaterialTracking;
        balance: string;
        postingDate: string;
        transaction: string;
    }
    export interface WorkOrderMaterialTrackingLine$Lookups {
        bomNumber: QueryOperation<Product>;
        bomAlternative: QueryOperation<BomCodes>;
        product: QueryOperation<ProductSite>;
        productionSite: QueryOperation<Site>;
        project: QueryOperation<ProjectLink>;
        workOrderMaterialTracking: QueryOperation<WorkOrderMaterialTracking>;
    }
    export interface WorkOrderMaterialTrackingLine$Operations {
        query: QueryOperation<WorkOrderMaterialTrackingLine>;
        read: ReadOperation<WorkOrderMaterialTrackingLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderMaterialTrackingLine>;
            query: AggregateQueryOperation<WorkOrderMaterialTrackingLine>;
        };
        lookups(dataOrId: string | { data: WorkOrderMaterialTrackingLineInput }): WorkOrderMaterialTrackingLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderMaterialTrackingLine>;
    }
    export interface WorkOrderMaterialTracking extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderMaterialTrackingLines: ClientCollection<WorkOrderMaterialTrackingLine>;
    }
    export interface WorkOrderMaterialTrackingInput extends ClientNodeInput {
        trackingNumber?: string;
        productionSite?: string;
        workOrderMaterialTrackingLines?: Partial<WorkOrderMaterialTrackingLineInput>[];
    }
    export interface WorkOrderMaterialTrackingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderMaterialTrackingLines: ClientCollection<WorkOrderMaterialTrackingLine>;
    }
    export interface WorkOrderMaterialTracking$Lookups {
        productionSite: QueryOperation<Site>;
    }
    export interface WorkOrderMaterialTracking$Operations {
        query: QueryOperation<WorkOrderMaterialTracking>;
        read: ReadOperation<WorkOrderMaterialTracking>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderMaterialTracking>;
            query: AggregateQueryOperation<WorkOrderMaterialTracking>;
        };
        create: CreateOperation<WorkOrderMaterialTrackingInput, WorkOrderMaterialTracking>;
        getDuplicate: GetDuplicateOperation<WorkOrderMaterialTracking>;
        lookups(dataOrId: string | { data: WorkOrderMaterialTrackingInput }): WorkOrderMaterialTracking$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderMaterialTracking>;
    }
    export interface WorkOrderOperationLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: WorkOrder;
        operationNumber: integer;
        operationSplit: integer;
        manufacturingSite: Site;
        expectedWorkCenter: WorkCenter;
        actualWorkCenter: WorkCenter;
        laborWorkCenter: WorkCenter;
        actualLaborWorkCenter: WorkCenter;
        operationStatus: OperationStatus;
        startDate: string;
        endDate: string;
        forcedStartDate: string;
        forcedStartTime: string;
        operationDescription: string;
        operationUnit: UnitOfMeasure;
        stockOperationConversion: string;
        timeUnit: TimeUnitCode;
        routingOperationTimeCode: RunTimeType;
        operationPlanNumber: string;
        technicalSheet: string;
        tool: Product;
        fixture: string;
        program: string;
        numberOfResources: integer;
        preparationTime: string;
        setupTime: string;
        completedSetupTime: string;
        unitTime: string;
        completedUnitaryTime: string;
        runTime: string;
        completedOperationTime: string;
        waitingTime: string;
        postRunTime: string;
        expectedQuantity: string;
        completedQuantity: string;
        rejectQuantity: string;
        subcontract: Subcontracting;
        subcontractWorkCenter: WorkCenter;
        subcontractLeadTimeDays: string;
        groupingCriterion: string;
        distinctionCriteria: string;
        firstAvailability: string;
        workOrderScheduling: ClientCollection<WorkOrderScheduling>;
    }
    export interface WorkOrderOperationLineInput extends ClientNodeInput {
        workOrder?: string;
        operationNumber?: integer | string;
        operationSplit?: integer | string;
        manufacturingSite?: string;
        expectedWorkCenter?: string;
        actualWorkCenter?: string;
        laborWorkCenter?: string;
        actualLaborWorkCenter?: string;
        operationStatus?: OperationStatus;
        startDate?: string;
        endDate?: string;
        forcedStartDate?: string;
        forcedStartTime?: string;
        operationDescription?: string;
        operationUnit?: string;
        stockOperationConversion?: decimal | string;
        timeUnit?: TimeUnitCode;
        routingOperationTimeCode?: RunTimeType;
        operationPlanNumber?: string;
        technicalSheet?: string;
        tool?: string;
        fixture?: string;
        program?: string;
        numberOfResources?: integer | string;
        preparationTime?: decimal | string;
        setupTime?: decimal | string;
        completedSetupTime?: decimal | string;
        unitTime?: decimal | string;
        completedUnitaryTime?: decimal | string;
        runTime?: decimal | string;
        completedOperationTime?: decimal | string;
        waitingTime?: decimal | string;
        postRunTime?: decimal | string;
        expectedQuantity?: decimal | string;
        completedQuantity?: decimal | string;
        rejectQuantity?: decimal | string;
        subcontract?: Subcontracting;
        subcontractWorkCenter?: string;
        subcontractLeadTimeDays?: decimal | string;
        groupingCriterion?: string;
        distinctionCriteria?: string;
        firstAvailability?: string;
        workOrderScheduling?: Partial<WorkOrderSchedulingInput>[];
    }
    export interface WorkOrderOperationLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: WorkOrder;
        operationNumber: integer;
        operationSplit: integer;
        manufacturingSite: Site;
        expectedWorkCenter: WorkCenter;
        actualWorkCenter: WorkCenter;
        laborWorkCenter: WorkCenter;
        actualLaborWorkCenter: WorkCenter;
        operationStatus: OperationStatus;
        startDate: string;
        endDate: string;
        forcedStartDate: string;
        forcedStartTime: string;
        operationDescription: string;
        operationUnit: UnitOfMeasure;
        stockOperationConversion: string;
        timeUnit: TimeUnitCode;
        routingOperationTimeCode: RunTimeType;
        operationPlanNumber: string;
        technicalSheet: string;
        tool: Product;
        fixture: string;
        program: string;
        numberOfResources: integer;
        preparationTime: string;
        setupTime: string;
        completedSetupTime: string;
        unitTime: string;
        completedUnitaryTime: string;
        runTime: string;
        completedOperationTime: string;
        waitingTime: string;
        postRunTime: string;
        expectedQuantity: string;
        completedQuantity: string;
        rejectQuantity: string;
        subcontract: Subcontracting;
        subcontractWorkCenter: WorkCenter;
        subcontractLeadTimeDays: string;
        groupingCriterion: string;
        distinctionCriteria: string;
        firstAvailability: string;
        workOrderScheduling: ClientCollection<WorkOrderScheduling>;
    }
    export interface WorkOrderOperationLine$Lookups {
        workOrder: QueryOperation<WorkOrder>;
        manufacturingSite: QueryOperation<Site>;
        expectedWorkCenter: QueryOperation<WorkCenter>;
        actualWorkCenter: QueryOperation<WorkCenter>;
        laborWorkCenter: QueryOperation<WorkCenter>;
        actualLaborWorkCenter: QueryOperation<WorkCenter>;
        operationUnit: QueryOperation<UnitOfMeasure>;
        tool: QueryOperation<Product>;
        subcontractWorkCenter: QueryOperation<WorkCenter>;
    }
    export interface WorkOrderOperationLine$Operations {
        query: QueryOperation<WorkOrderOperationLine>;
        read: ReadOperation<WorkOrderOperationLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderOperationLine>;
            query: AggregateQueryOperation<WorkOrderOperationLine>;
        };
        lookups(dataOrId: string | { data: WorkOrderOperationLineInput }): WorkOrderOperationLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderOperationLine>;
    }
    export interface WorkOrderOperationScheduling extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        downstreamOperationNumber: integer;
        scheduleCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        lotQuantity: string;
        numberOfLots: string;
        milestone: ScheduleType;
        timeUnit: TimeUnitCode;
    }
    export interface WorkOrderOperationSchedulingInput extends ClientNodeInput {
        workOrder?: string;
        operationNumber?: integer | string;
        operationSplit?: integer | string;
        productionSite?: string;
        downstreamOperationNumber?: integer | string;
        scheduleCode?: SchedulingCode;
        overlappingTime?: decimal | string;
        overlappingQuantity?: decimal | string;
        lotQuantity?: decimal | string;
        numberOfLots?: decimal | string;
        milestone?: ScheduleType;
    }
    export interface WorkOrderOperationSchedulingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        downstreamOperationNumber: integer;
        scheduleCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        lotQuantity: string;
        numberOfLots: string;
        milestone: ScheduleType;
        timeUnit: TimeUnitCode;
    }
    export interface WorkOrderOperationScheduling$Lookups {
        productionSite: QueryOperation<Site>;
    }
    export interface WorkOrderOperationScheduling$Operations {
        query: QueryOperation<WorkOrderOperationScheduling>;
        read: ReadOperation<WorkOrderOperationScheduling>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderOperationScheduling>;
            query: AggregateQueryOperation<WorkOrderOperationScheduling>;
        };
        lookups(dataOrId: string | { data: WorkOrderOperationSchedulingInput }): WorkOrderOperationScheduling$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderOperationScheduling>;
    }
    export interface WorkOrderOperationTrackingLineRejections extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        trackingNumber: string;
        line: integer;
        rejection: integer;
    }
    export interface WorkOrderOperationTrackingLineRejectionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        trackingNumber?: string;
        line?: integer | string;
        rejection?: integer | string;
    }
    export interface WorkOrderOperationTrackingLineRejectionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        trackingNumber: string;
        line: integer;
        rejection: integer;
    }
    export interface WorkOrderOperationTrackingLineRejections$Operations {
        query: QueryOperation<WorkOrderOperationTrackingLineRejections>;
        read: ReadOperation<WorkOrderOperationTrackingLineRejections>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderOperationTrackingLineRejections>;
            query: AggregateQueryOperation<WorkOrderOperationTrackingLineRejections>;
        };
        getDefaults: GetDefaultsOperation<WorkOrderOperationTrackingLineRejections>;
    }
    export interface WorkOrderOperationTrackingLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        line: integer;
        workOrderNumber: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        routing: Product;
        routingCode: RoutingHeader;
        operationUnit: UnitOfMeasure;
        operationConversion: string;
        totalCompletedQuantity: string;
        actualRejectedQuantity: string;
        actualWorkCenter: WorkCenter;
        actualSetupTime: string;
        actualRunTime: string;
        employeeId: integer;
        message: integer;
        timeUnit: TimeUnitCode;
        alternativeIndex: integer;
        standardOperation: StandardOperations;
        project: ProjectLink;
        workOrderOperationTracking: WorkOrderOperationTracking;
        rejections: ClientCollection<WorkOrderOperationTrackingLineRejections>;
    }
    export interface WorkOrderOperationTrackingLineInput extends ClientNodeInput {
        trackingNumber?: string;
        line?: integer | string;
        workOrderNumber?: string;
        operationNumber?: integer | string;
        operationSplit?: integer | string;
        productionSite?: string;
        routing?: string;
        routingCode?: string;
        operationUnit?: string;
        operationConversion?: decimal | string;
        totalCompletedQuantity?: decimal | string;
        actualRejectedQuantity?: decimal | string;
        actualWorkCenter?: string;
        actualSetupTime?: decimal | string;
        actualRunTime?: decimal | string;
        employeeId?: integer | string;
        message?: integer | string;
        timeUnit?: TimeUnitCode;
        alternativeIndex?: integer | string;
        standardOperation?: string;
        project?: string;
        workOrderOperationTracking?: string;
        balance?: decimal | string;
        bom?: string;
        bomCode?: string;
        postingDate?: string;
        transaction?: string;
        rejections?: Partial<WorkOrderOperationTrackingLineRejectionsInput>[];
    }
    export interface WorkOrderOperationTrackingLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        line: integer;
        workOrderNumber: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        routing: Product;
        routingCode: RoutingHeader;
        operationUnit: UnitOfMeasure;
        operationConversion: string;
        totalCompletedQuantity: string;
        actualRejectedQuantity: string;
        actualWorkCenter: WorkCenter;
        actualSetupTime: string;
        actualRunTime: string;
        employeeId: integer;
        message: integer;
        timeUnit: TimeUnitCode;
        alternativeIndex: integer;
        standardOperation: StandardOperations;
        project: ProjectLink;
        workOrderOperationTracking: WorkOrderOperationTracking;
        balance: string;
        bom: string;
        bomCode: string;
        postingDate: string;
        transaction: string;
        rejections: ClientCollection<WorkOrderOperationTrackingLineRejectionsBinding>;
    }
    export interface WorkOrderOperationTrackingLine$Lookups {
        productionSite: QueryOperation<Site>;
        routing: QueryOperation<Product>;
        routingCode: QueryOperation<RoutingHeader>;
        operationUnit: QueryOperation<UnitOfMeasure>;
        actualWorkCenter: QueryOperation<WorkCenter>;
        standardOperation: QueryOperation<StandardOperations>;
        project: QueryOperation<ProjectLink>;
        workOrderOperationTracking: QueryOperation<WorkOrderOperationTracking>;
    }
    export interface WorkOrderOperationTrackingLine$Operations {
        query: QueryOperation<WorkOrderOperationTrackingLine>;
        read: ReadOperation<WorkOrderOperationTrackingLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderOperationTrackingLine>;
            query: AggregateQueryOperation<WorkOrderOperationTrackingLine>;
        };
        lookups(
            dataOrId: string | { data: WorkOrderOperationTrackingLineInput },
        ): WorkOrderOperationTrackingLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderOperationTrackingLine>;
    }
    export interface WorkOrderOperationTracking extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderOperationTrackingLines: ClientCollection<WorkOrderOperationTrackingLine>;
    }
    export interface WorkOrderOperationTrackingInput extends ClientNodeInput {
        trackingNumber?: string;
        productionSite?: string;
        workOrderOperationTrackingLines?: Partial<WorkOrderOperationTrackingLineInput>[];
    }
    export interface WorkOrderOperationTrackingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderOperationTrackingLines: ClientCollection<WorkOrderOperationTrackingLine>;
    }
    export interface WorkOrderOperationTracking$Lookups {
        productionSite: QueryOperation<Site>;
    }
    export interface WorkOrderOperationTracking$Operations {
        query: QueryOperation<WorkOrderOperationTracking>;
        read: ReadOperation<WorkOrderOperationTracking>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderOperationTracking>;
            query: AggregateQueryOperation<WorkOrderOperationTracking>;
        };
        create: CreateOperation<WorkOrderOperationTrackingInput, WorkOrderOperationTracking>;
        getDuplicate: GetDuplicateOperation<WorkOrderOperationTracking>;
        lookups(dataOrId: string | { data: WorkOrderOperationTrackingInput }): WorkOrderOperationTracking$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderOperationTracking>;
    }
    export interface WorkOrderProductLineProductAnalysis extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workOrder: string;
        lineNumber: integer;
        analysis: MiscellaneousTable;
    }
    export interface WorkOrderProductLineProductAnalysisInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        workOrder?: string;
        lineNumber?: integer | string;
        analysis?: string;
    }
    export interface WorkOrderProductLineProductAnalysisBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        workOrder: string;
        lineNumber: integer;
        analysis: MiscellaneousTable;
    }
    export interface WorkOrderProductLineProductAnalysis$Lookups {
        analysis: QueryOperation<MiscellaneousTable>;
    }
    export interface WorkOrderProductLineProductAnalysis$Operations {
        query: QueryOperation<WorkOrderProductLineProductAnalysis>;
        read: ReadOperation<WorkOrderProductLineProductAnalysis>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderProductLineProductAnalysis>;
            query: AggregateQueryOperation<WorkOrderProductLineProductAnalysis>;
        };
        lookups(
            dataOrId: string | { data: WorkOrderProductLineProductAnalysisInput },
        ): WorkOrderProductLineProductAnalysis$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderProductLineProductAnalysis>;
    }
    export interface WorkOrderProductLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: WorkOrder;
        lineNumber: integer;
        product: Product;
        productType: ManufacturingProductType;
        productionSite: Site;
        productCategory: ProductCategory;
        projectTaskNumber: ProjectLink;
        customer: BusinessPartner;
        releaseUnit: UnitOfMeasure;
        releaseQuantity: string;
        releaseStkConversion: string;
        stockUnit: UnitOfMeasure;
        expectedQuantity: string;
        remainingQuantity: string;
        lot: string;
        bomCode: BomCodes;
        originalDocumentType: EntryTypeEnum;
        salesOrder: string;
        lineStatus: ProductionStatus;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productSiteAttribute: ClientCollection<ProductSiteAttribute>;
        productAnalysis: ClientCollection<WorkOrderProductLineProductAnalysis>;
    }
    export interface WorkOrderProductLineInput extends ClientNodeInput {
        workOrder?: string;
        lineNumber?: integer | string;
        product?: string;
        productType?: ManufacturingProductType;
        productionSite?: string;
        productCategory?: string;
        projectTaskNumber?: string;
        customer?: string;
        releaseUnit?: string;
        releaseQuantity?: decimal | string;
        releaseStkConversion?: decimal | string;
        stockUnit?: string;
        expectedQuantity?: decimal | string;
        remainingQuantity?: decimal | string;
        lot?: string;
        bomCode?: integer | string;
        originalDocumentType?: EntryTypeEnum;
        salesOrder?: string;
        lineStatus?: ProductionStatus;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productAnalysis?: Partial<WorkOrderProductLineProductAnalysisInput>[];
    }
    export interface WorkOrderProductLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: WorkOrder;
        lineNumber: integer;
        product: Product;
        productType: ManufacturingProductType;
        productionSite: Site;
        productCategory: ProductCategory;
        projectTaskNumber: ProjectLink;
        customer: BusinessPartner;
        releaseUnit: UnitOfMeasure;
        releaseQuantity: string;
        releaseStkConversion: string;
        stockUnit: UnitOfMeasure;
        expectedQuantity: string;
        remainingQuantity: string;
        lot: string;
        bomCode: BomCodes;
        originalDocumentType: EntryTypeEnum;
        salesOrder: string;
        lineStatus: ProductionStatus;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productSiteAttribute: ClientCollection<ProductSiteAttribute>;
        productAnalysis: ClientCollection<WorkOrderProductLineProductAnalysisBinding>;
    }
    export interface WorkOrderProductLine$Lookups {
        workOrder: QueryOperation<WorkOrder>;
        product: QueryOperation<Product>;
        productionSite: QueryOperation<Site>;
        productCategory: QueryOperation<ProductCategory>;
        projectTaskNumber: QueryOperation<ProjectLink>;
        customer: QueryOperation<BusinessPartner>;
        releaseUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        bomCode: QueryOperation<BomCodes>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
    }
    export interface WorkOrderProductLine$Operations {
        query: QueryOperation<WorkOrderProductLine>;
        read: ReadOperation<WorkOrderProductLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderProductLine>;
            query: AggregateQueryOperation<WorkOrderProductLine>;
        };
        lookups(dataOrId: string | { data: WorkOrderProductLineInput }): WorkOrderProductLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderProductLine>;
    }
    export interface WorkOrderProductionReportingLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        line: integer;
        orderNo: string;
        orderLineNumber: integer;
        product: Product;
        bomAlternative: BomCodes;
        lot: string;
        productionSite: Site;
        stockUnit: UnitOfMeasure;
        actualAcceptedQuantity: string;
        stkConversion: string;
        actualQuantity: string;
        releaseUnit: UnitOfMeasure;
        project: ProjectLink;
        warehouse: Warehouse;
        licensePlateNumber: LicensePlateNumber;
        serialNumber: string;
        stockJournal: ClientCollection<StockJournal>;
        workOrderProductionReporting: WorkOrderProductionReporting;
    }
    export interface WorkOrderProductionReportingLineInput extends ClientNodeInput {
        trackingNumber?: string;
        line?: integer | string;
        orderNo?: string;
        orderLineNumber?: integer | string;
        product?: string;
        bomAlternative?: integer | string;
        lot?: string;
        productionSite?: string;
        stockUnit?: string;
        actualAcceptedQuantity?: decimal | string;
        stkConversion?: decimal | string;
        actualQuantity?: decimal | string;
        releaseUnit?: string;
        project?: string;
        warehouse?: string;
        licensePlateNumber?: string;
        serialNumber?: string;
        stockJournal?: Partial<StockJournalInput>[];
        workOrderProductionReporting?: string;
        balance?: decimal | string;
        destinationCode?: string;
        labelDestination?: string;
        postingDate?: string;
        rejectedQty?: decimal | string;
        transactionCode?: string;
    }
    export interface WorkOrderProductionReportingLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        line: integer;
        orderNo: string;
        orderLineNumber: integer;
        product: Product;
        bomAlternative: BomCodes;
        lot: string;
        productionSite: Site;
        stockUnit: UnitOfMeasure;
        actualAcceptedQuantity: string;
        stkConversion: string;
        actualQuantity: string;
        releaseUnit: UnitOfMeasure;
        project: ProjectLink;
        warehouse: Warehouse;
        licensePlateNumber: LicensePlateNumber;
        serialNumber: string;
        stockJournal: ClientCollection<StockJournal>;
        workOrderProductionReporting: WorkOrderProductionReporting;
        balance: string;
        destinationCode: string;
        labelDestination: string;
        postingDate: string;
        rejectedQty: string;
        transactionCode: string;
    }
    export interface WorkOrderProductionReportingLine$Lookups {
        product: QueryOperation<Product>;
        bomAlternative: QueryOperation<BomCodes>;
        productionSite: QueryOperation<Site>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        releaseUnit: QueryOperation<UnitOfMeasure>;
        project: QueryOperation<ProjectLink>;
        warehouse: QueryOperation<Warehouse>;
        licensePlateNumber: QueryOperation<LicensePlateNumber>;
        workOrderProductionReporting: QueryOperation<WorkOrderProductionReporting>;
    }
    export interface WorkOrderProductionReportingLine$Operations {
        query: QueryOperation<WorkOrderProductionReportingLine>;
        read: ReadOperation<WorkOrderProductionReportingLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderProductionReportingLine>;
            query: AggregateQueryOperation<WorkOrderProductionReportingLine>;
        };
        lookups(
            dataOrId: string | { data: WorkOrderProductionReportingLineInput },
        ): WorkOrderProductionReportingLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderProductionReportingLine>;
    }
    export interface WorkOrderProductionReporting extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderProductionReportingLines: ClientCollection<WorkOrderProductionReportingLine>;
    }
    export interface WorkOrderProductionReportingInput extends ClientNodeInput {
        trackingNumber?: string;
        productionSite?: string;
        workOrderProductionReportingLines?: Partial<WorkOrderProductionReportingLineInput>[];
    }
    export interface WorkOrderProductionReportingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        trackingNumber: string;
        productionSite: Site;
        workOrderProductionReportingLines: ClientCollection<WorkOrderProductionReportingLine>;
    }
    export interface WorkOrderProductionReporting$Lookups {
        productionSite: QueryOperation<Site>;
    }
    export interface WorkOrderProductionReporting$Operations {
        query: QueryOperation<WorkOrderProductionReporting>;
        read: ReadOperation<WorkOrderProductionReporting>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderProductionReporting>;
            query: AggregateQueryOperation<WorkOrderProductionReporting>;
        };
        create: CreateOperation<WorkOrderProductionReportingInput, WorkOrderProductionReporting>;
        getDuplicate: GetDuplicateOperation<WorkOrderProductionReporting>;
        lookups(dataOrId: string | { data: WorkOrderProductionReportingInput }): WorkOrderProductionReporting$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderProductionReporting>;
    }
    export interface WorkOrderScheduling extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        downstreamOperationNumber: integer;
        scheduleCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        lotQuantity: string;
        numberOfLots: string;
        milestone: ScheduleType;
    }
    export interface WorkOrderSchedulingInput extends ClientNodeInput {
        workOrder?: string;
        operationNumber?: integer | string;
        operationSplit?: integer | string;
        productionSite?: string;
        downstreamOperationNumber?: integer | string;
        scheduleCode?: SchedulingCode;
        overlappingTime?: decimal | string;
        overlappingQuantity?: decimal | string;
        lotQuantity?: decimal | string;
        numberOfLots?: decimal | string;
        milestone?: ScheduleType;
    }
    export interface WorkOrderSchedulingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        workOrder: string;
        operationNumber: integer;
        operationSplit: integer;
        productionSite: Site;
        downstreamOperationNumber: integer;
        scheduleCode: SchedulingCode;
        overlappingTime: string;
        overlappingQuantity: string;
        lotQuantity: string;
        numberOfLots: string;
        milestone: ScheduleType;
    }
    export interface WorkOrderScheduling$Lookups {
        productionSite: QueryOperation<Site>;
    }
    export interface WorkOrderScheduling$Operations {
        query: QueryOperation<WorkOrderScheduling>;
        read: ReadOperation<WorkOrderScheduling>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderScheduling>;
            query: AggregateQueryOperation<WorkOrderScheduling>;
        };
        lookups(dataOrId: string | { data: WorkOrderSchedulingInput }): WorkOrderScheduling$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderScheduling>;
    }
    export interface WorkOrderSuggestionLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        operationNumber: integer;
        operationSplit: integer;
        operationKey: string;
        manufacturingSite: Site;
        startDate: string;
        endDate: string;
        operationStatus: OperationStatus;
        expectedWorkCenter: WorkCenter;
        actualWorkCenter: WorkCenter;
        operationUnit: UnitOfMeasure;
        stockOperationConversion: string;
        expectedQuantity: string;
        completedQuantity: string;
        rejectQuantity: string;
        routingOperationTimeCode: RunTimeType;
        timeUnit: TimeUnitCode;
        preparationTime: string;
        setupTime: string;
        completedSetupTime: string;
        runTime: string;
        completedOperationTime: string;
        waitingTime: string;
        postRunTime: string;
        laborWorkCenter: WorkCenter;
        actualLaborWorkCenter: WorkCenter;
        numberOfResources: integer;
    }
    export interface WorkOrderSuggestionLineInput extends ClientNodeInput {
        code?: string;
        operationNumber?: integer | string;
        operationSplit?: integer | string;
        operationKey?: string;
        manufacturingSite?: string;
        startDate?: string;
        endDate?: string;
        operationStatus?: OperationStatus;
        expectedWorkCenter?: string;
        actualWorkCenter?: string;
        operationUnit?: string;
        stockOperationConversion?: decimal | string;
        expectedQuantity?: decimal | string;
        completedQuantity?: decimal | string;
        rejectQuantity?: decimal | string;
        routingOperationTimeCode?: RunTimeType;
        timeUnit?: TimeUnitCode;
        preparationTime?: decimal | string;
        setupTime?: decimal | string;
        completedSetupTime?: decimal | string;
        runTime?: decimal | string;
        completedOperationTime?: decimal | string;
        waitingTime?: decimal | string;
        postRunTime?: decimal | string;
        laborWorkCenter?: string;
        actualLaborWorkCenter?: string;
        numberOfResources?: integer | string;
    }
    export interface WorkOrderSuggestionLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        operationNumber: integer;
        operationSplit: integer;
        operationKey: string;
        manufacturingSite: Site;
        startDate: string;
        endDate: string;
        operationStatus: OperationStatus;
        expectedWorkCenter: WorkCenter;
        actualWorkCenter: WorkCenter;
        operationUnit: UnitOfMeasure;
        stockOperationConversion: string;
        expectedQuantity: string;
        completedQuantity: string;
        rejectQuantity: string;
        routingOperationTimeCode: RunTimeType;
        timeUnit: TimeUnitCode;
        preparationTime: string;
        setupTime: string;
        completedSetupTime: string;
        runTime: string;
        completedOperationTime: string;
        waitingTime: string;
        postRunTime: string;
        laborWorkCenter: WorkCenter;
        actualLaborWorkCenter: WorkCenter;
        numberOfResources: integer;
    }
    export interface WorkOrderSuggestionLine$Lookups {
        manufacturingSite: QueryOperation<Site>;
        expectedWorkCenter: QueryOperation<WorkCenter>;
        actualWorkCenter: QueryOperation<WorkCenter>;
        operationUnit: QueryOperation<UnitOfMeasure>;
        laborWorkCenter: QueryOperation<WorkCenter>;
        actualLaborWorkCenter: QueryOperation<WorkCenter>;
    }
    export interface WorkOrderSuggestionLine$Operations {
        query: QueryOperation<WorkOrderSuggestionLine>;
        read: ReadOperation<WorkOrderSuggestionLine>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderSuggestionLine>;
            query: AggregateQueryOperation<WorkOrderSuggestionLine>;
        };
        lookups(dataOrId: string | { data: WorkOrderSuggestionLineInput }): WorkOrderSuggestionLine$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderSuggestionLine>;
    }
    export interface WorkOrderSuggestion extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        orderType: WorkOrderType;
        code: string;
        productCode: Product;
        orderStatus: StatusInProgress;
        originalSite: Site;
        customer: BusinessPartner;
        startDate: string;
        remainingQuantity: string;
        optimized: boolean;
        workOrderSuggestionLines: ClientCollection<WorkOrderSuggestionLine>;
        workOrderOperationSchedulingLines: ClientCollection<WorkOrderOperationScheduling>;
    }
    export interface WorkOrderSuggestionInput extends ClientNodeInput {
        orderType?: WorkOrderType;
        code?: string;
        productCode?: string;
        orderStatus?: StatusInProgress;
        originalSite?: string;
        customer?: string;
        startDate?: string;
        remainingQuantity?: decimal | string;
        optimized?: boolean | string;
        workOrderSuggestionLines?: Partial<WorkOrderSuggestionLineInput>[];
        workOrderOperationSchedulingLines?: Partial<WorkOrderOperationSchedulingInput>[];
    }
    export interface WorkOrderSuggestionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        orderType: WorkOrderType;
        code: string;
        productCode: Product;
        orderStatus: StatusInProgress;
        originalSite: Site;
        customer: BusinessPartner;
        startDate: string;
        remainingQuantity: string;
        optimized: boolean;
        workOrderSuggestionLines: ClientCollection<WorkOrderSuggestionLine>;
        workOrderOperationSchedulingLines: ClientCollection<WorkOrderOperationScheduling>;
    }
    export interface WorkOrderSuggestion$Lookups {
        productCode: QueryOperation<Product>;
        originalSite: QueryOperation<Site>;
        customer: QueryOperation<BusinessPartner>;
    }
    export interface WorkOrderSuggestion$Operations {
        query: QueryOperation<WorkOrderSuggestion>;
        read: ReadOperation<WorkOrderSuggestion>;
        aggregate: {
            read: AggregateReadOperation<WorkOrderSuggestion>;
            query: AggregateQueryOperation<WorkOrderSuggestion>;
        };
        lookups(dataOrId: string | { data: WorkOrderSuggestionInput }): WorkOrderSuggestion$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrderSuggestion>;
    }
    export interface WorkOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        number: string;
        orderStatus: StatusInProgress;
        planningSite: Site;
        productionSite: Site;
        releaseMode: ReleaseMode;
        modeType: ModeType;
        startDate: string;
        endDate: string;
        scheduleMode: SchedulingMode;
        percLTReduction: string;
        plannedQuantity: string;
        initialObjective: string;
        releasedRouting: RoutingHeader;
        routingCode: BomRouting;
        priority: Priority;
        schedulingStatus: SchedulingStatus;
        numberOfMaterials: integer;
        allocationStatus: WorkOrderAllocationStatus;
        trackingFlag: WorkOrderSituation;
        workOrderOptimized: boolean;
        workOrderSuspendedFlag: boolean;
        workOrderProductLines: ClientCollection<WorkOrderProductLine>;
        workOrderOperationLines: ClientCollection<WorkOrderOperationLine>;
        workOrderOperationSchedulingLines: ClientCollection<WorkOrderOperationScheduling>;
        workOrderMaterialLines: ClientCollection<WorkOrderMaterialLine>;
    }
    export interface WorkOrderInput extends ClientNodeInput {
        number?: string;
        orderStatus?: StatusInProgress;
        planningSite?: string;
        productionSite?: string;
        releaseMode?: ReleaseMode;
        modeType?: ModeType;
        startDate?: string;
        endDate?: string;
        scheduleMode?: SchedulingMode;
        percLTReduction?: decimal | string;
        plannedQuantity?: decimal | string;
        initialObjective?: string;
        releasedRouting?: string;
        routingCode?: integer | string;
        priority?: Priority;
        schedulingStatus?: SchedulingStatus;
        numberOfMaterials?: integer | string;
        allocationStatus?: WorkOrderAllocationStatus;
        trackingFlag?: WorkOrderSituation;
        workOrderOptimized?: boolean | string;
        workOrderSuspendedFlag?: boolean | string;
        workOrderProductLines?: Partial<WorkOrderProductLineInput>[];
        workOrderOperationLines?: Partial<WorkOrderOperationLineInput>[];
        workOrderOperationSchedulingLines?: Partial<WorkOrderOperationSchedulingInput>[];
        workOrderMaterialLines?: Partial<WorkOrderMaterialLineInput>[];
    }
    export interface WorkOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        number: string;
        orderStatus: StatusInProgress;
        planningSite: Site;
        productionSite: Site;
        releaseMode: ReleaseMode;
        modeType: ModeType;
        startDate: string;
        endDate: string;
        scheduleMode: SchedulingMode;
        percLTReduction: string;
        plannedQuantity: string;
        initialObjective: string;
        releasedRouting: RoutingHeader;
        routingCode: BomRouting;
        priority: Priority;
        schedulingStatus: SchedulingStatus;
        numberOfMaterials: integer;
        allocationStatus: WorkOrderAllocationStatus;
        trackingFlag: WorkOrderSituation;
        workOrderOptimized: boolean;
        workOrderSuspendedFlag: boolean;
        workOrderProductLines: ClientCollection<WorkOrderProductLine>;
        workOrderOperationLines: ClientCollection<WorkOrderOperationLine>;
        workOrderOperationSchedulingLines: ClientCollection<WorkOrderOperationScheduling>;
        workOrderMaterialLines: ClientCollection<WorkOrderMaterialLine>;
    }
    export interface WorkOrder$Mutations {
        workOrderOptimization: Node$Operation<
            {
                parameters?: {
                    productionSite: string;
                    number: string;
                    product: string;
                    operationNumber: (integer | string)[];
                    operationSplit: (integer | string)[];
                    operationStartDateTime: string[];
                    operationEndDateTime: string[];
                    operationRunStartDateTime: string[];
                    operationRunEndDateTime: string[];
                    forcedStartDateTime: string[];
                    expectedWorkCenter: string[];
                    setupTimeSeconds: (integer | string)[];
                    sequenceOrder: (integer | string)[];
                    forcedPlacement: (integer | string)[];
                    status: integer | string;
                    message: string;
                };
            },
            {
                status: integer;
                message: string;
            }
        >;
    }
    export interface WorkOrder$Lookups {
        planningSite: QueryOperation<Site>;
        productionSite: QueryOperation<Site>;
        releasedRouting: QueryOperation<RoutingHeader>;
        routingCode: QueryOperation<BomRouting>;
    }
    export interface WorkOrder$Operations {
        query: QueryOperation<WorkOrder>;
        read: ReadOperation<WorkOrder>;
        aggregate: {
            read: AggregateReadOperation<WorkOrder>;
            query: AggregateQueryOperation<WorkOrder>;
        };
        mutations: WorkOrder$Mutations;
        lookups(dataOrId: string | { data: WorkOrderInput }): WorkOrder$Lookups;
        getDefaults: GetDefaultsOperation<WorkOrder>;
    }
    export interface AssignmentExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        _x3Auuid: string;
        storageSite: Site;
        product: ProductSite;
        requestType: EntryTypeEnum;
        demandNumber: string;
        demandLineNumber: integer;
        demandSequence: integer;
        demandOrderType: WorkOrderType;
        demandOrderStatus: StatusInProgress;
        resourceType: EntryTypeEnum;
        resourceNumber: string;
        resourceLineNumber: integer;
        resourceSequence: integer;
        resourceOrderType: WorkOrderType;
        resourceOrderStatus: StatusInProgress;
        quantityAssigned: string;
        parentWorkOrder: WorkOrder;
        childWorkOrder: WorkOrder;
    }
    export interface AssignmentInputExtension {
        _x3Auuid?: string;
        storageSite?: string;
        product?: string;
        requestType?: EntryTypeEnum;
        demandNumber?: string;
        demandLineNumber?: integer | string;
        demandSequence?: integer | string;
        demandOrderType?: WorkOrderType;
        demandOrderStatus?: StatusInProgress;
        resourceType?: EntryTypeEnum;
        resourceNumber?: string;
        resourceLineNumber?: integer | string;
        resourceSequence?: integer | string;
        resourceOrderType?: WorkOrderType;
        resourceOrderStatus?: StatusInProgress;
        quantityAssigned?: decimal | string;
        parentWorkOrder?: string;
        childWorkOrder?: string;
    }
    export interface AssignmentBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        _x3Auuid: string;
        storageSite: Site;
        product: ProductSite;
        requestType: EntryTypeEnum;
        demandNumber: string;
        demandLineNumber: integer;
        demandSequence: integer;
        demandOrderType: WorkOrderType;
        demandOrderStatus: StatusInProgress;
        resourceType: EntryTypeEnum;
        resourceNumber: string;
        resourceLineNumber: integer;
        resourceSequence: integer;
        resourceOrderType: WorkOrderType;
        resourceOrderStatus: StatusInProgress;
        quantityAssigned: string;
        parentWorkOrder: WorkOrder;
        childWorkOrder: WorkOrder;
    }
    export interface AssignmentExtension$Lookups {
        parentWorkOrder: QueryOperation<WorkOrder>;
        childWorkOrder: QueryOperation<WorkOrder>;
    }
    export interface AssignmentExtension$Operations {
        lookups(dataOrId: string | { data: AssignmentInput }): AssignmentExtension$Lookups;
    }
    export interface ProductSiteExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
        reorderingManagementMode: ReorderingManagementMode;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        defaultInternalContainer: Container;
        defaultLocations: ClientCollection<ProductSiteDefaultLocations>;
        internalContainers: ClientCollection<ProductSiteInternalContainers>;
        packaging: Packaging;
        stock: ClientCollection<Stock>;
        countOfStockRecords: integer;
        distinctCountOfLocations: integer;
        distinctCountOfLots: integer;
        distinctCountOfStockQuantity: string;
        distinctCountOfSublots: integer;
        stockUnitCode: string;
        methodOfCorrection: MethodOfCorrection;
        productSiteAttribute: ClientCollection<ProductSiteAttribute>;
    }
    export interface ProductSiteInputExtension {
        product?: string;
        stockSite?: string;
        isBeingCounted?: boolean | string;
        countWorksheet?: string;
        abcClass?: ProductAbcClass;
        isLocationManaged?: boolean | string;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        numberOfStockCoverageWeeks?: integer | string;
        multilevelLeadTime?: decimal | string;
        qualityControlLeadTime?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningDemandHorizon?: integer | string;
        planningDemandHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        productionLeadTime?: decimal | string;
        pickingLeadTime?: decimal | string;
        reductionFactor?: integer | string;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        safetyStock?: decimal | string;
        calculatedSafetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        calculatedReorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        calculatedReorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        calculatedEconomicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        shrinkagePercentage?: decimal | string;
        planner?: string;
        buyer?: string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        productionRouting?: string;
        costRouting?: string;
        roughCut?: string;
        productionRoutingCode?: integer | string;
        costRoutingCode?: integer | string;
        roughCutCapacityPlanningRoutingCode?: integer | string;
        isReleasedIfShortage?: boolean | string;
        isShrinkedWithRelease?: boolean | string;
        yearOfLastMonthlyUpdate?: integer | string;
        monthOfLastMonthlyUpdate?: integer | string;
        lastAnnualUpdate?: integer | string;
        automaticClosingPercentage?: decimal | string;
        configurationCode?: string;
        storageHandling?: string;
        weighingAccessCode?: string;
        weighingTolerance?: decimal | string;
        productTolerance?: decimal | string;
        valuationMethod?: string;
        prorataQuantityAdjustment?: decimal | string;
        protectionWip?: boolean | string;
        packagingCapacity?: decimal | string;
        stockManagementMode?: StockManagement;
        assignmentRule?: string;
        isStockDetailedInPacking?: boolean | string;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        qualityControlFrequency?: integer | string;
        numberOfEntriesSinceLastQualityControl?: integer | string;
        sampling?: SamplingType;
        samplingMode?: SamplingMode;
        samplingGeneralCheckLevel?: GeneralControlLevel;
        samplingAcceptableQualityLevel?: AcceptableQualityLevel;
        qualityControlFrequencyToReview?: integer | string;
        qualityEntriesProcess?: integer | string;
        recontrolLeadTime?: integer | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionsWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        isPackingManaged?: boolean | string;
        freightClass?: string;
        freightCommodityCode?: string;
        isLicensePlateNumberManaged?: boolean | string;
        reorderingManagementMode?: ReorderingManagementMode;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        defaultInternalContainer?: string;
        defaultLocations?: Partial<ProductSiteDefaultLocationsInput>[];
        internalContainers?: Partial<ProductSiteInternalContainersInput>[];
        packaging?: string;
        methodOfCorrection?: MethodOfCorrection;
        productSiteAttribute?: Partial<ProductSiteAttributeInput>[];
    }
    export interface ProductSiteBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
        reorderingManagementMode: ReorderingManagementMode;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        defaultInternalContainer: Container;
        defaultLocations: ClientCollection<ProductSiteDefaultLocationsBinding>;
        internalContainers: ClientCollection<ProductSiteInternalContainersBinding>;
        packaging: Packaging;
        stock: ClientCollection<Stock>;
        countOfStockRecords: integer;
        distinctCountOfLocations: integer;
        distinctCountOfLots: integer;
        distinctCountOfStockQuantity: string;
        distinctCountOfSublots: integer;
        stockUnitCode: string;
        methodOfCorrection: MethodOfCorrection;
        productSiteAttribute: ClientCollection<ProductSiteAttribute>;
    }
    export interface WorkCenterExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
        type: WorkCenterType;
        optimizationCode: Optimization;
        workOrderOperationLines: ClientCollection<WorkOrderOperationLine>;
    }
    export interface WorkCenterInputExtension {
        code?: string;
        manufacturingSite?: string;
        workCenterGroup?: string;
        costingDimension?: string;
        weeklyStructure?: string;
        efficiencyInPercentage?: decimal | string;
        shrinkageInPercentage?: decimal | string;
        numberOfResources?: integer | string;
        automaticClosingPercentage?: decimal | string;
        qualificationLevel?: string;
        totalExpectedTimeInHours?: decimal | string;
        totalTimeCompleteInHours?: decimal | string;
        isConstraint?: boolean | string;
        isRccp?: boolean | string;
        isRunDuringEmployeeBreak?: boolean | string;
        description?: string;
        type?: WorkCenterType;
        optimizationCode?: string;
    }
    export interface WorkCenterBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        manufacturingSite: Site;
        workCenterGroup: WorkCenterGroup;
        costingDimension: string;
        weeklyStructure: WeeklyStructure;
        efficiencyInPercentage: string;
        shrinkageInPercentage: string;
        numberOfResources: integer;
        automaticClosingPercentage: string;
        qualificationLevel: string;
        totalExpectedTimeInHours: string;
        totalTimeCompleteInHours: string;
        isConstraint: boolean;
        isRccp: boolean;
        isRunDuringEmployeeBreak: boolean;
        description: string;
        type: WorkCenterType;
        optimizationCode: Optimization;
        workOrderOperationLines: ClientCollection<WorkOrderOperationLine>;
    }
    export interface WorkCenterExtension$Lookups {
        optimizationCode: QueryOperation<Optimization>;
    }
    export interface WorkCenterExtension$Operations {
        lookups(dataOrId: string | { data: WorkCenterInput }): WorkCenterExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-manufacturing/AttributeLine': AttributeLine$Operations;
        '@sage/x3-manufacturing/Attribute': Attribute$Operations;
        '@sage/x3-manufacturing/CapacityVariationCapacityVariationGroups': CapacityVariationCapacityVariationGroups$Operations;
        '@sage/x3-manufacturing/CapacityVariation': CapacityVariation$Operations;
        '@sage/x3-manufacturing/FiniteSchedulerCustomValueLines': FiniteSchedulerCustomValueLines$Operations;
        '@sage/x3-manufacturing/FiniteSchedulerCustomValue': FiniteSchedulerCustomValue$Operations;
        '@sage/x3-manufacturing/FiniteSchedulerObject': FiniteSchedulerObject$Operations;
        '@sage/x3-manufacturing/OptimizationLine': OptimizationLine$Operations;
        '@sage/x3-manufacturing/Optimization': Optimization$Operations;
        '@sage/x3-manufacturing/ProductSiteAttribute': ProductSiteAttribute$Operations;
        '@sage/x3-manufacturing/RoutingHeader': RoutingHeader$Operations;
        '@sage/x3-manufacturing/RoutingOperation': RoutingOperation$Operations;
        '@sage/x3-manufacturing/RoutingScheduling': RoutingScheduling$Operations;
        '@sage/x3-manufacturing/RoutingVersion': RoutingVersion$Operations;
        '@sage/x3-manufacturing/SetupTimeException': SetupTimeException$Operations;
        '@sage/x3-manufacturing/SetupTime': SetupTime$Operations;
        '@sage/x3-manufacturing/StandardOperations': StandardOperations$Operations;
        '@sage/x3-manufacturing/TransactionProductionReporting': TransactionProductionReporting$Operations;
        '@sage/x3-manufacturing/WorkCenterReplacementWorkCenterReplacementLines': WorkCenterReplacementWorkCenterReplacementLines$Operations;
        '@sage/x3-manufacturing/WorkCenterReplacement': WorkCenterReplacement$Operations;
        '@sage/x3-manufacturing/WorkOrderMaterialLine': WorkOrderMaterialLine$Operations;
        '@sage/x3-manufacturing/WorkOrderMaterialTrackingLine': WorkOrderMaterialTrackingLine$Operations;
        '@sage/x3-manufacturing/WorkOrderMaterialTracking': WorkOrderMaterialTracking$Operations;
        '@sage/x3-manufacturing/WorkOrderOperationLine': WorkOrderOperationLine$Operations;
        '@sage/x3-manufacturing/WorkOrderOperationScheduling': WorkOrderOperationScheduling$Operations;
        '@sage/x3-manufacturing/WorkOrderOperationTrackingLineRejections': WorkOrderOperationTrackingLineRejections$Operations;
        '@sage/x3-manufacturing/WorkOrderOperationTrackingLine': WorkOrderOperationTrackingLine$Operations;
        '@sage/x3-manufacturing/WorkOrderOperationTracking': WorkOrderOperationTracking$Operations;
        '@sage/x3-manufacturing/WorkOrderProductLineProductAnalysis': WorkOrderProductLineProductAnalysis$Operations;
        '@sage/x3-manufacturing/WorkOrderProductLine': WorkOrderProductLine$Operations;
        '@sage/x3-manufacturing/WorkOrderProductionReportingLine': WorkOrderProductionReportingLine$Operations;
        '@sage/x3-manufacturing/WorkOrderProductionReporting': WorkOrderProductionReporting$Operations;
        '@sage/x3-manufacturing/WorkOrderScheduling': WorkOrderScheduling$Operations;
        '@sage/x3-manufacturing/WorkOrderSuggestionLine': WorkOrderSuggestionLine$Operations;
        '@sage/x3-manufacturing/WorkOrderSuggestion': WorkOrderSuggestion$Operations;
        '@sage/x3-manufacturing/WorkOrder': WorkOrder$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3SalesData$Package,
            SageX3Stock$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-manufacturing-api' {
    export type * from '@sage/x3-manufacturing-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-manufacturing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type {
        AssignmentBindingExtension,
        AssignmentExtension,
        AssignmentExtension$Lookups,
        AssignmentExtension$Operations,
        AssignmentInputExtension,
        WorkCenterBindingExtension,
        WorkCenterExtension,
        WorkCenterExtension$Lookups,
        WorkCenterExtension$Operations,
        WorkCenterInputExtension,
    } from '@sage/x3-manufacturing-api';
    export interface Assignment extends AssignmentExtension {}
    export interface AssignmentBinding extends AssignmentBindingExtension {}
    export interface AssignmentInput extends AssignmentInputExtension {}
    export interface Assignment$Lookups extends AssignmentExtension$Lookups {}
    export interface Assignment$Operations extends AssignmentExtension$Operations {}
    export interface WorkCenter extends WorkCenterExtension {}
    export interface WorkCenterBinding extends WorkCenterBindingExtension {}
    export interface WorkCenterInput extends WorkCenterInputExtension {}
    export interface WorkCenter$Lookups extends WorkCenterExtension$Lookups {}
    export interface WorkCenter$Operations extends WorkCenterExtension$Operations {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        ProductSiteBindingExtension,
        ProductSiteExtension,
        ProductSiteInputExtension,
    } from '@sage/x3-manufacturing-api';
    export interface ProductSite extends ProductSiteExtension {}
    export interface ProductSiteBinding extends ProductSiteBindingExtension {}
    export interface ProductSiteInput extends ProductSiteInputExtension {}
}
