// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/index.d.ts
declare module '@sage/x3-invoicing-data/index' {
	export * from '@sage/x3-invoicing-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/index.d.ts
declare module '@sage/x3-invoicing-data/lib/index' {
	export * as enums from '@sage/x3-invoicing-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-invoicing-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-invoicing-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-invoicing-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-invoicing-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/tax.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/tax' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Tax extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=tax.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/tax-rule.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/tax-rule' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TaxRule extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=tax-rule.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/tax-level.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/tax-level' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class TaxLevel extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=tax-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeader extends Node {
	    readonly id: Promise<string>;
	    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
	    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly control: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly accountingDate: Promise<date | null>;
	    readonly internalNumber: Promise<integer | null>;
	    readonly internalReference: Promise<string>;
	    readonly sourceDocumentDate: Promise<date | null>;
	    readonly sourceDocument: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly rateDate: Promise<date | null>;
	    readonly isDAS2Submitted: Promise<boolean>;
	    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly dueDateCalculationStartDate: Promise<date | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly isEuropeanUnionInvoice: Promise<boolean>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly status: Promise<sageX3InvoicingData.enums.PurchasingInvoiceStatus | null>;
	    readonly paymentApproval: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
	    readonly originalInvoiceNumber: Promise<string>;
	    readonly debitOrCredit: Promise<integer | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly taxReferenceDate: Promise<date | null>;
	    readonly numberOfTaxes: Promise<integer | null>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly billBySupplierPostalCode: Promise<string>;
	    readonly billBySupplierCity: Promise<string>;
	    readonly billBySupplierState: Promise<string>;
	    readonly billBySupplierCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billBySupplierCountryName: Promise<string>;
	    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly payToBusinessPartnerPostalCode: Promise<string>;
	    readonly payToBusinessPartnerCity: Promise<string>;
	    readonly payToBusinessPartnerState: Promise<string>;
	    readonly payToBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly payToBusinessPartnerCountryName: Promise<string>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly europeanUnionIdentification: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly period: Promise<integer | null>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly lastServiceAccountedDate: Promise<date | null>;
	    readonly unblockUser: Reference<sageX3System.nodes.User | null>;
	    readonly unblockDate: Promise<date | null>;
	    readonly unblockAmount: Promise<decimal | null>;
	    readonly matchStatus: Promise<sageX3InvoicingData.enums.MatchStatusEnum | null>;
	    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
	    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly singleCustomsDocumentDate: Promise<date | null>;
	    readonly singleCustomsDocumentReference: Promise<string>;
	    readonly singleCustomsDocumentBusinessPartnerCode: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly derCode: Promise<string>;
	    readonly versionControlSystemNumber: Promise<string>;
	    readonly priceOrAmountTaxType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly recurringNumber: Promise<string>;
	    readonly importTaxAmountNumber: Promise<string>;
	    readonly recurringInvoicingDate: Promise<date | null>;
	    readonly numberOfCompanies: Promise<integer | null>;
	    readonly cashVatTaxRule: Promise<boolean>;
	    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly originalDocumentNumber: Promise<string>;
	    readonly inPaymentSlipWithReferenceLine: Promise<string>;
	    readonly bankId: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly numberOfInvoiceCopies: Promise<integer | null>;
	    readonly billBySupplierAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines>;
	    readonly billBySupplierCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames>;
	    readonly comments: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments>;
	    readonly payToBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
	    readonly payToBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
	    readonly taxes: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes>;
	}
	//# sourceMappingURL=supplier-invoice-header.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-taxes.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-taxes' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly taxBasis: Promise<decimal | null>;
	    readonly taxAmount: Promise<decimal | null>;
	    readonly deductibleTax: Promise<decimal | null>;
	    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
	}
	//# sourceMappingURL=supplier-invoice-header-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-pay-to-business-partner-company-names.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-pay-to-business-partner-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=supplier-invoice-header-pay-to-business-partner-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-pay-to-business-partner-address-lines.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-pay-to-business-partner-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderPayToBusinessPartnerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=supplier-invoice-header-pay-to-business-partner-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-comments.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-comments' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderComments extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly comment: Promise<string>;
	}
	//# sourceMappingURL=supplier-invoice-header-comments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-bill-by-supplier-company-names.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-bill-by-supplier-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderBillBySupplierCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=supplier-invoice-header-bill-by-supplier-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/supplier-invoice-header-bill-by-supplier-address-lines.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-bill-by-supplier-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierInvoiceHeaderBillBySupplierAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=supplier-invoice-header-bill-by-supplier-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/sales-invoicing-element.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/sales-invoicing-element' {
	import { Node, integer } from '@sage/xtrem-core';
	export class SalesInvoicingElement extends Node {
	    readonly code: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-invoicing-element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/purchase-invoicing-element.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/purchase-invoicing-element' {
	import { Node, integer } from '@sage/xtrem-core';
	export class PurchaseInvoicingElement extends Node {
	    readonly code: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=purchase-invoicing-element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/product-tax-levels.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/product-tax-levels' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class ProductTaxLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Product>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	}
	//# sourceMappingURL=product-tax-levels.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/product-category-tax-levels.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/product-category-tax-levels' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class ProductCategoryTaxLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly taxLevel: Reference<sageX3InvoicingData.nodes.TaxLevel | null>;
	}
	//# sourceMappingURL=product-category-tax-levels.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/price-structure.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/price-structure' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class PriceStructure extends Node {
	    readonly customerOrSupplier: Promise<sageX3MasterData.enums.SupplierCustomerType | null>;
	    readonly code: Promise<string>;
	    readonly alphaNumericNumber: Promise<string>;
	    readonly lines: Collection<sageX3InvoicingData.nodes.PriceStructureLines>;
	}
	//# sourceMappingURL=price-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/price-structure-lines.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/price-structure-lines' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class PriceStructureLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly customerOrSupplier: Promise<sageX3MasterData.enums.SupplierCustomerType>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.PriceStructure>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly description: Promise<string>;
	    readonly increaseOrDecrease: Promise<sageX3MasterData.enums.IncreaseDecrease | null>;
	    readonly valueType: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly calculationBasis: Promise<sageX3MasterData.enums.ChargeDiscountCalculation | null>;
	}
	//# sourceMappingURL=price-structure-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/payment-term.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/payment-term' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	export class PaymentTerm extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly line: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=payment-term.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/payment-method.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/payment-method' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class PaymentMethod extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=payment-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/mandate.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/mandate' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Mandate extends Node {
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner>;
	}
	//# sourceMappingURL=mandate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/invoicing-term.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/invoicing-term' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class InvoicingTerm extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=invoicing-term.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/index' {
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-bill-to-customer-address-lines';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-bill-to-customer-company-names';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-comments';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-pay-by-business-partner-address-lines';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-pay-by-business-partner-company-names';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-taxes';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header';
	export * from '@sage/x3-invoicing-data/lib/nodes/customer-invoicing-elements';
	export * from '@sage/x3-invoicing-data/lib/nodes/early-discount-late-charge';
	export * from '@sage/x3-invoicing-data/lib/nodes/invoicing-term';
	export * from '@sage/x3-invoicing-data/lib/nodes/mandate';
	export * from '@sage/x3-invoicing-data/lib/nodes/payment-method';
	export * from '@sage/x3-invoicing-data/lib/nodes/payment-term';
	export * from '@sage/x3-invoicing-data/lib/nodes/price-structure-lines';
	export * from '@sage/x3-invoicing-data/lib/nodes/price-structure';
	export * from '@sage/x3-invoicing-data/lib/nodes/product-category-tax-levels';
	export * from '@sage/x3-invoicing-data/lib/nodes/product-tax-levels';
	export * from '@sage/x3-invoicing-data/lib/nodes/purchase-invoicing-element';
	export * from '@sage/x3-invoicing-data/lib/nodes/sales-invoicing-element';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-bill-by-supplier-address-lines';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-bill-by-supplier-company-names';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-comments';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-pay-to-business-partner-address-lines';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-pay-to-business-partner-company-names';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header-taxes';
	export * from '@sage/x3-invoicing-data/lib/nodes/supplier-invoice-header';
	export * from '@sage/x3-invoicing-data/lib/nodes/tax-level';
	export * from '@sage/x3-invoicing-data/lib/nodes/tax-rule';
	export * from '@sage/x3-invoicing-data/lib/nodes/tax';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/early-discount-late-charge.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/early-discount-late-charge' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class EarlyDiscountLateCharge extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=early-discount-late-charge.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoicing-elements.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoicing-elements' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoicingElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.Customer>;
	    readonly percentageOrAmount: Promise<decimal | null>;
	    readonly invoicingElement: Reference<sageX3InvoicingData.nodes.SalesInvoicingElement | null>;
	}
	//# sourceMappingURL=customer-invoicing-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeader extends Node {
	    readonly id: Promise<string>;
	    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly control: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly financialSite: Reference<sageX3System.nodes.Site>;
	    readonly accountingDate: Promise<date | null>;
	    readonly internalNumber: Promise<integer | null>;
	    readonly sourceDocumentDate: Promise<date | null>;
	    readonly sourceDocument: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly rateDate: Promise<date | null>;
	    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly payByBusinessPartnerPostalCode: Promise<string>;
	    readonly payByBusinessPartnerCity: Promise<string>;
	    readonly payByBusinessPartnerState: Promise<string>;
	    readonly payByBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly payByBusinessPartnerCountryName: Promise<string>;
	    readonly dueDateCalculationStartDate: Promise<date | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly entityUserCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly isDirectInvoice: Promise<boolean>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly status: Promise<sageX3MasterData.enums.InvoiceStatus | null>;
	    readonly originalInvoiceNumber: Promise<string>;
	    readonly debitOrCredit: Promise<integer | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly taxReferenceDate: Promise<date | null>;
	    readonly numberOfTaxes: Promise<integer | null>;
	    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
	    readonly billToCustomerPostalCode: Promise<string>;
	    readonly billToCustomerCity: Promise<string>;
	    readonly billToCustomerState: Promise<string>;
	    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billToCustomerCountryName: Promise<string>;
	    readonly draftNumber: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly period: Promise<integer | null>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly lastServiceAccountedDate: Promise<date | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly isExternalDocument: Promise<boolean>;
	    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
	    readonly versionControlSystemNumber: Promise<string>;
	    readonly isValidatedAddress: Promise<boolean>;
	    readonly priceOrAmountTaxType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly vatDeclarationNumber: Promise<string>;
	    readonly exportDeclaration: Promise<string>;
	    readonly mandate: Reference<sageX3InvoicingData.nodes.Mandate | null>;
	    readonly recurringNumber: Promise<string>;
	    readonly recurringInvoicingDate: Promise<date | null>;
	    readonly numberOfCompanies: Promise<integer | null>;
	    readonly cashVatTaxRule: Promise<boolean>;
	    readonly derCode: Promise<string>;
	    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly originalDocumentNumber: Promise<string>;
	    readonly creditMemoReferenceStartDate: Promise<date | null>;
	    readonly creditMemoReferenceEndDate: Promise<date | null>;
	    readonly inPaymentSlipWithReferenceNumber: Promise<string>;
	    readonly cancellationStatus: Promise<integer | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly correctionMethod: Promise<sageX3InvoicingData.enums.CorrectionMethod | null>;
	    readonly siteIdentificationNumber: Promise<string>;
	    readonly spanishInvoiceType: Promise<sageX3MasterData.enums.SpanishInvoiceType | null>;
	    readonly businessProcessType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly operationType: Promise<sageX3InvoicingData.enums.TypeOfOperation | null>;
	    readonly autoInvoicingSpanish: Promise<boolean>;
	    readonly manualAutoInvoicingSpaGenerated: Promise<boolean>;
	    readonly automaticAutoInvoicingSpaGenerated: Promise<boolean>;
	    readonly destinationGeneration: Promise<sageX3InvoicingData.enums.AutoInvoiceRecipient | null>;
	    readonly spanishTaxDate: Promise<date | null>;
	    readonly billToCustomerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines>;
	    readonly billToCustomerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerCompanyNames>;
	    readonly comments: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments>;
	    readonly payByBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
	    readonly payByBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
	    readonly taxes: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes>;
	}
	//# sourceMappingURL=customer-invoice-header.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-taxes.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-taxes' {
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly taxBasis: Promise<decimal | null>;
	    readonly taxAmount: Promise<decimal | null>;
	    readonly exemptionAmount: Promise<decimal | null>;
	    readonly sageSalesTaxAmount: Promise<decimal | null>;
	}
	//# sourceMappingURL=customer-invoice-header-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-pay-by-business-partner-company-names.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-pay-by-business-partner-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=customer-invoice-header-pay-by-business-partner-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-pay-by-business-partner-address-lines.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-pay-by-business-partner-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderPayByBusinessPartnerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=customer-invoice-header-pay-by-business-partner-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-comments.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-comments' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderComments extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly comment: Promise<string>;
	}
	//# sourceMappingURL=customer-invoice-header-comments.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-bill-to-customer-company-names.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-bill-to-customer-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderBillToCustomerCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=customer-invoice-header-bill-to-customer-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/nodes/customer-invoice-header-bill-to-customer-address-lines.d.ts
declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header-bill-to-customer-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerInvoiceHeaderBillToCustomerAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=customer-invoice-header-bill-to-customer-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/supplier-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/supplier-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class SupplierExtension extends NodeExtension<sageX3MasterData.nodes.Supplier> {
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	}
	declare module '@sage/x3-master-data/lib/nodes/supplier' {
	    interface Supplier extends SupplierExtension {
	    }
	}
	//# sourceMappingURL=supplier-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/ship-to-customer-address-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/ship-to-customer-address-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class ShipToCustomerAddressExtension extends NodeExtension<sageX3MasterData.nodes.ShipToCustomerAddress> {
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address' {
	    interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {
	    }
	}
	//# sourceMappingURL=ship-to-customer-address-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly taxLevels: Collection<sageX3InvoicingData.nodes.ProductTaxLevels>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
	    readonly taxLevels: Collection<sageX3InvoicingData.nodes.ProductCategoryTaxLevels>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/index' {
	export * from '@sage/x3-invoicing-data/lib/node-extensions/business-partner-company-exception-extension';
	export * from '@sage/x3-invoicing-data/lib/node-extensions/customer-extension';
	export * from '@sage/x3-invoicing-data/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-invoicing-data/lib/node-extensions/product-extension';
	export * from '@sage/x3-invoicing-data/lib/node-extensions/ship-to-customer-address-extension';
	export * from '@sage/x3-invoicing-data/lib/node-extensions/supplier-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/customer-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/customer-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class CustomerExtension extends NodeExtension<sageX3MasterData.nodes.Customer> {
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm | null>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
	    readonly invoicingElements: Collection<sageX3InvoicingData.nodes.CustomerInvoicingElements>;
	}
	declare module '@sage/x3-master-data/lib/nodes/customer' {
	    interface Customer extends CustomerExtension {
	    }
	}
	//# sourceMappingURL=customer-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/node-extensions/business-partner-company-exception-extension.d.ts
declare module '@sage/x3-invoicing-data/lib/node-extensions/business-partner-company-exception-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data/lib/index';
	export class BusinessPartnerCompanyExceptionExtension extends NodeExtension<sageX3MasterData.nodes.BusinessPartnerCompanyException> {
	    readonly businessPartnerTaxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly customerTaxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly supplierTaxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly customerPaymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm | null>;
	    readonly supplierPaymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm | null>;
	    readonly customerEarlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly supplierEarlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/business-partner-company-exception' {
	    interface BusinessPartnerCompanyException extends BusinessPartnerCompanyExceptionExtension {
	    }
	}
	//# sourceMappingURL=business-partner-company-exception-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/type-of-operation.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/type-of-operation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfOperationEnum {
	    goodsDelivery = 1,
	    provisionOfServices = 2,
	    mixedOperation = 3
	}
	export interface TypeOfOperation$EnumInterface {
	    goodsDelivery: 1;
	    provisionOfServices: 2;
	    mixedOperation: 3;
	}
	export type TypeOfOperation = keyof TypeOfOperation$EnumInterface;
	export const typeOfOperationDatatype: X3EnumDataType<keyof TypeOfOperation$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/purchasing-invoice-status.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/purchasing-invoice-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchasingInvoiceStatusEnum {
	    pending = 1,
	    toValidate = 2,
	    validated = 3
	}
	export interface PurchasingInvoiceStatus$EnumInterface {
	    pending: 1;
	    toValidate: 2;
	    validated: 3;
	}
	export type PurchasingInvoiceStatus = keyof PurchasingInvoiceStatus$EnumInterface;
	export const purchasingInvoiceStatusDatatype: X3EnumDataType<keyof PurchasingInvoiceStatus$EnumInterface, unknown>;
	//# sourceMappingURL=purchasing-invoice-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/purchase-type.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/purchase-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseTypeEnum {
	    purchase = 1,
	    fixedAsset = 2,
	    services = 3
	}
	export interface PurchaseType$EnumInterface {
	    purchase: 1;
	    fixedAsset: 2;
	    services: 3;
	}
	export type PurchaseType = keyof PurchaseType$EnumInterface;
	export const purchaseTypeDatatype: X3EnumDataType<keyof PurchaseType$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/periodicity-type.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/periodicity-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PeriodicityTypeEnum {
	    days = 1,
	    week = 2,
	    tenDayPeriod = 3,
	    twoWeekPeriod = 4,
	    month = 5
	}
	export interface PeriodicityType$EnumInterface {
	    days: 1;
	    week: 2;
	    tenDayPeriod: 3;
	    twoWeekPeriod: 4;
	    month: 5;
	}
	export type PeriodicityType = keyof PeriodicityType$EnumInterface;
	export const periodicityTypeDatatype: X3EnumDataType<keyof PeriodicityType$EnumInterface, unknown>;
	//# sourceMappingURL=periodicity-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/match-status-enum.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/match-status-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MatchStatusEnumEnum {
	    notApplicable = 1,
	    successful = 2,
	    warning = 3,
	    blocked = 4,
	    unblocked = 5
	}
	export interface MatchStatusEnum$EnumInterface {
	    notApplicable: 1;
	    successful: 2;
	    warning: 3;
	    blocked: 4;
	    unblocked: 5;
	}
	export type MatchStatusEnum = keyof MatchStatusEnum$EnumInterface;
	export const matchStatusEnumDatatype: X3EnumDataType<keyof MatchStatusEnum$EnumInterface, unknown>;
	//# sourceMappingURL=match-status-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/invoice-type.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/invoice-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceTypeEnum {
	    invoice = 1,
	    creditMemo = 2,
	    debitNote = 3,
	    creditNote = 4,
	    proforma = 5
	}
	export interface InvoiceType$EnumInterface {
	    invoice: 1;
	    creditMemo: 2;
	    debitNote: 3;
	    creditNote: 4;
	    proforma: 5;
	}
	export type InvoiceType = keyof InvoiceType$EnumInterface;
	export const invoiceTypeDatatype: X3EnumDataType<keyof InvoiceType$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/index.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/index' {
	export * from '@sage/x3-invoicing-data/lib/enums/auto-invoice-recipient';
	export * from '@sage/x3-invoicing-data/lib/enums/correction-method';
	export * from '@sage/x3-invoicing-data/lib/enums/invoice-type';
	export * from '@sage/x3-invoicing-data/lib/enums/match-status-enum';
	export * from '@sage/x3-invoicing-data/lib/enums/periodicity-type';
	export * from '@sage/x3-invoicing-data/lib/enums/purchase-type';
	export * from '@sage/x3-invoicing-data/lib/enums/purchasing-invoice-status';
	export * from '@sage/x3-invoicing-data/lib/enums/type-of-operation';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/correction-method.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/correction-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CorrectionMethodEnum {
	    rectificacionIntegra = 1,
	    rectificacionPorDiferencias = 2,
	    rectificacionPorDescuentoPorVolumenDeOperacionesDuranteUnPeriodo = 3,
	    autorizadasPorLaAgenciaTributaria = 4
	}
	export interface CorrectionMethod$EnumInterface {
	    rectificacionIntegra: 1;
	    rectificacionPorDiferencias: 2;
	    rectificacionPorDescuentoPorVolumenDeOperacionesDuranteUnPeriodo: 3;
	    autorizadasPorLaAgenciaTributaria: 4;
	}
	export type CorrectionMethod = keyof CorrectionMethod$EnumInterface;
	export const correctionMethodDatatype: X3EnumDataType<keyof CorrectionMethod$EnumInterface, unknown>;
	//# sourceMappingURL=correction-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-invoicing-data/build/lib/enums/auto-invoice-recipient.d.ts
declare module '@sage/x3-invoicing-data/lib/enums/auto-invoice-recipient' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutoInvoiceRecipientEnum {
	    no = 1,
	    company = 2,
	    bp = 3
	}
	export interface AutoInvoiceRecipient$EnumInterface {
	    no: 1;
	    company: 2;
	    bp: 3;
	}
	export type AutoInvoiceRecipient = keyof AutoInvoiceRecipient$EnumInterface;
	export const autoInvoiceRecipientDatatype: X3EnumDataType<keyof AutoInvoiceRecipient$EnumInterface, unknown>;
	//# sourceMappingURL=auto-invoice-recipient.d.ts.map
}
declare module '@sage/x3-invoicing-data' {
	export * from '@sage/x3-invoicing-data/index';
}
