"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierInvoiceHeader = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3InvoicingData = require("..");
const joins = {
    referenceJoins: {
        billBySupplier: {
            code: 'billBySupplier',
        },
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        currency: {
            code: 'currency',
        },
        payToBusinessPartner: {
            code: 'payToBusinessPartner',
        },
        paymentTerm: {
            code: 'paymentTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
            line() {
                return 1;
            },
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        taxRule: {
            code: 'taxRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        billBySupplierAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'billBySupplier',
            code: 'billBySupplierAddress',
        },
        billBySupplierCountry: {
            code: 'billBySupplierCountry',
        },
        payToBusinessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payToBusinessPartner',
            code: 'payToBusinessPartnerAddress',
        },
        payToBusinessPartnerCountry: {
            code: 'payToBusinessPartnerCountry',
        },
        incoterm: {
            code: 'incoterm',
        },
        forwardingAgent: {
            code: 'forwardingAgent',
        },
        forwardingAgentAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'forwardingAgent',
            code: 'forwardingAgentAddress',
        },
        unblockUser: {
            code: 'unblockUser',
        },
        singleCustomsDocumentBusinessPartnerCode: {
            code: 'singleCustomsDocumentBusinessPartnerCode',
        },
        field40Reason: {
            glossaryId() {
                return 8300;
            },
            code: 'field40Reason',
        },
        field41Reason: {
            glossaryId() {
                return 8301;
            },
            code: 'field41Reason',
        },
        project: {
            id: 'project',
        },
    },
};
let SupplierInvoiceHeader = class SupplierInvoiceHeader extends xtrem_core_1.Node {
};
exports.SupplierInvoiceHeader = SupplierInvoiceHeader;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYP',
        dataType: () => sageX3InvoicingData.enums.invoiceTypeDatatype,
    })
], SupplierInvoiceHeader.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIHTYP',
        dataType: () => sageX3MasterData.enums.purchaseInvoiceCategoryDatatype,
    })
], SupplierInvoiceHeader.prototype, "purchaseInvoiceCategory", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIMOD',
        dataType: () => sageX3System.enums.moduleTableDatatype,
    })
], SupplierInvoiceHeader.prototype, "sourceModule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], SupplierInvoiceHeader.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "control", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SupplierInvoiceHeader.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SupplierInvoiceHeader.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], SupplierInvoiceHeader.prototype, "internalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "internalReference", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "sourceDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "sourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], SupplierInvoiceHeader.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], SupplierInvoiceHeader.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "rateDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAS2',
        serviceOptions: () => [sageX3System.serviceOptions.Fee2ActivityCode],
    })
], SupplierInvoiceHeader.prototype, "isDAS2Submitted", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDUDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "dueDateCalculationStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        filters: {
            lookup: {
                line: 1,
            },
            control: {
                line: 1,
            },
        },
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], SupplierInvoiceHeader.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], SupplierInvoiceHeader.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "earlyDiscountOrLateChargeRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VAC',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], SupplierInvoiceHeader.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CEEFLG',
    })
], SupplierInvoiceHeader.prototype, "isEuropeanUnionInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNUMDEB',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SupplierInvoiceHeader.prototype, "intrastatProcessingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STA',
        dataType: () => sageX3InvoicingData.enums.purchasingInvoiceStatusDatatype,
    })
], SupplierInvoiceHeader.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAZ',
        dataType: () => sageX3MasterData.enums.paymentApprovalTypeDatatype,
    })
], SupplierInvoiceHeader.prototype, "paymentApproval", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "originalInvoiceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], SupplierInvoiceHeader.prototype, "debitOrCredit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "taxReferenceDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRTAX',
    })
], SupplierInvoiceHeader.prototype, "numberOfTaxes", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPYCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], SupplierInvoiceHeader.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SupplierInvoiceHeader.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SupplierInvoiceHeader.prototype, "europeanUnionIdentification", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SupplierInvoiceHeader.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], SupplierInvoiceHeader.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], SupplierInvoiceHeader.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PER',
    })
], SupplierInvoiceHeader.prototype, "period", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SupplierInvoiceHeader.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SupplierInvoiceHeader.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SupplierInvoiceHeader.prototype, "lastServiceAccountedDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UBLUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], SupplierInvoiceHeader.prototype, "unblockUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UBLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "unblockDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UBLAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "unblockAmount", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TWMSTA',
        dataType: () => sageX3InvoicingData.enums.matchStatusEnumDatatype,
    })
], SupplierInvoiceHeader.prototype, "matchStatus", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASDEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeader.prototype, "earlyDiscountOrLateChargeBasis", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPTYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], SupplierInvoiceHeader.prototype, "priceOrAmountType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPACUSDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SupplierInvoiceHeader.prototype, "singleCustomsDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPACUS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SupplierInvoiceHeader.prototype, "singleCustomsDocumentReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPACUSBPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SupplierInvoiceHeader.prototype, "singleCustomsDocumentBusinessPartnerCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPADERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SupplierInvoiceHeader.prototype, "derCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BELVCS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KbeActivityCode],
    })
], SupplierInvoiceHeader.prototype, "versionControlSystemNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PURPRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], SupplierInvoiceHeader.prototype, "priceOrAmountTaxType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeader.prototype, "recurringNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PORIMPLIQNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SupplierInvoiceHeader.prototype, "importTaxAmountNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SupplierInvoiceHeader.prototype, "recurringInvoicingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRCPY',
    })
], SupplierInvoiceHeader.prototype, "numberOfCompanies", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSHVAT',
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SupplierInvoiceHeader.prototype, "cashVatTaxRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD40REN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 8300,
            },
            control: {
                glossaryId: 8300,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SupplierInvoiceHeader.prototype, "field40Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD41REN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 8301,
            },
            control: {
                glossaryId: 8301,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SupplierInvoiceHeader.prototype, "field41Reason", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORIDOCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SupplierInvoiceHeader.prototype, "originalDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BVRREFLINE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], SupplierInvoiceHeader.prototype, "inPaymentSlipWithReferenceLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BVRBID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], SupplierInvoiceHeader.prototype, "bankId", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJTH',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SupplierInvoiceHeader.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COPNBR',
    })
], SupplierInvoiceHeader.prototype, "numberOfInvoiceCopies", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames,
    })
], SupplierInvoiceHeader.prototype, "billBySupplierCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments,
    })
], SupplierInvoiceHeader.prototype, "comments", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
    })
], SupplierInvoiceHeader.prototype, "payToBusinessPartnerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes,
    })
], SupplierInvoiceHeader.prototype, "taxes", void 0);
exports.SupplierInvoiceHeader = SupplierInvoiceHeader = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PINVOICE',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SupplierInvoiceHeader);
//# sourceMappingURL=supplier-invoice-header.js.map