import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3InvoicingData from '..';
export declare class SupplierInvoiceHeader extends Node {
    readonly id: Promise<string>;
    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly control: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly accountingDate: Promise<date | null>;
    readonly internalNumber: Promise<integer | null>;
    readonly internalReference: Promise<string>;
    readonly sourceDocumentDate: Promise<date | null>;
    readonly sourceDocument: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly rateDate: Promise<date | null>;
    readonly isDAS2Submitted: Promise<boolean>;
    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly dueDateCalculationStartDate: Promise<date | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
    readonly isEuropeanUnionInvoice: Promise<boolean>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly status: Promise<sageX3InvoicingData.enums.PurchasingInvoiceStatus | null>;
    readonly paymentApproval: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
    readonly originalInvoiceNumber: Promise<string>;
    readonly debitOrCredit: Promise<integer | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly taxReferenceDate: Promise<date | null>;
    readonly numberOfTaxes: Promise<integer | null>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly billBySupplierPostalCode: Promise<string>;
    readonly billBySupplierCity: Promise<string>;
    readonly billBySupplierState: Promise<string>;
    readonly billBySupplierCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billBySupplierCountryName: Promise<string>;
    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly payToBusinessPartnerPostalCode: Promise<string>;
    readonly payToBusinessPartnerCity: Promise<string>;
    readonly payToBusinessPartnerState: Promise<string>;
    readonly payToBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly payToBusinessPartnerCountryName: Promise<string>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly europeanUnionIdentification: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly fiscalYear: Promise<integer | null>;
    readonly period: Promise<integer | null>;
    readonly serviceStartDate: Promise<date | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly lastServiceAccountedDate: Promise<date | null>;
    readonly unblockUser: Reference<sageX3System.nodes.User | null>;
    readonly unblockDate: Promise<date | null>;
    readonly unblockAmount: Promise<decimal | null>;
    readonly matchStatus: Promise<sageX3InvoicingData.enums.MatchStatusEnum | null>;
    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly singleCustomsDocumentDate: Promise<date | null>;
    readonly singleCustomsDocumentReference: Promise<string>;
    readonly singleCustomsDocumentBusinessPartnerCode: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly derCode: Promise<string>;
    readonly versionControlSystemNumber: Promise<string>;
    readonly priceOrAmountTaxType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly recurringNumber: Promise<string>;
    readonly importTaxAmountNumber: Promise<string>;
    readonly recurringInvoicingDate: Promise<date | null>;
    readonly numberOfCompanies: Promise<integer | null>;
    readonly cashVatTaxRule: Promise<boolean>;
    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly originalDocumentNumber: Promise<string>;
    readonly inPaymentSlipWithReferenceLine: Promise<string>;
    readonly bankId: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly numberOfInvoiceCopies: Promise<integer | null>;
    readonly billBySupplierAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines>;
    readonly billBySupplierCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames>;
    readonly comments: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments>;
    readonly payToBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
    readonly payToBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
    readonly taxes: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes>;
}
//# sourceMappingURL=supplier-invoice-header.d.ts.map