"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupplierInvoiceHeaderTaxes = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3InvoicingData = require("..");
const denormalized = { maxRepeat: 20 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            id: 'id',
        },
        tax: {
            code: 'tax',
            async legislation() {
                return (await (await (await (await this._denormalizedParent).site).legalCompany).legislation)?.code;
            },
        },
    },
};
let SupplierInvoiceHeaderTaxes = class SupplierInvoiceHeaderTaxes extends xtrem_core_1.Node {
};
exports.SupplierInvoiceHeaderTaxes = SupplierInvoiceHeaderTaxes;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], SupplierInvoiceHeaderTaxes.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SupplierInvoiceHeaderTaxes.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeader,
    })
], SupplierInvoiceHeaderTaxes.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAX',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
    })
], SupplierInvoiceHeaderTaxes.prototype, "tax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeaderTaxes.prototype, "taxBasis", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeaderTaxes.prototype, "taxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SupplierInvoiceHeaderTaxes.prototype, "deductibleTax", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PURTYP',
        dataType: () => sageX3InvoicingData.enums.purchaseTypeDatatype,
    })
], SupplierInvoiceHeaderTaxes.prototype, "purchaseType", void 0);
exports.SupplierInvoiceHeaderTaxes = SupplierInvoiceHeaderTaxes = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PINVOICE',
        keyPropertyNames: ['denormalizedIndex', 'id'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], SupplierInvoiceHeaderTaxes);
//# sourceMappingURL=supplier-invoice-header-taxes.js.map