"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PriceStructure = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3InvoicingData = require("..");
const joins = {};
let PriceStructure = class PriceStructure extends xtrem_core_1.Node {
};
exports.PriceStructure = PriceStructure;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCBPS',
        dataType: () => sageX3MasterData.enums.supplierCustomerTypeDatatype,
    })
], PriceStructure.prototype, "customerOrSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLISTC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PriceStructure.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCBPSCAR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PriceStructure.prototype, "alphaNumericNumber", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3InvoicingData.nodes.PriceStructureLines,
    })
], PriceStructure.prototype, "lines", void 0);
exports.PriceStructure = PriceStructure = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRICSTRUCT',
        keyPropertyNames: ['customerOrSupplier', 'code'],
        indexes: [
            {
                orderBy: {
                    customerOrSupplier: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['customerOrSupplier', 'code'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PriceStructure);
//# sourceMappingURL=price-structure.js.map