"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PriceStructureLines = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3InvoicingData = require("..");
const denormalized = { maxRepeat: 9 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            customerOrSupplier: 'customerOrSupplier',
            code: 'code',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PRICSTRUCT';
            },
            async columnName() {
                return typesLib.add(typesLib.add('DESAXX(', (typesLib.sub((await this.denormalizedIndex), 1))), ')');
            },
            key1: ['customerOrSupplier'],
            key2: ['code'],
        },
        localizedShortDescription: {
            tableName() {
                return 'PRICSTRUCT';
            },
            async columnName() {
                return typesLib.add(typesLib.add('SHOAXX(', (typesLib.sub((await this.denormalizedIndex), 1))), ')');
            },
            key1: ['customerOrSupplier'],
            key2: ['code'],
        },
    },
};
let PriceStructureLines = class PriceStructureLines extends xtrem_core_1.Node {
};
exports.PriceStructureLines = PriceStructureLines;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], PriceStructureLines.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCBPS',
        dataType: () => sageX3MasterData.enums.supplierCustomerTypeDatatype,
    })
], PriceStructureLines.prototype, "customerOrSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PLISTC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PriceStructureLines.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.PriceStructure,
    })
], PriceStructureLines.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], PriceStructureLines.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], PriceStructureLines.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LANDESSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PriceStructureLines.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INCDCR',
        dataType: () => sageX3MasterData.enums.increaseDecreaseDatatype,
    })
], PriceStructureLines.prototype, "increaseOrDecrease", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VALTYP',
        dataType: () => sageX3MasterData.enums.discountCalculationRulesDatatype,
    })
], PriceStructureLines.prototype, "valueType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCRUL',
        dataType: () => sageX3MasterData.enums.chargeDiscountCalculationDatatype,
    })
], PriceStructureLines.prototype, "calculationBasis", void 0);
exports.PriceStructureLines = PriceStructureLines = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRICSTRUCT',
        keyPropertyNames: ['denormalizedIndex', 'customerOrSupplier', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], PriceStructureLines);
//# sourceMappingURL=price-structure-lines.js.map