"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentTerm = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'TABPAYTERM';
            },
            columnName() {
                return 'DESAXX';
            },
            key1: ['code'],
            key2: ['legislation'],
        },
        localizedShortDescription: {
            tableName() {
                return 'TABPAYTERM';
            },
            columnName() {
                return 'SHOAXX';
            },
            key1: ['code'],
            key2: ['legislation'],
        },
    },
};
let PaymentTerm = class PaymentTerm extends xtrem_core_1.Node {
};
exports.PaymentTerm = PaymentTerm;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PaymentTerm.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PaymentTerm.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTELIN',
    })
], PaymentTerm.prototype, "line", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], PaymentTerm.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], PaymentTerm.prototype, "localizedShortDescription", void 0);
exports.PaymentTerm = PaymentTerm = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABPAYTERM',
        keyPropertyNames: ['code', 'legislation', 'line'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    legislation: 1,
                    line: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['code', 'legislation', 'line'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PaymentTerm);
//# sourceMappingURL=payment-term.js.map