import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3InvoicingData from '..';
export declare class CustomerInvoiceHeader extends Node {
    readonly id: Promise<string>;
    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly control: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly financialSite: Reference<sageX3System.nodes.Site>;
    readonly accountingDate: Promise<date | null>;
    readonly internalNumber: Promise<integer | null>;
    readonly sourceDocumentDate: Promise<date | null>;
    readonly sourceDocument: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly rateDate: Promise<date | null>;
    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly payByBusinessPartnerPostalCode: Promise<string>;
    readonly payByBusinessPartnerCity: Promise<string>;
    readonly payByBusinessPartnerState: Promise<string>;
    readonly payByBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly payByBusinessPartnerCountryName: Promise<string>;
    readonly dueDateCalculationStartDate: Promise<date | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly entityUserCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly isDirectInvoice: Promise<boolean>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly status: Promise<sageX3MasterData.enums.InvoiceStatus | null>;
    readonly originalInvoiceNumber: Promise<string>;
    readonly debitOrCredit: Promise<integer | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly taxReferenceDate: Promise<date | null>;
    readonly numberOfTaxes: Promise<integer | null>;
    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly billToCustomerPostalCode: Promise<string>;
    readonly billToCustomerCity: Promise<string>;
    readonly billToCustomerState: Promise<string>;
    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billToCustomerCountryName: Promise<string>;
    readonly draftNumber: Promise<string>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly fiscalYear: Promise<integer | null>;
    readonly period: Promise<integer | null>;
    readonly serviceStartDate: Promise<date | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly lastServiceAccountedDate: Promise<date | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly isPrinted: Promise<boolean>;
    readonly isExternalDocument: Promise<boolean>;
    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
    readonly versionControlSystemNumber: Promise<string>;
    readonly isValidatedAddress: Promise<boolean>;
    readonly priceOrAmountTaxType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly vatDeclarationNumber: Promise<string>;
    readonly exportDeclaration: Promise<string>;
    readonly mandate: Reference<sageX3InvoicingData.nodes.Mandate | null>;
    readonly recurringNumber: Promise<string>;
    readonly recurringInvoicingDate: Promise<date | null>;
    readonly numberOfCompanies: Promise<integer | null>;
    readonly cashVatTaxRule: Promise<boolean>;
    readonly derCode: Promise<string>;
    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly originalDocumentNumber: Promise<string>;
    readonly creditMemoReferenceStartDate: Promise<date | null>;
    readonly creditMemoReferenceEndDate: Promise<date | null>;
    readonly inPaymentSlipWithReferenceNumber: Promise<string>;
    readonly cancellationStatus: Promise<integer | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly correctionMethod: Promise<sageX3InvoicingData.enums.CorrectionMethod | null>;
    readonly siteIdentificationNumber: Promise<string>;
    readonly spanishInvoiceType: Promise<sageX3MasterData.enums.SpanishInvoiceType | null>;
    readonly businessProcessType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly operationType: Promise<sageX3InvoicingData.enums.TypeOfOperation | null>;
    readonly autoInvoicingSpanish: Promise<boolean>;
    readonly manualAutoInvoicingSpaGenerated: Promise<boolean>;
    readonly automaticAutoInvoicingSpaGenerated: Promise<boolean>;
    readonly destinationGeneration: Promise<sageX3InvoicingData.enums.AutoInvoiceRecipient | null>;
    readonly spanishTaxDate: Promise<date | null>;
    readonly billToCustomerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines>;
    readonly billToCustomerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerCompanyNames>;
    readonly comments: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments>;
    readonly payByBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
    readonly payByBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
    readonly taxes: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes>;
}
//# sourceMappingURL=customer-invoice-header.d.ts.map