"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournalEntry = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const joins = {
    referenceJoins: {
        journalEntryType: {
            code: 'journalEntryType',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        journal: {
            code: 'journal',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        journalEntryTransaction: {
            code: 'journalEntryTransaction',
        },
        transactionCurrency: {
            code: 'transactionCurrency',
        },
    },
    collectionJoins: {
        journalEntryLines: {
            journalEntryType: 'journalEntryType',
            journalEntry: 'journalEntryNumber',
        },
    },
};
let JournalEntry = class JournalEntry extends xtrem_core_1.Node {
};
exports.JournalEntry = JournalEntry;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], JournalEntry.prototype, "journalEntryType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntry.prototype, "journalEntryNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], JournalEntry.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], JournalEntry.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'JOU',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Journal,
    })
], JournalEntry.prototype, "journal", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], JournalEntry.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STA',
        dataType: () => sageX3FinanceData.enums.accountingJournalStatusDatatype,
    })
], JournalEntry.prototype, "journalEntryStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DACDIA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.JournalEntryTransaction,
    })
], JournalEntry.prototype, "journalEntryTransaction", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], JournalEntry.prototype, "transactionCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Finance.nodes.JournalEntryLine,
        isMutable: true,
        dependsOn: ['journalEntryType', 'journalEntryNumber'],
    })
], JournalEntry.prototype, "journalEntryLines", void 0);
exports.JournalEntry = JournalEntry = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCENTRY',
        keyPropertyNames: ['journalEntryType', 'journalEntryNumber'],
        indexes: [
            {
                orderBy: {
                    journalEntryType: 1,
                    journalEntryNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['journalEntryNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        authorizationCode: 'GESGAS',
    })
], JournalEntry);
//# sourceMappingURL=journal-entry.js.map