"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyticalBalanceAmounts = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'PER'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            ledgerTypeNumber: 'ledgerTypeNumber',
            company: 'company',
            site: 'site',
            fiscalYear: 'fiscalYear',
            account: 'account',
            businessPartner: 'businessPartner',
            dimension1: 'dimension1',
            dimension2: 'dimension2',
            dimension3: 'dimension3',
            dimension4: 'dimension4',
            dimension5: 'dimension5',
            dimension6: 'dimension6',
            dimension7: 'dimension7',
            dimension8: 'dimension8',
            dimension9: 'dimension9',
            currency: 'currency',
        },
    },
};
let AnalyticalBalanceAmounts = class AnalyticalBalanceAmounts extends xtrem_core_1.Node {
};
exports.AnalyticalBalanceAmounts = AnalyticalBalanceAmounts;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], AnalyticalBalanceAmounts.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CPY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'FCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIY',
    })
], AnalyticalBalanceAmounts.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ACC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension5", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension6", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension7", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension8", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "dimension9", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Finance.nodes.AnalyticalBalance,
    })
], AnalyticalBalanceAmounts.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEBLED',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "debitAmountInLedgerCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDTLED',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "creditAmountInLedgerCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "debitAmountInCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], AnalyticalBalanceAmounts.prototype, "creditAmountInCurrency", void 0);
exports.AnalyticalBalanceAmounts = AnalyticalBalanceAmounts = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BALANA',
        keyPropertyNames: [
            'denormalizedIndex',
            'ledgerTypeNumber',
            'company',
            'site',
            'fiscalYear',
            'account',
            'businessPartner',
            'dimension1',
            'dimension2',
            'dimension3',
            'dimension4',
            'dimension5',
            'dimension6',
            'dimension7',
            'dimension8',
            'dimension9',
            'currency',
        ],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], AnalyticalBalanceAmounts);
//# sourceMappingURL=analytical-balance-amounts.js.map