"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockJournalImportDimensions = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3FinanceData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'ANA'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockSite: 'stockSite',
            isUpdated: 'isUpdated',
            product: 'product',
            effectiveDate: 'effectiveDate',
            sequence: 'sequence',
            index: 'index',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
        dimension: {
            dimensionType: 'dimensionType',
            dimension: 'dimension',
        },
    },
};
let StockJournalImportDimensions = class StockJournalImportDimensions extends xtrem_core_1.Node {
};
exports.StockJournalImportDimensions = StockJournalImportDimensions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], StockJournalImportDimensions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockJournalImportDimensions.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UPDCOD',
    })
], StockJournalImportDimensions.prototype, "isUpdated", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITMREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockJournalImportDimensions.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IPTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockJournalImportDimensions.prototype, "effectiveDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTSEQ',
    })
], StockJournalImportDimensions.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTIND',
    })
], StockJournalImportDimensions.prototype, "index", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.StockJournalImport,
    })
], StockJournalImportDimensions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], StockJournalImportDimensions.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Dimension,
    })
], StockJournalImportDimensions.prototype, "dimension", void 0);
exports.StockJournalImportDimensions = StockJournalImportDimensions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOJOU',
        keyPropertyNames: ['denormalizedIndex', 'stockSite', 'isUpdated', 'product', 'effectiveDate', 'sequence', 'index'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], StockJournalImportDimensions);
//# sourceMappingURL=stock-journal-import-dimensions.js.map