"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockJournalDimensions = void 0;
const sageX3StockData = require("@sage/x3-stock-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3FinanceData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'ANA'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockSite: 'stockSite',
            isUpdated: 'isUpdated',
            product: 'product',
            effectiveDate: 'effectiveDate',
            sequence: 'sequence',
            index: 'index',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
        dimension: {
            dimensionType: 'dimensionType',
            dimension: 'dimension',
        },
    },
};
let StockJournalDimensions = class StockJournalDimensions extends xtrem_core_1.Node {
};
exports.StockJournalDimensions = StockJournalDimensions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], StockJournalDimensions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockJournalDimensions.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UPDCOD',
    })
], StockJournalDimensions.prototype, "isUpdated", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITMREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockJournalDimensions.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IPTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockJournalDimensions.prototype, "effectiveDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTSEQ',
    })
], StockJournalDimensions.prototype, "sequence", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTIND',
    })
], StockJournalDimensions.prototype, "index", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3StockData.nodes.StockJournal,
    })
], StockJournalDimensions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], StockJournalDimensions.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Dimension,
    })
], StockJournalDimensions.prototype, "dimension", void 0);
exports.StockJournalDimensions = StockJournalDimensions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOJOU',
        keyPropertyNames: ['denormalizedIndex', 'stockSite', 'isUpdated', 'product', 'effectiveDate', 'sequence', 'index'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], StockJournalDimensions);
//# sourceMappingURL=stock-journal-dimensions.js.map