"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RevenueRecognitionRules = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3FinanceData = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        project: {
            id: 'project',
        },
        ledgerType: {
            glossaryId() {
                return 909;
            },
            code: 'ledgerType',
        },
        access: {
            access: 'access',
        },
    },
};
let RevenueRecognitionRules = class RevenueRecognitionRules extends xtrem_core_1.Node {
};
exports.RevenueRecognitionRules = RevenueRecognitionRules;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], RevenueRecognitionRules.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RRCC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RevenueRecognitionRules.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], RevenueRecognitionRules.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESTRA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], RevenueRecognitionRules.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], RevenueRecognitionRules.prototype, "ledger", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], RevenueRecognitionRules.prototype, "ledgerType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], RevenueRecognitionRules.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RRECMET',
        dataType: () => sageX3FinanceData.enums.revenueRecognitionMethodDatatype,
    })
], RevenueRecognitionRules.prototype, "revenueRecognitionMethod", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACTIVE',
    })
], RevenueRecognitionRules.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REVTYP',
        dataType: () => sageX3FinanceData.enums.revenueRecognitonTypeDatatype,
    })
], RevenueRecognitionRules.prototype, "revenueType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DIE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RevenueRecognitionRules.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODDIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], RevenueRecognitionRules.prototype, "analyticalDimension", void 0);
exports.RevenueRecognitionRules = RevenueRecognitionRules = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'REVREC',
        keyPropertyNames: ['company', 'code'],
        indexes: [
            {
                orderBy: {
                    company: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['code'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.RevrcActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], RevenueRecognitionRules);
//# sourceMappingURL=revenue-recognition-rules.js.map