"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountingCode = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3FinanceData = require("..");
const joins = {
    referenceJoins: {
        chartOfAccounts: {
            code: 'chartOfAccounts',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'GACCCODE';
            },
            columnName() {
                return 'DESTRA';
            },
            key1: ['type'],
            key2: ['accountingCode'],
        },
        localizedShortDescription: {
            tableName() {
                return 'GACCCODE';
            },
            columnName() {
                return 'SHOTRA';
            },
            key1: ['type'],
            key2: ['accountingCode'],
        },
    },
};
let AccountingCode = class AccountingCode extends xtrem_core_1.Node {
};
exports.AccountingCode = AccountingCode;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYP',
        dataType: () => sageX3MasterData.enums.accountingCodeTypeDatatype,
    })
], AccountingCode.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ACCCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AccountingCode.prototype, "accountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], AccountingCode.prototype, "chartOfAccounts", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESTRA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], AccountingCode.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOTRA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], AccountingCode.prototype, "localizedShortDescription", void 0);
exports.AccountingCode = AccountingCode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCCODE',
        keyPropertyNames: ['type', 'accountingCode', 'chartOfAccounts'],
        indexes: [
            {
                orderBy: {
                    type: 1,
                    accountingCode: 1,
                    chartOfAccounts: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['type', 'chartOfAccounts'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AccountingCode);
//# sourceMappingURL=accounting-code.js.map