"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3FinanceData = require("..");
const joins = {
    referenceJoins: {
        reminderGroup: {
            code: 'reminderGroup',
        },
        factor: {
            code: 'factor',
        },
        paymentBank: {
            bank: 'paymentBank',
        },
        accountingCode: {
            type() {
                return 'customer';
            },
            accountingCode: 'accountingCode',
        },
        accountStructure: {
            code: 'accountStructure',
        },
    },
};
let CustomerExtension = class CustomerExtension extends xtrem_core_1.NodeExtension {
};
exports.CustomerExtension = CustomerExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRP',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ReminderGroup,
        serviceOptions: () => [sageX3System.serviceOptions.FupActivityCode],
    })
], CustomerExtension.prototype, "reminderGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCTNUM',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Factor,
        serviceOptions: () => [sageX3System.serviceOptions.FctActivityCode],
    })
], CustomerExtension.prototype, "factor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYBAN',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.BankAccount,
    })
], CustomerExtension.prototype, "paymentBank", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCCOD',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'customer',
            },
            control: {
                type: 'customer',
            },
        },
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], CustomerExtension.prototype, "accountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AccountScheme,
    })
], CustomerExtension.prototype, "accountStructure", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3FinanceData.nodes.CustomerDimensions,
    })
], CustomerExtension.prototype, "dimensions", void 0);
exports.CustomerExtension = CustomerExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.Customer,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], CustomerExtension);
//# sourceMappingURL=customer-extension.js.map