"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessPartnerCompanyExceptionExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3FinanceData = require("..");
const joins = {
    referenceJoins: {
        customerAccountingCode: {
            type() {
                return 'customer';
            },
            accountingCode: 'customerAccountingCode',
        },
        supplierAccountingCode: {
            type() {
                return 'supplier';
            },
            accountingCode: 'supplierAccountingCode',
        },
        paymentBankIsrQr: {
            bank: 'paymentBankIsrQr',
        },
    },
};
let BusinessPartnerCompanyExceptionExtension = class BusinessPartnerCompanyExceptionExtension extends xtrem_core_1.NodeExtension {
};
exports.BusinessPartnerCompanyExceptionExtension = BusinessPartnerCompanyExceptionExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCBPC',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'customer',
            },
            control: {
                type: 'customer',
            },
        },
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], BusinessPartnerCompanyExceptionExtension.prototype, "customerAccountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCBPS',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'supplier',
            },
            control: {
                type: 'supplier',
            },
        },
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], BusinessPartnerCompanyExceptionExtension.prototype, "supplierAccountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYBANBVR',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.BankAccount,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], BusinessPartnerCompanyExceptionExtension.prototype, "paymentBankIsrQr", void 0);
exports.BusinessPartnerCompanyExceptionExtension = BusinessPartnerCompanyExceptionExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.BusinessPartnerCompanyException,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], BusinessPartnerCompanyExceptionExtension);
//# sourceMappingURL=business-partner-company-exception-extension.js.map