import { KonvaEventObject } from 'konva/types/Node';
import * as React from 'react';
import { VpEditArrangeMenuItemType } from './components/menu/vp-edit-arrange-menu';
import { ToolbarGroup } from './components/toolbar/vp-toolbar';
import { TooltipLocalization, TooltipMappedType } from './components/vertical-toolbar/vp-vertical-toolbar-tooltips';
import { ShapeWithText } from './components/vp-legacy-text';
import { ActionState, Dict, FontSize, FontStyle, HorizontalAlignment, LineTerminus, Point, ShapeType, VerticalAlignment, XAction, XActionProperty, XActionTargets, XActionTriggers, XActionType, XAnchor, XDocument, XDrawBehaviorCode, XImageShape, XLayer, XLineEndDecorationType, XLinkProps, XLinkType, XShape, XTextFormat } from './model';
import { ShapeChanges, UpdateShapeInfo } from './utils';
import { TextObject } from './utils/xmlParser';
import './visual-process-editor.css';
export { XAction, XActionProperty, XActionTargets, XActionTriggers, XActionType, XAnchor, XDocument, XDrawBehaviorCode, XImageShape, XLayer, XLineEndDecorationType, XLinkProps, XLinkType, XShape, XTextFormat, };
declare type VpVerticalToolbarButton = 'IMPORT_DOCUMENT' | 'EXPORT_DOCUMENT' | 'ACTIONS' | 'ADD_IMAGE' | 'ADD_ICON' | 'CREATE_SHAPE' | 'NONE';
export declare const isIE11: boolean;
export declare type VisualProcessConsumerAction = 
/** No arguments needed */
'FUNCTION_LINK_LOOKUP'
/** Args:
 * - code: the selected function code.
 */
 | 'FUNCTION_TRANSACTION_LINK_LOOKUP'
/** Args:
 * - code: the selected function code.
 * - transaction: the selected transaction code
 */
 | 'FUNCTION_LINK_VALIDATION'
/** No arguments needed */
 | 'REPORT_LINK_LOOKUP'
/** Args:
 * - code: the selected report code.
 */
 | 'REPORT_LINK_VALIDATION'
/** No arguments needed */
 | 'PROCESS_LINK_LOOKUP'
/** Args:
 * - code: the selected report code.
 */
 | 'PROCESS_LINK_VALIDATION'
/** No arguments needed */
 | 'BO_REPORT_LINK_LOOKUP'
/** Args:
 * - code: the selected business objects report code.
 */
 | 'BO_REPORT_LINK_VALIDATION'
/** No arguments needed */
 | 'QUERY_LINK_LOOKUP'
/** Args:
 * - code: the selected query report code.
 */
 | 'QUERY_LINK_VALIDATION'
/** No arguments needed */
 | 'STATISTICS_LINK_LOOKUP'
/** Args:
 * - code: the selected statistics report code.
 */
 | 'STATISTICS_LINK_VALIDATION'
/** No arguments needed */
 | 'INQUERY_LINK_LOOKUP'
/** Args:
 * - code: the selected inquery code.
 */
 | 'INQUERY_SCREEN_LINK_LOOKUP'
/** Args:
 * - code: the selected statistics report code.
 * - transaction: the selected inquery screen code.
 */
 | 'INQUERY_LINK_VALIDATION'
/** No arguments needed */
 | 'HELP_FIELD_LINK_LOOKUP'
/** Args:
 * - code: the selected field code.
 */
 | 'HELP_FIELD_LINK_VALIDATION'
/** No arguments needed */
 | 'HELP_FUNCTION_LINK_LOOKUP'
/** Args:
 * - code: the selected function code.
 */
 | 'HELP_FUNCTION_LINK_VALIDATION';
/** The expected result format of a consumer operation. Null value indicates that the user did not make a choice. */
export declare type ConsumerDataRequestResult = {
    value: string;
    label: string | null;
} | null;
export declare type GetDataFunction = (action: VisualProcessConsumerAction, args?: {
    code?: string;
    transaction?: string;
}) => Promise<ConsumerDataRequestResult>;
export interface VisualProcessEditorProps {
    /** The name of the visual process document, used in file exports */
    name: string;
    /** The visual process document which is edited by this editor. */
    document?: XDocument;
    /** Determines whether it should behave as a renderer or as an editor */
    canEdit: boolean;
    /** This callback notifies the consumer on whenever the user makes changes to the visual process edit */
    onChange: (document: XDocument) => void;
    /** Dictionary of icons that are available to pick. The dictionary key is the collection ID, the string content is  */
    icons: Dict<string[]>;
    /** Resolves the images to URLs from for Image shapes */
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
    /** Execute a command in the consumer for more data */
    getData: GetDataFunction;
    /** Triggered when a shape with a link is clicked in read-only mode. */
    onLinkClick: (xlinkProps: XLinkProps) => void;
    /** Timestamp  of when the process was loaded. Used to determine if the file was reloaded*/
    whenLoaded?: string;
    supportedLinkTypes?: XLinkType[];
    /** The current locale */
    language?: string;
    /**
     * The labels of the tooltips, can provide translation for each language or alternative tooltips and select the
     * language with the prop above
     */
    tooltipLabels?: TooltipLocalization;
}
export declare type ShapeBeingCreated = {
    type: 'ICON';
    collectionId: string;
    resourceId: string;
    iconX: number;
    iconY: number;
} | {
    type: 'IMAGE';
    imgSrc: string;
} | {
    type: ShapeType | 'NONE';
};
interface VisualProcessEditorState {
    /** The active toolbar's group */
    activeToolbarGroup: ToolbarGroup;
    /** Shape and layerId which is in the clipboard */
    clipboard?: {
        shape: XShape[];
        layerId: string;
    };
    /** Edit & Arrange menu position to be drawn */
    editArrangeMenuCoordinates: {
        x: number;
        y: number;
    };
    /** Whether Edit & Arrange Menu is open */
    isEditArrangeMenuOpen: boolean;
    /** Showing link details of all shapes */
    isLinkInfoDisplayed: boolean;
    /** Whether sub toolbar dialog of toolbar is open */
    isSubToolbarOpen: boolean;
    /** Action shape numbers displayed overlapping the shapes */
    areActionNumbersDisplayed: boolean;
    /** Trigger and targets of the rule currently selected in the action editor */
    selectedAction: XActionProperty;
    /** Whether the toolbar is enabled */
    isToolbarEnabled: boolean;
    /** An array of the Unique IDs of the currently selected shapes */
    selectedShapes: string[];
    /** The selected shape's unique ID */
    selectedShapeId: string;
    /** The selected layer's ID */
    selectedLayerId: string;
    /** The rectangle around all selected shapes */
    selectionRectangle?: Partial<XShape>;
    /** Currently selected button on the vertical toolbar  */
    selectedVerticalToolbarButton: VpVerticalToolbarButton;
    /** Shape that's being created or none */
    shapeBeingCreated: ShapeBeingCreated;
    /** Whether the selected shape is in text editing mode */
    isInTextEditingMode: boolean;
    /** In case of any issues during processing logic */
    errorMessage?: string;
    /** In case of any issues during processing logic */
    errorMessageType?: string;
    /** Maintain various shape action states */
    actionStates: Dict<ActionState>;
    /** Used to set the hide/show states for the initial load of the process */
    isInitialReadOnlyLoad: boolean;
    /** The visual process that is being edited */
    document?: XDocument;
    /** State of the Undo button */
    undoStatus: 'enabled' | 'disabled';
    /** State of the Redo button */
    redoStatus: 'enabled' | 'disabled';
    /** State of the Group button */
    showGroupButton: boolean;
    /** State of the Ungroup button */
    showUngroupButton: boolean;
    /** Copied shape(s) JSON */
    copiedData: string;
}
export declare class VisualProcessEditorComponent extends React.Component<VisualProcessEditorProps, VisualProcessEditorState> {
    private stageRef;
    private layerRef;
    private selectionTransformerRef;
    private floatingLayerRef;
    private readonly NO_COORDINATES;
    private readonly MAX_HISTORY_LEVEL;
    private vpeHistoryLevel;
    private vpeHistory;
    constructor(props: VisualProcessEditorProps);
    onToolbarClose: () => void;
    onToolbarLinkDialogSelected: () => void;
    rotateShape(shape: XShape, angle?: number): XShape;
    onToolbarRotate: () => void;
    onToolbarClone: () => void;
    onSingleOrGroupShapeOperation: (callback: (shape: XShape) => void, shapeFilter?: ((shape: XShape) => boolean) | undefined) => void;
    onSingleShapeOperation: (callback: (shape: XShape) => void) => void;
    onToolbarFill: (color: string) => void;
    onToolbarBorderColor: (color: string) => void;
    onToolbarBorderWidth: (lineWidth: number) => void;
    onToolbarBorderType: (lineType: string) => void;
    onLinkChange: (xlinkProps?: XLinkProps | undefined) => void;
    onLineEndChange: (terminus: LineTerminus, decorator: XLineEndDecorationType) => void;
    onMouseOverShape: (object?: (XShape & TextObject) | undefined) => () => void;
    onMouseLeaveShape: () => void;
    onLinkClick: (xlinkProps?: XLinkProps | undefined) => void;
    transformLegacyShape: (shape: ShapeWithText, textObjects?: TextObject[]) => void;
    transformLink: (textObject: TextObject) => void;
    getActionType: (actionId: string) => XActionType | undefined;
    updateActionStates: (document: XDocument, triggerActionId: string, actionType: XActionType, isInitialLoad?: boolean) => XDocument;
    onActionClick: (shape: XShape) => void;
    onFontSizeChange: (size: FontSize) => void;
    onFontStyleChange: (style: FontStyle) => void;
    onFontHorizontalAlignmentChange: (alignment: HorizontalAlignment) => void;
    onFontVerticalAlignmentChange: (alignment: VerticalAlignment) => void;
    onFontColorChange: (color: string) => void;
    onActiveToolbarGroupChange: (activeToolbarGroup: ToolbarGroup) => void;
    onLinkMouseEvent: (linksDisplayed: boolean) => () => void;
    setSubToolbarState: (subToolbarDialogDisplayed: boolean) => void;
    getStageCoordinates: (stage: import("konva/types/Stage").Stage) => {
        stage: import("konva/types/Stage").Stage;
        stageX: number;
        stageY: number;
        stageWidth: number;
        stageHeight: number;
        stageOffsetX: number;
        stageOffsetY: number;
        absoluteStageX: number;
        absoluteStageY: number;
    };
    onAddIcon: (collectionId: string, resourceId: string) => (event: React.MouseEvent<HTMLImageElement, MouseEvent>) => void;
    onAddIconButtonClick: () => void;
    sanitizeIndexes: (input: string) => string[];
    checkActions: (actions: XAction[], triggers: XActionTriggers[], targets: XActionTargets[]) => void;
    areIndexesInRange: (maxIndex: number, indexes: string[]) => number[];
    addActionTrigger: (shape: XShape, actionId: string) => void;
    addActionTarget: (shape: XShape, actionId: string) => void;
    moveUniqueIdToEndOfShape: (shape: XShape) => void;
    clearExistingActionAssignments: (shapes: XShape[]) => void;
    onSaveActions: (actions: XAction[], triggers: XActionTriggers[], targets: XActionTargets[]) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onCancelActionEditor: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onEditActionsButtonClick: () => void;
    onToggleActionNumbers: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onItemClickWrapper: (callback: (...args: unknown[]) => unknown) => (...cbArgs: unknown[]) => void;
    changeSelectedIcon: (icon: VpVerticalToolbarButton) => void;
    onMoveActionEditor: (vertical: boolean) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    getUniqueIdFromUiIndex: (uiIndex: string) => string;
    getUniqueIdsFromEditorValues: (editorValue: any) => string[];
    onEditActionFieldChange: (triggerValue: string, targetValue: string) => void;
    onEditActionFieldClick: (triggerValue: string, targetValue: string) => (event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void;
    onExportDocumentButtonClick: () => void;
    getAllShapesIds: () => string[];
    selectAllShapes: () => void;
    onCreateShape: (shapeBeingCreated: ShapeBeingCreated) => void;
    onCreateShapeButtonClick: () => void;
    switchElementBadgeClass: (validationFailed: boolean) => void;
    createImageShape(fileType: any, base64String: any): void;
    createError(text: string, type?: string): void;
    onImportDocumentButtonClick: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onImportImageButtonClick: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onSelectAllButtonClick: () => void;
    getVerticalToolbar: () => JSX.Element | null;
    onShapeRightClick: (selectedLayerId: string, selectedShapeId: string) => (evt: KonvaEventObject<PointerEvent>) => void;
    onStageRightClick: (evt: KonvaEventObject<PointerEvent>) => void;
    getToolbarWidth: (toolbarGroup: ToolbarGroup, shape?: XShape | undefined) => number;
    getTooltipLabels: () => TooltipMappedType;
    getToolbar: () => JSX.Element | null;
    setSelectionRectangle: () => void;
    onGroupShapes: () => void;
    onUngroupShapes: () => void;
    getUniqueIdsOfGroup: (shapeGroup: number) => string[];
    getGroupStatisticsOfSelection: (document: XDocument, uniqueIds: string[]) => {
        completeGroups: number[];
        orphansFound: boolean;
    };
    onShapeClick: (layerId: string, shape: XShape, isShiftClick?: boolean) => void;
    onShapeDoubleClick: (selectedLayerId: string, selectedShapeId: string, groupRef: React.RefObject<any>) => void;
    isShapeSelected: (shapeId: string) => boolean;
    isShapeHighlighted: (groupRef: React.RefObject<any>) => any;
    setTextEditingMode: (isInTextEditingMode: boolean) => void;
    onMouseMove: (_evt: KonvaEventObject<MouseEvent>) => void;
    getFloatingShape: () => JSX.Element | null;
    onStageClick: (e: KonvaEventObject<MouseEvent | TouchEvent>) => void;
    onShowToolbar: (isShow: boolean) => void;
    moveShape: (document: XDocument, layerId: string, index: number, changeX: number, changeY: number) => void;
    onMoveShapesViaArrowKey: (left: number, up: number, right: number, down: number) => void;
    onStageKeyDown: (e: React.KeyboardEvent<HTMLDivElement>) => void;
    setDeselectedState: () => void;
    onDeselect: (e: KonvaEventObject<MouseEvent | TouchEvent>) => void;
    clearRedos: (startIndex: number) => void;
    saveHistory: (document: XDocument) => void;
    saveHistoryAndChange: (document: XDocument) => void;
    resetHistory: (document?: XDocument | undefined) => void;
    checkShapeOutOfBounds: (shape: Partial<XShape>, isImport?: boolean | undefined) => void;
    rotatePoints: (anchors: Point[], angle: number) => Point[];
    getCornersOfBoundsBox: (points: Point[]) => Point[];
    getEllipseAnchors: (shape: Partial<XShape>) => Point[];
    calculateContentSize: (shapes: Partial<XShape>[]) => {
        width: number;
        height: number;
    };
    updateContentSize: (document: XDocument, shape?: Partial<XShape> | undefined, isImport?: boolean | undefined) => void;
    getShapeCount: (document: XDocument | undefined, layerId?: string | undefined) => number;
    saveShapeBase: (changes: UpdateShapeInfo) => XDocument | undefined;
    saveShape: (changes: UpdateShapeInfo) => void;
    saveShapeAndHistory: (changes: UpdateShapeInfo) => void;
    getDocument: () => XDocument | undefined;
    convertPastedShape: (clipboardData: any) => any;
    addNewActionsForCopiedObjects: (shapes: XShape[], document: XDocument) => void;
    parseClipboardData: (data: string, document: XDocument) => Promise<{
        result: any;
        type: string;
        messages: string;
    }>;
    deleteShapes: (indexes: number[], layer: XLayer) => void;
    getLayer: (document: XDocument, selectedLayerId?: string) => XLayer;
    addNewShape: (shapeData: any, document: XDocument, pasteCoordinates?: any) => void;
    getSelectedShapeIndexes: (layer: XLayer) => number[];
    getShapesToBeCopiedByLayerNumber: (document: XDocument, layerNumber: any) => XShape[];
    getAndDeleteShapesToBeCutByLayerNumber: (document: XDocument, layerNumber: any) => XShape[];
    getSelectedShapes: (document: XDocument) => XShape[];
    moveSelectedShapes: (document: XDocument, operation: string) => void;
    onArrangeMenuItemClick: (removeIndex: number, insertIndex: number, layer: XLayer) => void;
    isClipboardEnabled: () => Promise<boolean>;
    onEditArrangeMenuItemClick: (clickedItemType: VpEditArrangeMenuItemType, pasteCoordinates?: ShapeChanges | undefined, clipData?: string | undefined) => Promise<void>;
    getEditArrangeMenu: () => JSX.Element | undefined;
    onRemoveError: () => void;
    setUndoRedoStates: () => void;
    onUndoButtonClick: () => void;
    onRedoButtonClick: () => void;
    addShortcutKeyListener: (event: any) => void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate: (prevProps: VisualProcessEditorProps) => void;
    validateProcessSize(document?: XDocument): string | undefined;
    render(): JSX.Element;
}
/**
 * Vanilla JS class that wraps ReactJS in order to allow seamless integration to non-React projects, e.g. X3 Syracuse
 */
export declare class VisualProcessEditor {
    private readonly name;
    private readonly container;
    /** Determines whether it should behave as a renderer or as an editor */
    private readonly isReadOnly;
    /** This callback notifies the consumer on whenever the user makes changes to the visual process edit */
    private readonly onChange;
    /** Dictionary of icons that are available to pick. The dictionary key is the collection ID, the string content is  */
    private readonly icons;
    /** Resolves the images to URLs from for Image shapes */
    private readonly resolveImageUrl;
    /** Execute a command in the consumer for more data */
    private readonly getData;
    private readonly onLinkClick;
    private readonly supportedLinkTypes?;
    private readonly componentRef;
    constructor(name: string, container: HTMLDivElement, 
    /** Determines whether it should behave as a renderer or as an editor */
    isReadOnly: boolean, 
    /** This callback notifies the consumer on whenever the user makes changes to the visual process edit */
    onChange: (document?: XDocument) => void, 
    /** Dictionary of icons that are available to pick. The dictionary key is the collection ID, the string content is  */
    icons: Dict<string[]>, 
    /** Resolves the images to URLs from for Image shapes */
    resolveImageUrl: (collectionId: string, resourceId: string) => string, 
    /** Execute a command in the consumer for more data */
    getData: (action: VisualProcessConsumerAction, args?: {
        code: string;
        transaction?: string;
    }) => Promise<ConsumerDataRequestResult>, onLinkClick: (link: XLinkProps) => void, supportedLinkTypes?: XLinkType[] | undefined);
    private _onChange;
    render(document?: XDocument): Promise<unknown>;
    setName(name: string): void;
    setValue(document?: XDocument): void;
    getValue(): XDocument | undefined;
    dispose(): boolean;
}
//# sourceMappingURL=index.d.ts.map