import * as React from 'react';
import { ConsumerDataRequestResult, VisualProcessConsumerAction } from '..';
import { XDimension, XDocument, XLinkProps } from '../model';
import { Store } from '../state/context-provider';
import './consumer-mock.css';
import './ui-visual-process/player.css';
import './ui-visual-process/process.css';
export interface ConsumerMockState {
    /** Name of the file that is loaded in to the editor */
    visualProcessFileName: string;
    /** Tracks previously loaded documents for fast access */
    previousDocuments: string[];
    /** The visual process that is being edited */
    document?: XDocument;
    canEdit: boolean;
    whenLoaded?: string;
}
export declare class ConsumerMock extends React.Component<{}, ConsumerMockState> {
    static contextType: typeof Store;
    context: React.ContextType<typeof Store>;
    private legacyChartContainerRef;
    constructor(props: any);
    componentDidMount(): void;
    componentDidUpdate(): void;
    processSizeValidation(contentSize: XDimension, docDims: XDimension): "Missing document dimensions (docDims)" | "Missing content dimensions (contentSize)" | undefined;
    drawWithLegacyPlayer(): void;
    onFetchDocumentButtonClick: () => void;
    loadDocument: () => void;
    /** This function probably will be moved to Syracuse once we are ready to integrate */
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
    fetchVisualProcessDocument(): Promise<void>;
    onLoadPreviousDocument: (visualProcessFileName: string) => () => void;
    onFileNameChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onChange: (document: XDocument) => void;
    onCanEditChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onGetData: (action: VisualProcessConsumerAction, args?: {
        code: string;
        transaction?: string | undefined;
    } | undefined) => Promise<ConsumerDataRequestResult>;
    onLinkClick: (xlinkProps: XLinkProps) => void;
    getDimensions(contentSize?: XDimension, docDims?: XDimension): {
        contentWidth: number;
        contentHeight: number;
        docWidth: number;
        docHeight: number;
    };
    renderNewEditor(): JSX.Element;
    renderLegacyEngine(): JSX.Element;
    renderTestToolkit(): JSX.Element;
    renderDocumentSource(): JSX.Element;
    render(): JSX.Element;
}
//# sourceMappingURL=consumer-mock.d.ts.map