import * as React from 'react';
import { Point, XEllipseShape } from '../model';
import { VpShapeProps } from './common-props';
interface VpEllipseProps extends VpShapeProps<XEllipseShape> {
    isCircle?: boolean;
}
export declare class VpEllipse extends React.Component<VpEllipseProps> {
    private groupRef;
    componentDidMount(): void;
    componentDidUpdate(): void;
    attachGroupToTransformer: () => void;
    detachGroupFromTransformer: () => void;
    updateTransformer: () => void;
    onDragStart: (_: import("konva/types/Node").KonvaEventObject<DragEvent>) => void;
    dragEnd: () => void;
    transformEnd: () => void;
    getUpdatedShape: () => {
        shape: {
            xanchors: {
                type: null;
                x: number;
                y: number;
            }[];
            xcaptionPos: import("../model").XPosition | undefined;
            xcaptionSize: import("../model").XDimension | undefined;
            xtext: string | undefined;
        };
        layerId: string;
        shapeId: string;
    };
    getShapeInfo: () => {
        left: import("../model").XAnchor;
        top: import("../model").XAnchor;
        right: import("../model").XAnchor;
        bottom: import("../model").XAnchor;
        center: {
            x: number;
            y: number;
        };
        radiusX: number;
        radiusY: number;
        rotation: number;
        topLeft: Point;
    };
    renderVertices: ({ top, bottom, left, right, center, }: {
        top: Point;
        bottom: Point;
        left: Point;
        right: Point;
        center: Point;
    }) => JSX.Element;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=vp-ellipse.d.ts.map