import Konva from 'konva';
import { ShapeConfig } from 'konva/types/Shape';
import React from 'react';
import { XActionProperty, XDocument, XLinkProps, XShape } from '../model';
import { TextObject } from '../utils/xmlParser';
/** Interface for properties that are shared by all shapes */
export interface VpShapeProps<T extends XShape = XShape> {
    /** The shape's id. */
    id: string;
    /** The id of the layer the shape belongs to. */
    layerId: string;
    /** The shared transformer node */
    transformerRef?: React.RefObject<any>;
    /** The shape's rendering data. */
    shape: T;
    /** Determine whether the user can edit or it is just read-only, this property is provided by the consumer */
    canEdit: boolean;
    /** This property should come from the state */
    isSelected: boolean;
    /** Is the shape part of a multi-shape selection or group? */
    isHighlighted: (groupRef: React.RefObject<any>) => boolean;
    /** This callback is called whenever a shape's group is touched/clicked */
    onClick: (evt: Konva.KonvaEventObject<MouseEvent>) => void;
    onDoubleClick: (evt: Konva.KonvaEventObject<MouseEvent>, groupRef: React.RefObject<any>) => void;
    onTap: (evt: Konva.KonvaEventObject<Event>, groupRef: React.RefObject<any>) => void;
    /** This callback is run whenever a shape is changed (e.g. translated, rotated, scaled). It does not save history.*/
    saveShape: (props: Partial<ShapeConfig>) => void;
    /** Same as saveShape plus it saves the update document to history */
    saveShapeAndHistory: (props: Partial<ShapeConfig>) => void;
    /** This property has all the data related to text for the shapes */
    textObjects: TextObject[] | null;
    /** Opens text area */
    editingText: boolean;
    /** Link content information displayed overlapping the shape */
    isLinkInfoDisplayed: boolean;
    /** Action shape numbers displayed overlapping the shapes */
    areActionNumbersDisplayed: boolean;
    document: XDocument;
    /** Trigger and targets of the rule currently selected in the action editor */
    selectedAction: XActionProperty;
    /** Update text coming from textarea */
    onEditedText: (text: string) => void;
    /** Triggered when the mouse gets over a shape */
    onMouseEnterShape: (object?: XShape | TextObject) => () => void;
    /** Triggered when the mouse leaves a shape */
    onMouseLeaveShape: () => void;
    /** Triggered in read-only mode when the user clicks a shape with a link */
    onLinkClick: (xlink?: XLinkProps) => void;
    /** Triggered when user right clicks on a shape */
    onRightClick: (evt: Konva.KonvaEventObject<PointerEvent>) => void;
    rotation: number;
}
//# sourceMappingURL=common-props.d.ts.map