import type { IconType } from 'carbon-react/lib/components/icon';
import type { DashboardValueOrCallback, Locale, StringLiterals } from '../../../types';
export type EventListener = (i: string | number) => void;
export type ValueFormatType = 'number' | 'string';
export type RenderAsType = 'link' | 'pill' | 'normal' | 'icon' | null | undefined;
export interface WidgetCollectionItemDisplayOptions {
    colorVariant?: DashboardValueOrCallback<'neutral' | 'negative' | 'positive' | 'warning' | undefined>;
    tooltipText?: DashboardValueOrCallback<string | undefined>;
    columnWidth?: number;
}
export interface WidgetColumnDefinitionOptions {
    title: string;
    onClick?: EventListener;
    displayOptions?: WidgetCollectionItemDisplayOptions;
    renderedAs?: RenderAsType;
    valueFormat?: ValueFormatType;
    decimalDigits?: number;
}
export interface WidgetCollectionItemDefinition {
    title: WidgetColumnDefinitionOptions;
    titleRight?: WidgetColumnDefinitionOptions;
    line2?: WidgetColumnDefinitionOptions;
    line2Right?: WidgetColumnDefinitionOptions;
    line3?: WidgetColumnDefinitionOptions;
    line3Right?: WidgetColumnDefinitionOptions;
    image?: WidgetColumnDefinitionOptions;
    icon?: WidgetColumnDefinitionOptions;
    longContent?: WidgetColumnDefinitionOptions;
    [key: string]: WidgetColumnDefinitionOptions | undefined;
}
export interface WidgetCollectionItemAction {
    icon?: IconType;
    label: string;
    onClick: EventListener;
    isDisabled?: DashboardValueOrCallback<boolean | undefined>;
    isHidden?: DashboardValueOrCallback<boolean | undefined>;
}
export interface WidgetCollectionItem {
    i: string | number;
    title: string | number;
    titleRight?: string | number;
    line2?: string | number;
    line2Right?: string | number;
    line3?: string | number;
    line3Right?: string | number;
    image?: string;
    icon?: IconType;
    longContent?: string;
    [key: string]: string | number | undefined;
}
export declare enum WidgetCollectionItemStatus {
    LOADING = 0,
    LOADED = 1,
    FAILED = 2,
    STALE = 3
}
export interface WidgetCollectionRendererProps {
    canSelect?: boolean;
    data: WidgetCollectionItem[];
    hasIcon: boolean;
    hasImage: boolean;
    height?: number;
    loadMoreRows?: (args: {
        startIndex: number;
        stopIndex: number;
        pageCount: number;
        pageSize: number;
        after?: WidgetCollectionItem;
        first: number;
    }) => Promise<WidgetCollectionItem[]>;
    locale: Locale;
    onSelectAllChange: (newState: boolean) => void;
    onSelectionChange: (i: string | number) => void;
    rowDefinition: WidgetCollectionItemDefinition;
    rowActions?: WidgetCollectionItemAction[];
    selectedRows: (string | number)[];
    setHasAllDataLoaded: (allDataLoaded: boolean) => void;
    stringLiterals: StringLiterals;
}
export interface WidgetCollectionItemRendererProps {
    canSelect?: boolean;
    hasIcon: boolean;
    hasImage: boolean;
    index: number;
    isRowExpanded: boolean;
    isSelected?: boolean;
    locale: Locale;
    onRowExpandToggle: (index: number, isExpanded: boolean) => void;
    onRowResized: (index: number, height: number) => void;
    onSelectionChange: (i: string | number) => void;
    row: WidgetCollectionItem;
    rowActions?: WidgetCollectionItemAction[];
    rowDefinition: WidgetCollectionItemDefinition;
    stringLiterals: StringLiterals;
    style?: React.CSSProperties & {
        columnWidth?: number;
    };
}
export interface WidgetCollectionItemValueComponentProps {
    i: string | number;
    value: any;
    locale: Locale;
    definition?: WidgetColumnDefinitionOptions;
    isLeftPosition?: boolean;
    isInTable?: boolean;
    isBold?: boolean;
    propertyName: string;
}
