import type { Dict, Locale, StringLiterals, CallToActionDefinition } from '../../types';
import type { WidgetCollectionItem, WidgetCollectionItemAction, WidgetCollectionItemDefinition, WidgetCollectionRendererProps } from '../shared/Collection/types';
import type { CollectionDateFilter, PeriodDetails } from '../shared/DateFilter/types';
import type { FilterLineFilterConfig } from '../shared/FilterLine';
export interface TableWidgetProps {
    data?: WidgetCollectionItem[];
    rowDefinition: WidgetCollectionItemDefinition;
    rowActions?: WidgetCollectionItemAction[];
    locale: Locale;
    mode?: 'card' | 'table';
    canChangeViewMode?: boolean;
    selectedViewMode?: 'card' | 'table';
    canSelect?: boolean;
    title?: string;
    filterMenuType?: FilterLineFilterConfig['representation'];
    filterMenu?: FilterLineFilterConfig['options'];
    emptyStateMessage?: string;
    onSelectionChanged?: (selected: (string | number)[]) => void;
    onFilterMenuChanged?: FilterLineFilterConfig['onChange'];
    onRepresentationModeChanged?: (mode: 'card' | 'table') => void;
    stringLiterals: StringLiterals;
    callToActions?: Dict<CallToActionDefinition>;
    loadMoreRows?: WidgetCollectionRendererProps['loadMoreRows'];
    pageSize?: number;
    dateFilter?: CollectionDateFilter;
    selectedPeriod?: PeriodDetails | null;
    onDateFilterChanged?: (selectedPeriod: PeriodDetails) => void;
    totalCount?: number;
    iconSrc?: string;
}
