import type { Store } from 'redux';
import type { DashboardAction } from '../../redux/actions/action-types';
import type { State } from '../../redux/reducers/reducer';
import type { AbstractWidget, LayoutDefinition, Locale, StringLiterals } from '../../types';
import './DragDropCanvas.scss';
export interface DragDropCanvasProps {
    locale: Locale;
    layout: LayoutDefinition;
    widgets: AbstractWidget[];
    /** Renders the dashboard in editing mode */
    isEditMode?: boolean;
    /** Renders anchor elements on the side */
    areAnchorsDisplayed?: boolean;
    scrollTop?: number;
    highlightAnchorsFullSection?: boolean;
    storeStateLayout?: LayoutDefinition;
    storeStateWidgets?: AbstractWidget[];
    store?: Store<State, DashboardAction>;
    /** If set, the header with the tabs and the dashboard settings is not rendered */
    isHeaderHidden?: boolean;
    onSavedData?: (newLayout: {
        layout: LayoutDefinition;
        widgets: AbstractWidget[];
    }) => void;
    /** This callback is triggered any time the widget change */
    onDataChange?: (newLayout: {
        layout: LayoutDefinition;
        widgets: AbstractWidget[];
    }) => void;
    stringLiterals: Partial<StringLiterals>;
    /** Triggered when the duplicate drop down header action is clicked by the user */
    onDuplicateAction?: () => void;
    /** Triggered when the delete header drop down action is clicked by the user */
    onDeleteAction?: () => void;
    /** Triggered when the share header drop down action is clicked by the user */
    onShareAction?: () => void;
    /** Triggered when the edit header drop down action is clicked by the user. If not set, it changes to editor mode. */
    onEditAction?: () => void;
    newItem?: Partial<AbstractWidget>;
}
/** ## Flexible Masonry drag'n'drop canvas
 *
 * This component uses [React Grid Layout](https://github.com/react-grid-layout/react-grid-layout) as an alternative to [Gridstack](https://gridstackjs.com/).
 *
 * This component is meant to be used as full-available width.
 * It uses a responsive/elastic grid of 12 virtual columns.
 *
 * Each child container of the RGL component is initially positionable (x, y), has initial size (w, h), and other get/set properties (see [React Grid Layout Github repo](https://github.com/react-grid-layout/react-grid-layout) for more API details such as drag'n'drop, resize, etc...).
 * Use **WidgetSleketon** inside child containers of the RGL component.
 * Rendered graphs and KPI are the "children" of **WidgetSkeleton**, so we should virtually be able to display anything as a content.
 *
 * A widget can be dragged by its title.
 * Widget that are resizable can be resized by using bottom-right corner (cursor will change on hover).
 *
 * props.layout is the dataset to handle shapes, positions, and other properties.
 *
 * props.layout.i is different from props.layout.id .
 * props.layout.i refers to the "key" attribute used by React Grid Layout to identify each container. This is mandatory, and each key must be unique.
 * props.layout.id refers to the ID attribute of an HTML tag. Here it is used to define a target for the anchors links. This is optional, and each id must be unique.
 *
 * props.editMode is the starter point for the template edit mode for the user. Actually work in progress through CSS, but can be improved with specific state. FIXME PIFAL: to be completed.
 *
 * props.displayAnchors split the screen in 2 columns: main content on the left (12 columns grid), auto-generated anchors sticky on the right.
 *
 * props.highlightAnchorsFullSection defines the behavior of the anchors highlights: false (default) = once at a time | true = multiple anchors can be highlighted if they appear on screen.
 *
 * @todo  Bind dynamic properties, combine layout dataset with building calls of **WidgetSkeleton**.
 * @todo  Check if **WidgetSkeleton** children can be filled through layout dataset, or through the RGL component props.
 * @todo  Build case when widgets are just a simple list of available boxes to drag and drop inside the canvas.
 * @todo  FIXME: overlap of options menu depending of z-index of RGL elements.
 * @todo  Refine styles + check z-index of options menu + resize handler.
 * @todo  Define minimal sizes of widgets.
 * @todo  Check naming rules.
 * @todo  Optimize and split this long component into smaller parts.
 * @todo  Add smooth scroll animations when clicking on anchor link.
 */
export default function DragDropCanvas(props: DragDropCanvasProps): JSX.Element;
