import type { Dict, StringLiterals } from '../../types';
export type ContactType = 'contact' | 'site';
export type ContactCardProps = {
    addressFunction?: string;
    address?: string;
    contactEmailAddress?: string;
    contactImage?: string;
    contactName?: string;
    contactPhoneNumber?: string;
    contactPosition?: string;
    contactRole?: string;
    contacts: Dict<string>;
    iconSrc?: string;
    notes?: {
        _id: string;
        text: string;
        timestamp: Date;
    }[];
    numberOfAddresses: number;
    numberOfContacts: number;
    onContactTypeSwitchChanged?: (type: ContactType) => void;
    onContactAdd?: (type: ContactType) => void;
    onNoteAdded?: (text: string) => void;
    onNoteDeleted?: (_id: string) => void;
    onNoteEdited?: (_id: string, text: string) => void;
    onSelectedContactChanged?: (id: string | null) => void;
    stringLiterals: StringLiterals;
};
