import type { AbstractWidget, Locale, StringLiterals } from '../../types';
import './WidgetSkeleton.scss';
export interface WidgetSkeletonProps {
    locale: Locale;
    stringLiterals: StringLiterals;
    widget: AbstractWidget;
    isEditMode: boolean;
    onWidgetRemoved: (i: string) => void;
}
/** ## Widget re-usable skeleton container
 *
 * This is a UI-normalized container to be used as a widget with a header, a title, and some options.
 * This skeleton model is meant to be used inside the drag'n'drop dashboard layout/canvas.
 *
 * Props from **ToggleActionsMenu** are inherited.
 * **props.align** is not used: since the position of the menu is set to right, and then dropdown aligns from right.
 * The content (through **props.children**) is meant to be filled with pure rendered KPI.
 *
 * props.isSeparator enables an alternative simplified version of the widget, to be used as a separator.
 * So, it just has a title.
 * Same stylistic result can be achieved if the regular widget template is used 'under' a container with class name "db-section-separator".
 * In that second case, widget will be built as a regular one, but unnecessary parts will be hidden by CSS.
 *
 * @todo  Build footer area.
 * @todo  Build case when widget content is empty.
 * @todo  Build case when widget is inside of available-widgets list (+ set category).
 */
export default function WidgetSkeleton({ locale, stringLiterals, widget, isEditMode, onWidgetRemoved, }: WidgetSkeletonProps): JSX.Element;
