import type { IconType } from 'carbon-react/lib/components/icon/icon-type';
import './TileIndicator.scss';
import type { Locale, Currency } from '../../types';
export interface TileIndicatorProps {
    value?: string;
    title?: string;
    color: string;
    icon: IconType;
    valueType?: ValueType;
    locale?: Locale;
    currencyIndicator?: CurrencyIndicator;
    onClick?: () => void;
}
export type ValueType = 'currency' | 'text';
export type CurrencyIndicator = {
    value?: number;
    currencyCode?: Currency;
};
export default function TileIndicator({ value, title, color, icon, valueType, locale, currencyIndicator, onClick, }: TileIndicatorProps): JSX.Element;
