import type { Locale, StringLiterals, Currency } from '../../types';
import type { SvgIconProps } from '../SvgIcon/types';
import type { CurrencyIndicator } from './SimpleCurrencyIndicator';
import type { NumberIndicator } from './SimpleNumberIndicator';
import type { TextIndicator } from './SimpleTextIndicator';
import './SimpleIndicator.scss';
export type SimpleIndicatorProps = {
    currencyCode?: Currency;
    description?: string;
    differenceValue?: number;
    icon?: SvgIconProps;
    locale?: Locale;
    mainIndicator: MainIndicator;
    stringLiterals: StringLiterals;
    title?: string;
    type?: IndicatorType;
};
export type IndicatorType = 'currency' | 'number' | 'text';
export type MainIndicator = CurrencyIndicator | NumberIndicator | TextIndicator;
export default function SimpleIndicator(props: SimpleIndicatorProps): JSX.Element;
