Static storybook is available at https://redesigned-spoon-4kqnpje.pages.github.io/

# BMS - Dashboard

Initial builds by [Max Dreisbusch](mailto:max.dreisbusch@sage.com), [Pierre Falconetti](mailto:pierre.falconetti@sage.com), [Daniel Bautista Hernandez](mailto:daniel.bautista@sage.com), and [Cristian Lora Duarte](mailto:cristian.lora@sage.com).

Designs by [Husam Abuwarda](mailto:husam.abuwarda@sage.com), [Isaac Blanco Peco](mailto:isaac.blanco@sage.com), and [David Bouffort](mailto:david.bouffort@sage.com).

## v 0.6.3

This project contains the React components and basic widgets and mechanics used for a dashboard vue with indicators inside a Sage BMS app.

A **Dashboard** is a single vue, among multiple separate "views" of an application, agregating miscellaneous data from the parent API, and rendering these data in a compact way so they can all be reachable by the user with one glance. Since a Dashboard has a need for catching attention and quick-understanding, most of the data will be rendered in a data-visualization way (when possible), and will give the ability to perform quick actions. Eventually, these data will be packaged inside "widgets" that will have common and specific capabilities such as add from list, remove, change position, resize, group, change rendering of data, etc...

This project is built around Sage standards inherited from Carbon projects and DLS principles. Graphical rendering of the data (inside the widgets) will be handled by other components built around Recharts, while 

---

## Key principles

1. Being able to render KPIs in a graphical way (if needed)
1. Stack up several KPI widgets in a same view that would be called **the dashboard**
1. Let every user customize their own dasboard according to their needs
1. Start from a BMS-UX-France-Spain-Germany consensus
1. Build something modular and scalable, for Sage and Carbon
1. Share this with other Sage teams, whatever the silos, whatever the products, whatever the countries, and make them contribute.

---

## How to use this

This is a standalone Storybook package with a structure that can be re-used inside the Sage BMS project. This means that inside this package, necessary components for the "dashboard template" and the "widget templates" are built and tested independently of the parent project thanks to Storybook.

### Starter

1. Be sure you have NPM/Yarn + Git + a code editor, on your computer
1. Download or clone (recommended) this project - please consider checking for updates regularly
1. `npm install` (or you can use Yarn)
1. `npm run storybook` (or you can use Yarn)

### Other builds

Also run `npm run` for a list of other available launch options (build, test, ...).

### Components of the BMS Dashboard

#### Page components

* **ActionItem**: reusable action item as SPAN, A or BUTTON
* **WidgetSkeleton**: reusable container calling for widget content and options
* **DragDropCanvas**: template using widget containers on a [React Grid Layout](https://github.com/react-grid-layout/react-grid-layout), with automated anchors links, with edit mode

#### Widgets components

* **SimpleIndicator**: simple figure with tendency and text
* **StatusReport**: multi-level bar graph with legend
* **HorizontalBar**: horizontal graph/scale with proportional colored areas
* **ProgressTracker**: circle gauge indicator with figure
* **TableTreeMap**: list-type data to be displayed as a table of figures or as a tree map with areas

#### For tests purposes and/or reference only

* **TestComponent**

**Components documentation is available through Storybook when you run `npm run storybook`.**

### Component files

Components are defined in **src/components/**.

* **.tsx**: React component in TypeScript format
* **.stories.tsx**: Storybook story in TypeScript format
* **.test.tsx**: Jest test file in TypeScript format
* **.module.scss**: component stylesheet in raw SASS format (compilation is made on the fly by npm builds)
* **.css**: starter component stylesheet (deprecated) to be converted into SASS

### Assets

Though each component has its own stylesheet, you will find in **src/assets/** some of the assets necessary for shaping the UI. These assets are inherited or extracted from Carbon and the DLS. **If you integer the React components of this project into a bigger Sage project, make sure to use the latest Carbon components.**

---

## What this is made of

### Core dependencies

* [React](https://reactjs.org/), for building UI components compatible with Sage Carbon
* [Storybook](https://storybook.js.org/), for bundling and documenting the React components
* [TypeScript](https://www.typescriptlang.org/), for writing, because it is becoming a Sage project standards
* [Rollup](https://www.rollupjs.org/guide/en/), for compiling
* [Jest](https://jestjs.io/), for testing
* [Recharts](https://recharts.org/en-US/), a graphical library for drawing and rendering graphs
* [React Grid Layout](https://github.com/react-grid-layout/react-grid-layout), for interacting with widgets, on a [Masonry]() grid, as an alternative to [Gridstack](https://gridstackjs.com/) and [Packery](https://packery.metafizzy.co/)
* [React Visibility Sensor](https://github.com/joshwnj/react-visibility-sensor), for status feedback between sections and anchors pointing to them
* [Redux](https://react-redux.js.org/), for fine-tuned events management, and complex interactions between layers and components 

See the **package.json** file for other dependencies.

### To be used with

Dashboard does not make much sense without widgets. And widgets are just empty containers if they don't display proper data in the proper way.

This project is now also inheriting the content 2 other repositories:
* https://github.com/Sage/BMS-Dashboard-widgets : would gather all the behaviours for widgets. UPDATE: Since the dashboard template is very intricated with the widgets containers capabilities, and since the team capacity is being reduced on some part of the project, then widgets and template are actually being developped inside this https://github.com/Sage/BMS-Dashboard-template repository.
* https://github.com/Sage/BMS-Dashboard-graphs : repository grouping all the widget contents (graphs and data to be displayed inside the widget containers) being developped around [Recharts](https://recharts.org/en-US).

---

## How to contribute

### Branches

* **main**: last stable update
* **dev**: things that are being developed and that will be pushed to main when stable
* **react-typescript-template**: initial build by Max, to be kept as a reference for scaffolding new components
* **javascript-dev**: standalone JS build as a sandbox for testing features.
* **features/...**: works in progress

### Please help

* get components, integrate them and test them
* review code
* complete test files
* contribute to components
* find a naming system suitable for Sage Carbon AND Storybook Docs
* complete documentation and Storybook stories
* put all this into Carbon context in order to use native Carbon components

---

## History and references (for the record)

1. This project started as a **sub-project of the Sage BMS web/SaaS app**, with a joined task force made of French, German and Spanish developers and UX designers.
1. A [technical benchmark](https://teams.microsoft.com/l/file/9747085B-E142-46BD-8882-C83D95D798FD?tenantId=3e32dd7c-41f6-492d-a1a3-c58eb02cf4f8&fileType=pptx&objectUrl=https%3A%2F%2Fsage365.sharepoint.com%2Fsites%2FBMSDashboard903%2FShared%20Documents%2FGeneral%2FSage_Dashboard_benchmark.v1.2.pptx&baseUrl=https%3A%2F%2Fsage365.sharepoint.com%2Fsites%2FBMSDashboard903&serviceName=teams&threadId=19:56d04381a20f45c19a45ed54a19798ce@thread.tacv2&groupId=494859ca-249c-43b8-88b5-fa3aacef8a9a) was made in order to determine what approach would be the most relevant to achieve a dashboard, and with which technologies.
1. The solution adopted by all was to split the dashboard into **several layers** in order to share responsabilities:
    1. Dynamically rendered graph/chart, as vector graphics, with [Recharts](https://recharts.org/en-US) (best compromise between features and flexibility)
    1. Normalized widget container with properties and UX methods (add, remove, data-type, …)​
    1. Flexible drag’n’drop-able area (eventually)​
    1. Snap-able grid system
    1. ​(API to drive front renderings and to bind UX to the data (static: frontend queries data, or dynamic: backend pushes updates)​: depends on each country)
    1. (KPI data source: depends on each country)
1. Dashboard design was made: https://marvelapp.com/project/5232497
1. Widgets designs were made: https://marvelapp.com/project/5476365
1. Code was split into deveral repos, according to "layers" logic
1. Code is reunited in this repository, according to "components" logic
1. We added CI-CD pipeline with packages and NPM
1. We added Redux to plug more interactions between components and keep consistency in the whole dashboard experience - this may cause some data change seem static in Storybook, but it is only because Redux is meant to take priority over Storybook for data, events and states management inside the Dashboard app.
