import { AsyncContext, CallbackAsyncContext } from "../business/asyncContext";
/***
 * To be used by xtrem to request async context or cancel them
 */
export declare abstract class AsyncContextXtremRepository {
    /***
     * Create an async context
     * @param context
     */
    abstract createAsyncContext(context: AsyncContext): Promise<string>;
    abstract getAsyncContext(contextId: string): Promise<AsyncContext | undefined>;
    abstract deleteAsyncContext(contextId: string): Promise<void>;
    abstract createThirdPartyCallbackAsyncContext(callbackContext: CallbackAsyncContext): Promise<{
        callbackUrl: string;
        id: string;
    }>;
}
