"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASYNC_CONTEXT_CONST = exports.AsyncContextBuilder = exports.AsyncContextInfraRepository = exports.InfraAsyncContextProvider = exports.XtremAsyncContextProvider = exports.AsyncContextXtremRepository = exports.LocalDeveloperAsyncContextProvider = void 0;
const localDeveloperAsyncContextProvider_1 = require("./repository/impl/localDeveloperAsyncContextProvider");
Object.defineProperty(exports, "LocalDeveloperAsyncContextProvider", { enumerable: true, get: function () { return localDeveloperAsyncContextProvider_1.LocalDeveloperAsyncContextProvider; } });
const asyncContextXtremRepository_1 = require("./repository/asyncContextXtremRepository");
Object.defineProperty(exports, "AsyncContextXtremRepository", { enumerable: true, get: function () { return asyncContextXtremRepository_1.AsyncContextXtremRepository; } });
const xtremAsyncContextProvider_1 = __importDefault(require("./repository/impl/xtremAsyncContextProvider"));
exports.XtremAsyncContextProvider = xtremAsyncContextProvider_1.default;
const infraAsyncContextProvider_1 = __importDefault(require("./repository/impl/infraAsyncContextProvider"));
exports.InfraAsyncContextProvider = infraAsyncContextProvider_1.default;
const asyncContextInfraRepository_1 = require("./repository/asyncContextInfraRepository");
Object.defineProperty(exports, "AsyncContextInfraRepository", { enumerable: true, get: function () { return asyncContextInfraRepository_1.AsyncContextInfraRepository; } });
const xtrem_deployment_1 = require("@sage/xtrem-deployment");
Object.defineProperty(exports, "ASYNC_CONTEXT_CONST", { enumerable: true, get: function () { return xtrem_deployment_1.ASYNC_CONTEXT_CONST; } });
const AsyncContextBuilder = {
    /***
     * Return a contextId provider to be used in cloud xtrem context.
     * @param config options for the provider like clusterId and dynamoDB table name
     * @param thirdPartyConfig options for the callback async context provider, used by service fabric to generate async context and callback url
     */
    getCloudImplementation: (config, thirdPartyConfig) => {
        return new xtremAsyncContextProvider_1.default(config, thirdPartyConfig);
    },
    /***
     * Return a local intact controlId provider to be used on developer machine.
     * Note : the intacct response will never be injected in the sqs queue if using this implementation.
     */
    getLocalDevImplementation: (thirdPartyConfig) => {
        return new localDeveloperAsyncContextProvider_1.LocalDeveloperAsyncContextProvider(thirdPartyConfig);
    },
    /***
     * Return a contextId provider to be used by infra, with extra method not needed by xtrem
     * @param config
     */
    getInfrastructureRegistry: (config) => {
        return new infraAsyncContextProvider_1.default(config);
    },
};
exports.AsyncContextBuilder = AsyncContextBuilder;
//# sourceMappingURL=index.js.map