import { LocalDeveloperAsyncContextProvider } from "./repository/impl/localDeveloperAsyncContextProvider";
import { DynamoDBAsyncContextIdProviderConfig } from "./repository/impl/dynamoDBAsyncContextRepository";
import { AsyncContextXtremRepository } from "./repository/asyncContextXtremRepository";
import XtremAsyncContextProvider from "./repository/impl/xtremAsyncContextProvider";
import InfraAsyncContextProvider from "./repository/impl/infraAsyncContextProvider";
import { AsyncContextInfraRepository } from "./repository/asyncContextInfraRepository";
import { AsyncContext } from "./business/asyncContext";
import { ASYNC_CONTEXT_KINDS, ASYNC_CONTEXT_CONST } from "@sage/xtrem-deployment";
import { ThirdPartyAsyncContextIdProviderConfig } from "./business/callbackAsyncContextIdProviderConfig";
declare const AsyncContextBuilder: {
    /***
     * Return a contextId provider to be used in cloud xtrem context.
     * @param config options for the provider like clusterId and dynamoDB table name
     * @param thirdPartyConfig options for the callback async context provider, used by service fabric to generate async context and callback url
     */
    getCloudImplementation: (config: DynamoDBAsyncContextIdProviderConfig, thirdPartyConfig?: ThirdPartyAsyncContextIdProviderConfig) => AsyncContextXtremRepository;
    /***
     * Return a local intact controlId provider to be used on developer machine.
     * Note : the intacct response will never be injected in the sqs queue if using this implementation.
     */
    getLocalDevImplementation: (thirdPartyConfig?: ThirdPartyAsyncContextIdProviderConfig) => LocalDeveloperAsyncContextProvider;
    /***
     * Return a contextId provider to be used by infra, with extra method not needed by xtrem
     * @param config
     */
    getInfrastructureRegistry: (config: DynamoDBAsyncContextIdProviderConfig) => AsyncContextInfraRepository;
};
export { LocalDeveloperAsyncContextProvider, DynamoDBAsyncContextIdProviderConfig, AsyncContextXtremRepository, XtremAsyncContextProvider, InfraAsyncContextProvider, AsyncContextInfraRepository, AsyncContextBuilder, AsyncContext, ASYNC_CONTEXT_KINDS, ASYNC_CONTEXT_CONST };
