import { Direction, Key, RefObject, Collection } from "@react-types/shared";
import { LayoutInfo, Size, Rect, Layout, ReusableView } from "@react-stately/virtualizer";
import React, { CSSProperties, HTMLAttributes, ReactNode, RefObject as _RefObject1, ReactElement } from "react";
export type RTLOffsetType = 'negative' | 'positive-descending' | 'positive-ascending';
export function getRTLOffsetType(recalculate?: boolean): RTLOffsetType;
export function getScrollLeft(node: Element, direction: Direction): number;
export function setScrollLeft(node: Element, direction: Direction, scrollLeft: number): void;
interface IVirtualizer {
    updateItemSize(key: Key, size: Size): void;
}
export interface VirtualizerItemOptions {
    layoutInfo: LayoutInfo;
    virtualizer: IVirtualizer;
    ref: RefObject<HTMLElement | null>;
}
export function useVirtualizerItem(options: VirtualizerItemOptions): {
    updateSize: () => void;
};
interface ScrollViewProps extends HTMLAttributes<HTMLElement> {
    contentSize: Size;
    onVisibleRectChange: (rect: Rect) => void;
    children?: ReactNode;
    innerStyle?: CSSProperties;
    onScrollStart?: () => void;
    onScrollEnd?: () => void;
    scrollDirection?: 'horizontal' | 'vertical' | 'both';
}
export const ScrollView: React.ForwardRefExoticComponent<ScrollViewProps & React.RefAttributes<HTMLDivElement>>;
export function useScrollView(props: ScrollViewProps, ref: _RefObject1<HTMLElement | null>): {
    scrollViewProps: {
        style: React.CSSProperties;
        children?: ReactNode;
        defaultChecked?: boolean | undefined;
        defaultValue?: string | number | readonly string[] | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        autoFocus?: boolean | undefined;
        className?: string | undefined;
        contentEditable?: (boolean | "false" | "true") | "inherit" | "plaintext-only" | undefined;
        contextMenu?: string | undefined;
        dir?: string | undefined;
        draggable?: (boolean | "false" | "true") | undefined;
        hidden?: boolean | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        nonce?: string | undefined;
        slot?: string | undefined;
        spellCheck?: (boolean | "false" | "true") | undefined;
        tabIndex?: number | undefined;
        title?: string | undefined;
        translate?: "yes" | "no" | undefined;
        radioGroup?: string | undefined;
        role?: React.AriaRole | undefined;
        about?: string | undefined;
        content?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        rel?: string | undefined;
        resource?: string | undefined;
        rev?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        color?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        popover?: "" | "auto" | "manual" | undefined;
        popoverTargetAction?: "toggle" | "show" | "hide" | undefined;
        popoverTarget?: string | undefined;
        inert?: boolean | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined;
        is?: string | undefined;
        "aria-activedescendant"?: string | undefined;
        "aria-atomic"?: (boolean | "false" | "true") | undefined;
        "aria-autocomplete"?: "none" | "inline" | "list" | "both" | undefined;
        "aria-braillelabel"?: string | undefined;
        "aria-brailleroledescription"?: string | undefined;
        "aria-busy"?: (boolean | "false" | "true") | undefined;
        "aria-checked"?: boolean | "false" | "mixed" | "true" | undefined;
        "aria-colcount"?: number | undefined;
        "aria-colindex"?: number | undefined;
        "aria-colindextext"?: string | undefined;
        "aria-colspan"?: number | undefined;
        "aria-controls"?: string | undefined;
        "aria-current"?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined;
        "aria-describedby"?: string | undefined;
        "aria-description"?: string | undefined;
        "aria-details"?: string | undefined;
        "aria-disabled"?: (boolean | "false" | "true") | undefined;
        "aria-dropeffect"?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined;
        "aria-errormessage"?: string | undefined;
        "aria-expanded"?: (boolean | "false" | "true") | undefined;
        "aria-flowto"?: string | undefined;
        "aria-grabbed"?: (boolean | "false" | "true") | undefined;
        "aria-haspopup"?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
        "aria-hidden"?: (boolean | "false" | "true") | undefined;
        "aria-invalid"?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
        "aria-keyshortcuts"?: string | undefined;
        "aria-label"?: string | undefined;
        "aria-labelledby"?: string | undefined;
        "aria-level"?: number | undefined;
        "aria-live"?: "off" | "assertive" | "polite" | undefined;
        "aria-modal"?: (boolean | "false" | "true") | undefined;
        "aria-multiline"?: (boolean | "false" | "true") | undefined;
        "aria-multiselectable"?: (boolean | "false" | "true") | undefined;
        "aria-orientation"?: "horizontal" | "vertical" | undefined;
        "aria-owns"?: string | undefined;
        "aria-placeholder"?: string | undefined;
        "aria-posinset"?: number | undefined;
        "aria-pressed"?: boolean | "false" | "mixed" | "true" | undefined;
        "aria-readonly"?: (boolean | "false" | "true") | undefined;
        "aria-relevant"?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined;
        "aria-required"?: (boolean | "false" | "true") | undefined;
        "aria-roledescription"?: string | undefined;
        "aria-rowcount"?: number | undefined;
        "aria-rowindex"?: number | undefined;
        "aria-rowindextext"?: string | undefined;
        "aria-rowspan"?: number | undefined;
        "aria-selected"?: (boolean | "false" | "true") | undefined;
        "aria-setsize"?: number | undefined;
        "aria-sort"?: "none" | "ascending" | "descending" | "other" | undefined;
        "aria-valuemax"?: number | undefined;
        "aria-valuemin"?: number | undefined;
        "aria-valuenow"?: number | undefined;
        "aria-valuetext"?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: React.ClipboardEventHandler<HTMLElement>;
        onCopyCapture?: React.ClipboardEventHandler<HTMLElement>;
        onCut?: React.ClipboardEventHandler<HTMLElement>;
        onCutCapture?: React.ClipboardEventHandler<HTMLElement>;
        onPaste?: React.ClipboardEventHandler<HTMLElement>;
        onPasteCapture?: React.ClipboardEventHandler<HTMLElement>;
        onCompositionEnd?: React.CompositionEventHandler<HTMLElement>;
        onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement>;
        onCompositionStart?: React.CompositionEventHandler<HTMLElement>;
        onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement>;
        onCompositionUpdate?: React.CompositionEventHandler<HTMLElement>;
        onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement>;
        onFocus?: React.FocusEventHandler<HTMLElement>;
        onFocusCapture?: React.FocusEventHandler<HTMLElement>;
        onBlur?: React.FocusEventHandler<HTMLElement>;
        onBlurCapture?: React.FocusEventHandler<HTMLElement>;
        onChange?: React.FormEventHandler<HTMLElement>;
        onChangeCapture?: React.FormEventHandler<HTMLElement>;
        onBeforeInput?: React.FormEventHandler<HTMLElement>;
        onBeforeInputCapture?: React.FormEventHandler<HTMLElement>;
        onInput?: React.FormEventHandler<HTMLElement>;
        onInputCapture?: React.FormEventHandler<HTMLElement>;
        onReset?: React.FormEventHandler<HTMLElement>;
        onResetCapture?: React.FormEventHandler<HTMLElement>;
        onSubmit?: React.FormEventHandler<HTMLElement>;
        onSubmitCapture?: React.FormEventHandler<HTMLElement>;
        onInvalid?: React.FormEventHandler<HTMLElement>;
        onInvalidCapture?: React.FormEventHandler<HTMLElement>;
        onLoad?: React.ReactEventHandler<HTMLElement>;
        onLoadCapture?: React.ReactEventHandler<HTMLElement>;
        onError?: React.ReactEventHandler<HTMLElement>;
        onErrorCapture?: React.ReactEventHandler<HTMLElement>;
        onKeyDown?: React.KeyboardEventHandler<HTMLElement>;
        onKeyDownCapture?: React.KeyboardEventHandler<HTMLElement>;
        onKeyPress?: React.KeyboardEventHandler<HTMLElement>;
        onKeyPressCapture?: React.KeyboardEventHandler<HTMLElement>;
        onKeyUp?: React.KeyboardEventHandler<HTMLElement>;
        onKeyUpCapture?: React.KeyboardEventHandler<HTMLElement>;
        onAbort?: React.ReactEventHandler<HTMLElement>;
        onAbortCapture?: React.ReactEventHandler<HTMLElement>;
        onCanPlay?: React.ReactEventHandler<HTMLElement>;
        onCanPlayCapture?: React.ReactEventHandler<HTMLElement>;
        onCanPlayThrough?: React.ReactEventHandler<HTMLElement>;
        onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement>;
        onDurationChange?: React.ReactEventHandler<HTMLElement>;
        onDurationChangeCapture?: React.ReactEventHandler<HTMLElement>;
        onEmptied?: React.ReactEventHandler<HTMLElement>;
        onEmptiedCapture?: React.ReactEventHandler<HTMLElement>;
        onEncrypted?: React.ReactEventHandler<HTMLElement>;
        onEncryptedCapture?: React.ReactEventHandler<HTMLElement>;
        onEnded?: React.ReactEventHandler<HTMLElement>;
        onEndedCapture?: React.ReactEventHandler<HTMLElement>;
        onLoadedData?: React.ReactEventHandler<HTMLElement>;
        onLoadedDataCapture?: React.ReactEventHandler<HTMLElement>;
        onLoadedMetadata?: React.ReactEventHandler<HTMLElement>;
        onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement>;
        onLoadStart?: React.ReactEventHandler<HTMLElement>;
        onLoadStartCapture?: React.ReactEventHandler<HTMLElement>;
        onPause?: React.ReactEventHandler<HTMLElement>;
        onPauseCapture?: React.ReactEventHandler<HTMLElement>;
        onPlay?: React.ReactEventHandler<HTMLElement>;
        onPlayCapture?: React.ReactEventHandler<HTMLElement>;
        onPlaying?: React.ReactEventHandler<HTMLElement>;
        onPlayingCapture?: React.ReactEventHandler<HTMLElement>;
        onProgress?: React.ReactEventHandler<HTMLElement>;
        onProgressCapture?: React.ReactEventHandler<HTMLElement>;
        onRateChange?: React.ReactEventHandler<HTMLElement>;
        onRateChangeCapture?: React.ReactEventHandler<HTMLElement>;
        onResize?: React.ReactEventHandler<HTMLElement>;
        onResizeCapture?: React.ReactEventHandler<HTMLElement>;
        onSeeked?: React.ReactEventHandler<HTMLElement>;
        onSeekedCapture?: React.ReactEventHandler<HTMLElement>;
        onSeeking?: React.ReactEventHandler<HTMLElement>;
        onSeekingCapture?: React.ReactEventHandler<HTMLElement>;
        onStalled?: React.ReactEventHandler<HTMLElement>;
        onStalledCapture?: React.ReactEventHandler<HTMLElement>;
        onSuspend?: React.ReactEventHandler<HTMLElement>;
        onSuspendCapture?: React.ReactEventHandler<HTMLElement>;
        onTimeUpdate?: React.ReactEventHandler<HTMLElement>;
        onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement>;
        onVolumeChange?: React.ReactEventHandler<HTMLElement>;
        onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement>;
        onWaiting?: React.ReactEventHandler<HTMLElement>;
        onWaitingCapture?: React.ReactEventHandler<HTMLElement>;
        onAuxClick?: React.MouseEventHandler<HTMLElement>;
        onAuxClickCapture?: React.MouseEventHandler<HTMLElement>;
        onClick?: React.MouseEventHandler<HTMLElement>;
        onClickCapture?: React.MouseEventHandler<HTMLElement>;
        onContextMenu?: React.MouseEventHandler<HTMLElement>;
        onContextMenuCapture?: React.MouseEventHandler<HTMLElement>;
        onDoubleClick?: React.MouseEventHandler<HTMLElement>;
        onDoubleClickCapture?: React.MouseEventHandler<HTMLElement>;
        onDrag?: React.DragEventHandler<HTMLElement>;
        onDragCapture?: React.DragEventHandler<HTMLElement>;
        onDragEnd?: React.DragEventHandler<HTMLElement>;
        onDragEndCapture?: React.DragEventHandler<HTMLElement>;
        onDragEnter?: React.DragEventHandler<HTMLElement>;
        onDragEnterCapture?: React.DragEventHandler<HTMLElement>;
        onDragExit?: React.DragEventHandler<HTMLElement>;
        onDragExitCapture?: React.DragEventHandler<HTMLElement>;
        onDragLeave?: React.DragEventHandler<HTMLElement>;
        onDragLeaveCapture?: React.DragEventHandler<HTMLElement>;
        onDragOver?: React.DragEventHandler<HTMLElement>;
        onDragOverCapture?: React.DragEventHandler<HTMLElement>;
        onDragStart?: React.DragEventHandler<HTMLElement>;
        onDragStartCapture?: React.DragEventHandler<HTMLElement>;
        onDrop?: React.DragEventHandler<HTMLElement>;
        onDropCapture?: React.DragEventHandler<HTMLElement>;
        onMouseDown?: React.MouseEventHandler<HTMLElement>;
        onMouseDownCapture?: React.MouseEventHandler<HTMLElement>;
        onMouseEnter?: React.MouseEventHandler<HTMLElement>;
        onMouseLeave?: React.MouseEventHandler<HTMLElement>;
        onMouseMove?: React.MouseEventHandler<HTMLElement>;
        onMouseMoveCapture?: React.MouseEventHandler<HTMLElement>;
        onMouseOut?: React.MouseEventHandler<HTMLElement>;
        onMouseOutCapture?: React.MouseEventHandler<HTMLElement>;
        onMouseOver?: React.MouseEventHandler<HTMLElement>;
        onMouseOverCapture?: React.MouseEventHandler<HTMLElement>;
        onMouseUp?: React.MouseEventHandler<HTMLElement>;
        onMouseUpCapture?: React.MouseEventHandler<HTMLElement>;
        onSelect?: React.ReactEventHandler<HTMLElement>;
        onSelectCapture?: React.ReactEventHandler<HTMLElement>;
        onTouchCancel?: React.TouchEventHandler<HTMLElement>;
        onTouchCancelCapture?: React.TouchEventHandler<HTMLElement>;
        onTouchEnd?: React.TouchEventHandler<HTMLElement>;
        onTouchEndCapture?: React.TouchEventHandler<HTMLElement>;
        onTouchMove?: React.TouchEventHandler<HTMLElement>;
        onTouchMoveCapture?: React.TouchEventHandler<HTMLElement>;
        onTouchStart?: React.TouchEventHandler<HTMLElement>;
        onTouchStartCapture?: React.TouchEventHandler<HTMLElement>;
        onPointerDown?: React.PointerEventHandler<HTMLElement>;
        onPointerDownCapture?: React.PointerEventHandler<HTMLElement>;
        onPointerMove?: React.PointerEventHandler<HTMLElement>;
        onPointerMoveCapture?: React.PointerEventHandler<HTMLElement>;
        onPointerUp?: React.PointerEventHandler<HTMLElement>;
        onPointerUpCapture?: React.PointerEventHandler<HTMLElement>;
        onPointerCancel?: React.PointerEventHandler<HTMLElement>;
        onPointerCancelCapture?: React.PointerEventHandler<HTMLElement>;
        onPointerEnter?: React.PointerEventHandler<HTMLElement>;
        onPointerLeave?: React.PointerEventHandler<HTMLElement>;
        onPointerOver?: React.PointerEventHandler<HTMLElement>;
        onPointerOverCapture?: React.PointerEventHandler<HTMLElement>;
        onPointerOut?: React.PointerEventHandler<HTMLElement>;
        onPointerOutCapture?: React.PointerEventHandler<HTMLElement>;
        onGotPointerCapture?: React.PointerEventHandler<HTMLElement>;
        onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement>;
        onLostPointerCapture?: React.PointerEventHandler<HTMLElement>;
        onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement>;
        onScroll?: React.UIEventHandler<HTMLElement>;
        onScrollCapture?: React.UIEventHandler<HTMLElement>;
        onWheel?: React.WheelEventHandler<HTMLElement>;
        onWheelCapture?: React.WheelEventHandler<HTMLElement>;
        onAnimationStart?: React.AnimationEventHandler<HTMLElement>;
        onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement>;
        onAnimationEnd?: React.AnimationEventHandler<HTMLElement>;
        onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement>;
        onAnimationIteration?: React.AnimationEventHandler<HTMLElement>;
        onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement>;
        onToggle?: React.ToggleEventHandler<HTMLElement>;
        onBeforeToggle?: React.ToggleEventHandler<HTMLElement>;
        onTransitionCancel?: React.TransitionEventHandler<HTMLElement>;
        onTransitionCancelCapture?: React.TransitionEventHandler<HTMLElement>;
        onTransitionEnd?: React.TransitionEventHandler<HTMLElement>;
        onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement>;
        onTransitionRun?: React.TransitionEventHandler<HTMLElement>;
        onTransitionRunCapture?: React.TransitionEventHandler<HTMLElement>;
        onTransitionStart?: React.TransitionEventHandler<HTMLElement>;
        onTransitionStartCapture?: React.TransitionEventHandler<HTMLElement>;
    };
    contentProps: {
        role: string;
        style: React.CSSProperties;
    };
};
interface VirtualizerItemProps extends Omit<VirtualizerItemOptions, 'ref'> {
    parent?: LayoutInfo | null;
    className?: string;
    children: ReactNode;
}
export function VirtualizerItem(props: VirtualizerItemProps): React.JSX.Element;
export function layoutInfoToStyle(layoutInfo: LayoutInfo, dir: Direction, parent?: LayoutInfo | null): CSSProperties;
type RenderWrapper<T extends object, V> = (parent: ReusableView<T, V> | null, reusableView: ReusableView<T, V>, children: ReusableView<T, V>[], renderChildren: (views: ReusableView<T, V>[]) => ReactElement[]) => ReactElement;
interface VirtualizerProps<T extends object, V, O> extends Omit<HTMLAttributes<HTMLElement>, 'children'> {
    children: (type: string, content: T) => V;
    renderWrapper?: RenderWrapper<T, V>;
    layout: Layout<T, O>;
    collection: Collection<T>;
    persistedKeys?: Set<Key> | null;
    scrollDirection?: 'horizontal' | 'vertical' | 'both';
    isLoading?: boolean;
    onLoadMore?: () => void;
    layoutOptions?: O;
}
export const Virtualizer: <T extends object, V, O>(props: VirtualizerProps<T, V, O> & {
    ref?: RefObject<HTMLDivElement | null>;
}) => ReactElement;

//# sourceMappingURL=types.d.ts.map
