var $7d70e069fceb2deb$exports = require("./useVirtualizerItem.main.js");
var $eXWCF$react = require("react");
var $eXWCF$reactariai18n = require("@react-aria/i18n");


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "VirtualizerItem", () => $d6a26279cc31826b$export$6796df8ba7398521);
$parcel$export(module.exports, "layoutInfoToStyle", () => $d6a26279cc31826b$export$1481e64fbe01b8b3);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 


function $d6a26279cc31826b$export$6796df8ba7398521(props) {
    let { className: className, layoutInfo: layoutInfo, virtualizer: virtualizer, parent: parent, children: children } = props;
    let { direction: direction } = (0, $eXWCF$reactariai18n.useLocale)();
    let ref = (0, $eXWCF$react.useRef)(undefined);
    (0, $7d70e069fceb2deb$exports.useVirtualizerItem)({
        layoutInfo: layoutInfo,
        virtualizer: virtualizer,
        ref: ref
    });
    return /*#__PURE__*/ (0, ($parcel$interopDefault($eXWCF$react))).createElement("div", {
        role: "presentation",
        ref: ref,
        className: className,
        style: $d6a26279cc31826b$export$1481e64fbe01b8b3(layoutInfo, direction, parent)
    }, children);
}
let $d6a26279cc31826b$var$cache = new WeakMap();
function $d6a26279cc31826b$export$1481e64fbe01b8b3(layoutInfo, dir, parent) {
    let xProperty = dir === 'rtl' ? 'right' : 'left';
    let cached = $d6a26279cc31826b$var$cache.get(layoutInfo);
    if (cached && cached[xProperty] != null) {
        if (!parent) return cached;
        // Invalidate if the parent position changed.
        let top = layoutInfo.rect.y - parent.rect.y;
        let x = layoutInfo.rect.x - parent.rect.x;
        if (cached.top === top && cached[xProperty] === x) return cached;
    }
    let rectStyles = {
        top: layoutInfo.rect.y - (parent ? parent.rect.y : 0),
        [xProperty]: layoutInfo.rect.x - (parent ? parent.rect.x : 0),
        width: layoutInfo.rect.width,
        height: layoutInfo.rect.height
    };
    // Get rid of any non finite values since they aren't valid css values
    Object.entries(rectStyles).forEach(([key, value])=>{
        if (!Number.isFinite(value)) rectStyles[key] = undefined;
    });
    let style = {
        position: layoutInfo.isSticky ? 'sticky' : 'absolute',
        // Sticky elements are positioned in normal document flow. Display inline-block so that they don't push other sticky columns onto the following rows.
        display: layoutInfo.isSticky ? 'inline-block' : undefined,
        overflow: layoutInfo.allowOverflow ? 'visible' : 'hidden',
        opacity: layoutInfo.opacity,
        zIndex: layoutInfo.zIndex,
        transform: layoutInfo.transform,
        contain: 'size layout style',
        ...rectStyles
    };
    $d6a26279cc31826b$var$cache.set(layoutInfo, style);
    return style;
}


//# sourceMappingURL=VirtualizerItem.main.js.map
