var $efdd61e59e023a1d$exports = require("./utils.main.js");
var $kvIfm$reactdom = require("react-dom");
var $kvIfm$react = require("react");
var $kvIfm$reactstatelyvirtualizer = require("@react-stately/virtualizer");
var $kvIfm$reactariautils = require("@react-aria/utils");
var $kvIfm$reactariai18n = require("@react-aria/i18n");


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useScrollView", () => $00ca8c0b29e3e07c$export$2ea0c4974da4731b);
$parcel$export(module.exports, "ScrollView", () => $00ca8c0b29e3e07c$export$5665e3d6be6adea);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ // @ts-ignore






function $00ca8c0b29e3e07c$var$ScrollView(props, ref) {
    ref = (0, $kvIfm$reactariautils.useObjectRef)(ref);
    let { scrollViewProps: scrollViewProps, contentProps: contentProps } = $00ca8c0b29e3e07c$export$2ea0c4974da4731b(props, ref);
    return /*#__PURE__*/ (0, ($parcel$interopDefault($kvIfm$react))).createElement("div", {
        role: "presentation",
        ...scrollViewProps,
        ref: ref
    }, /*#__PURE__*/ (0, ($parcel$interopDefault($kvIfm$react))).createElement("div", {
        role: "presentation",
        ...contentProps
    }, props.children));
}
const $00ca8c0b29e3e07c$export$5665e3d6be6adea = /*#__PURE__*/ (0, ($parcel$interopDefault($kvIfm$react))).forwardRef($00ca8c0b29e3e07c$var$ScrollView);
function $00ca8c0b29e3e07c$export$2ea0c4974da4731b(props, ref) {
    let { contentSize: contentSize, onVisibleRectChange: onVisibleRectChange, innerStyle: innerStyle, onScrollStart: onScrollStart, onScrollEnd: onScrollEnd, scrollDirection: scrollDirection = 'both', ...otherProps } = props;
    let state = (0, $kvIfm$react.useRef)({
        scrollTop: 0,
        scrollLeft: 0,
        scrollEndTime: 0,
        scrollTimeout: null,
        width: 0,
        height: 0,
        isScrolling: false
    }).current;
    let { direction: direction } = (0, $kvIfm$reactariai18n.useLocale)();
    let [isScrolling, setScrolling] = (0, $kvIfm$react.useState)(false);
    let onScroll = (0, $kvIfm$react.useCallback)((e)=>{
        if (e.target !== e.currentTarget) return;
        if (props.onScroll) props.onScroll(e);
        (0, $kvIfm$reactdom.flushSync)(()=>{
            let scrollTop = e.currentTarget.scrollTop;
            let scrollLeft = (0, $efdd61e59e023a1d$exports.getScrollLeft)(e.currentTarget, direction);
            // Prevent rubber band scrolling from shaking when scrolling out of bounds
            state.scrollTop = Math.max(0, Math.min(scrollTop, contentSize.height - state.height));
            state.scrollLeft = Math.max(0, Math.min(scrollLeft, contentSize.width - state.width));
            onVisibleRectChange(new (0, $kvIfm$reactstatelyvirtualizer.Rect)(state.scrollLeft, state.scrollTop, state.width, state.height));
            if (!state.isScrolling) {
                state.isScrolling = true;
                setScrolling(true);
                // Pause typekit MutationObserver during scrolling.
                window.dispatchEvent(new Event('tk.disconnect-observer'));
                if (onScrollStart) onScrollStart();
            }
            // So we don't constantly call clearTimeout and setTimeout,
            // keep track of the current timeout time and only reschedule
            // the timer when it is getting close.
            let now = Date.now();
            if (state.scrollEndTime <= now + 50) {
                state.scrollEndTime = now + 300;
                clearTimeout(state.scrollTimeout);
                state.scrollTimeout = setTimeout(()=>{
                    state.isScrolling = false;
                    setScrolling(false);
                    state.scrollTimeout = null;
                    window.dispatchEvent(new Event('tk.connect-observer'));
                    if (onScrollEnd) onScrollEnd();
                }, 300);
            }
        });
    }, [
        props,
        direction,
        state,
        contentSize,
        onVisibleRectChange,
        onScrollStart,
        onScrollEnd
    ]);
    // Attach event directly to ref so RAC Virtualizer doesn't need to send props upward.
    (0, $kvIfm$reactariautils.useEvent)(ref, 'scroll', onScroll);
    // eslint-disable-next-line arrow-body-style
    (0, $kvIfm$react.useEffect)(()=>{
        return ()=>{
            clearTimeout(state.scrollTimeout);
            if (state.isScrolling) window.dispatchEvent(new Event('tk.connect-observer'));
        };
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    let updateSize = (0, $kvIfm$reactariautils.useEffectEvent)((flush)=>{
        let dom = ref.current;
        if (!dom) return;
        let isTestEnv = false;
        let isClientWidthMocked = Object.getOwnPropertyNames(window.HTMLElement.prototype).includes('clientWidth');
        let isClientHeightMocked = Object.getOwnPropertyNames(window.HTMLElement.prototype).includes('clientHeight');
        let clientWidth = dom.clientWidth;
        let clientHeight = dom.clientHeight;
        let w = isTestEnv && !isClientWidthMocked ? Infinity : clientWidth;
        let h = isTestEnv && !isClientHeightMocked ? Infinity : clientHeight;
        if (state.width !== w || state.height !== h) {
            state.width = w;
            state.height = h;
            flush(()=>{
                onVisibleRectChange(new (0, $kvIfm$reactstatelyvirtualizer.Rect)(state.scrollLeft, state.scrollTop, w, h));
            });
            // If the clientWidth or clientHeight changed, scrollbars appeared or disappeared as
            // a result of the layout update. In this case, re-layout again to account for the
            // adjusted space. In very specific cases this might result in the scrollbars disappearing
            // again, resulting in extra padding. We stop after a maximum of two layout passes to avoid
            // an infinite loop. This matches how browsers behavior with native CSS grid layout.
            if (!isTestEnv && clientWidth !== dom.clientWidth || clientHeight !== dom.clientHeight) {
                state.width = dom.clientWidth;
                state.height = dom.clientHeight;
                flush(()=>{
                    onVisibleRectChange(new (0, $kvIfm$reactstatelyvirtualizer.Rect)(state.scrollLeft, state.scrollTop, state.width, state.height));
                });
            }
        }
    });
    let didUpdateSize = (0, $kvIfm$react.useRef)(false);
    (0, $kvIfm$reactariautils.useLayoutEffect)(()=>{
        // React doesn't allow flushSync inside effects, so queue a microtask.
        // We also need to wait until all refs are set (e.g. when passing a ref down from a parent).
        queueMicrotask(()=>{
            if (!didUpdateSize.current) {
                didUpdateSize.current = true;
                updateSize((0, $kvIfm$reactdom.flushSync));
            }
        });
    }, [
        updateSize
    ]);
    (0, $kvIfm$react.useEffect)(()=>{
        if (!didUpdateSize.current) {
            // If useEffect ran before the above microtask, we are in a synchronous render (e.g. act).
            // Update the size here so that you don't need to mock timers in tests.
            didUpdateSize.current = true;
            updateSize((fn)=>fn());
        }
    }, [
        updateSize
    ]);
    let onResize = (0, $kvIfm$react.useCallback)(()=>{
        updateSize((0, $kvIfm$reactdom.flushSync));
    }, [
        updateSize
    ]);
    // Watch border-box instead of of content-box so that we don't go into
    // an infinite loop when scrollbars appear or disappear.
    (0, $kvIfm$reactariautils.useResizeObserver)({
        ref: ref,
        box: 'border-box',
        onResize: onResize
    });
    let style = {
        // Reset padding so that relative positioning works correctly. Padding will be done in JS layout.
        padding: 0,
        ...otherProps.style
    };
    if (scrollDirection === 'horizontal') {
        style.overflowX = 'auto';
        style.overflowY = 'hidden';
    } else if (scrollDirection === 'vertical' || contentSize.width === state.width) {
        // Set overflow-x: hidden if content size is equal to the width of the scroll view.
        // This prevents horizontal scrollbars from flickering during resizing due to resize observer
        // firing slower than the frame rate, which may cause an infinite re-render loop.
        style.overflowY = 'auto';
        style.overflowX = 'hidden';
    } else style.overflow = 'auto';
    innerStyle = {
        width: Number.isFinite(contentSize.width) ? contentSize.width : undefined,
        height: Number.isFinite(contentSize.height) ? contentSize.height : undefined,
        pointerEvents: isScrolling ? 'none' : 'auto',
        position: 'relative',
        ...innerStyle
    };
    return {
        scrollViewProps: {
            ...otherProps,
            style: style
        },
        contentProps: {
            role: 'presentation',
            style: innerStyle
        }
    };
}


//# sourceMappingURL=ScrollView.main.js.map
