import {focusManagerSymbol as $16f0b7bb276bc17e$export$7b3062cd49e80452, roleSymbol as $16f0b7bb276bc17e$export$300019f83c56d282} from "./useDateField.mjs";
import $eIQ1H$intlStringsmodulejs from "./intlStrings.mjs";
import {useDatePickerGroup as $3dfb0f96be0d6a08$export$4a931266a3838b86} from "./useDatePickerGroup.mjs";
import {createFocusManager as $eIQ1H$createFocusManager} from "@react-aria/focus";
import {DEFAULT_VALIDATION_RESULT as $eIQ1H$DEFAULT_VALIDATION_RESULT, privateValidationStateProp as $eIQ1H$privateValidationStateProp, mergeValidation as $eIQ1H$mergeValidation} from "@react-stately/form";
import {useDescription as $eIQ1H$useDescription, useId as $eIQ1H$useId, filterDOMProps as $eIQ1H$filterDOMProps, mergeProps as $eIQ1H$mergeProps} from "@react-aria/utils";
import {useField as $eIQ1H$useField} from "@react-aria/label";
import {useFocusWithin as $eIQ1H$useFocusWithin} from "@react-aria/interactions";
import {useLocalizedStringFormatter as $eIQ1H$useLocalizedStringFormatter, useLocale as $eIQ1H$useLocale} from "@react-aria/i18n";
import {useMemo as $eIQ1H$useMemo, useRef as $eIQ1H$useRef} from "react";


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 









function $887cac91b7cc8801$export$12fd5f0e9f4bb192(props, state, ref) {
    var _state_value, _state_value1;
    let stringFormatter = (0, $eIQ1H$useLocalizedStringFormatter)((0, ($parcel$interopDefault($eIQ1H$intlStringsmodulejs))), '@react-aria/datepicker');
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $eIQ1H$useField)({
        ...props,
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let labelledBy = fieldProps['aria-labelledby'] || fieldProps.id;
    let { locale: locale } = (0, $eIQ1H$useLocale)();
    let range = state.formatValue(locale, {
        month: 'long'
    });
    let description = range ? stringFormatter.format('selectedRangeDescription', {
        startDate: range.start,
        endDate: range.end
    }) : '';
    let descProps = (0, $eIQ1H$useDescription)(description);
    let startFieldProps = {
        'aria-label': stringFormatter.format('startDate'),
        'aria-labelledby': labelledBy
    };
    let endFieldProps = {
        'aria-label': stringFormatter.format('endDate'),
        'aria-labelledby': labelledBy
    };
    let buttonId = (0, $eIQ1H$useId)();
    let dialogId = (0, $eIQ1H$useId)();
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref);
    let ariaDescribedBy = [
        descProps['aria-describedby'],
        fieldProps['aria-describedby']
    ].filter(Boolean).join(' ') || undefined;
    let focusManager = (0, $eIQ1H$useMemo)(()=>(0, $eIQ1H$createFocusManager)(ref, {
            // Exclude the button from the focus manager.
            accept: (element)=>element.id !== buttonId
        }), [
        ref,
        buttonId
    ]);
    let commonFieldProps = {
        [(0, $16f0b7bb276bc17e$export$7b3062cd49e80452)]: focusManager,
        [(0, $16f0b7bb276bc17e$export$300019f83c56d282)]: 'presentation',
        'aria-describedby': ariaDescribedBy,
        placeholderValue: props.placeholderValue,
        hideTimeZone: props.hideTimeZone,
        hourCycle: props.hourCycle,
        granularity: props.granularity,
        shouldForceLeadingZeros: props.shouldForceLeadingZeros,
        isDisabled: props.isDisabled,
        isReadOnly: props.isReadOnly,
        isRequired: props.isRequired,
        validationBehavior: props.validationBehavior
    };
    let domProps = (0, $eIQ1H$filterDOMProps)(props);
    let { focusWithinProps: focusWithinProps } = (0, $eIQ1H$useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    let startFieldValidation = (0, $eIQ1H$useRef)((0, $eIQ1H$DEFAULT_VALIDATION_RESULT));
    let endFieldValidation = (0, $eIQ1H$useRef)((0, $eIQ1H$DEFAULT_VALIDATION_RESULT));
    return {
        groupProps: (0, $eIQ1H$mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: 'group',
            'aria-disabled': props.isDisabled || null,
            'aria-describedby': ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        buttonProps: {
            ...descProps,
            id: buttonId,
            'aria-haspopup': 'dialog',
            'aria-label': stringFormatter.format('calendar'),
            'aria-labelledby': `${buttonId} ${labelledBy}`,
            'aria-describedby': ariaDescribedBy,
            'aria-expanded': state.isOpen,
            isDisabled: props.isDisabled || props.isReadOnly,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            'aria-labelledby': `${buttonId} ${labelledBy}`
        },
        startFieldProps: {
            ...startFieldProps,
            ...commonFieldProps,
            value: (_state_value = state.value) === null || _state_value === void 0 ? void 0 : _state_value.start,
            onChange: (start)=>state.setDateTime('start', start),
            autoFocus: props.autoFocus,
            name: props.startName,
            [(0, $eIQ1H$privateValidationStateProp)]: {
                realtimeValidation: state.realtimeValidation,
                displayValidation: state.displayValidation,
                updateValidation (e) {
                    startFieldValidation.current = e;
                    state.updateValidation((0, $eIQ1H$mergeValidation)(e, endFieldValidation.current));
                },
                resetValidation: state.resetValidation,
                commitValidation: state.commitValidation
            }
        },
        endFieldProps: {
            ...endFieldProps,
            ...commonFieldProps,
            value: (_state_value1 = state.value) === null || _state_value1 === void 0 ? void 0 : _state_value1.end,
            onChange: (end)=>state.setDateTime('end', end),
            name: props.endName,
            [(0, $eIQ1H$privateValidationStateProp)]: {
                realtimeValidation: state.realtimeValidation,
                displayValidation: state.displayValidation,
                updateValidation (e) {
                    endFieldValidation.current = e;
                    state.updateValidation((0, $eIQ1H$mergeValidation)(startFieldValidation.current, e));
                },
                resetValidation: state.resetValidation,
                commitValidation: state.commitValidation
            }
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        calendarProps: {
            autoFocus: true,
            value: state.dateRange,
            onChange: state.setDateRange,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            allowsNonContiguousRanges: props.allowsNonContiguousRanges,
            defaultFocusedValue: state.dateRange ? undefined : props.placeholderValue,
            isInvalid: state.isInvalid,
            errorMessage: typeof props.errorMessage === 'function' ? props.errorMessage(state.displayValidation) : props.errorMessage || state.displayValidation.validationErrors.join(' ')
        },
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


export {$887cac91b7cc8801$export$12fd5f0e9f4bb192 as useDateRangePicker};
//# sourceMappingURL=useDateRangePicker.module.js.map
