var $4acc2f407c169e55$exports = require("./useDateField.main.js");
var $c1905b78f6d2f5bf$exports = require("./intlStrings.main.js");
var $715562ad3b4cced4$exports = require("./useDatePickerGroup.main.js");
var $Xt1Bd$reactariafocus = require("@react-aria/focus");
var $Xt1Bd$reactstatelyform = require("@react-stately/form");
var $Xt1Bd$reactariautils = require("@react-aria/utils");
var $Xt1Bd$reactarialabel = require("@react-aria/label");
var $Xt1Bd$reactariainteractions = require("@react-aria/interactions");
var $Xt1Bd$reactariai18n = require("@react-aria/i18n");
var $Xt1Bd$react = require("react");


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useDateRangePicker", () => $20f695b1b69e6b9e$export$12fd5f0e9f4bb192);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 









function $20f695b1b69e6b9e$export$12fd5f0e9f4bb192(props, state, ref) {
    var _state_value, _state_value1;
    let stringFormatter = (0, $Xt1Bd$reactariai18n.useLocalizedStringFormatter)((0, ($parcel$interopDefault($c1905b78f6d2f5bf$exports))), '@react-aria/datepicker');
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $Xt1Bd$reactarialabel.useField)({
        ...props,
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let labelledBy = fieldProps['aria-labelledby'] || fieldProps.id;
    let { locale: locale } = (0, $Xt1Bd$reactariai18n.useLocale)();
    let range = state.formatValue(locale, {
        month: 'long'
    });
    let description = range ? stringFormatter.format('selectedRangeDescription', {
        startDate: range.start,
        endDate: range.end
    }) : '';
    let descProps = (0, $Xt1Bd$reactariautils.useDescription)(description);
    let startFieldProps = {
        'aria-label': stringFormatter.format('startDate'),
        'aria-labelledby': labelledBy
    };
    let endFieldProps = {
        'aria-label': stringFormatter.format('endDate'),
        'aria-labelledby': labelledBy
    };
    let buttonId = (0, $Xt1Bd$reactariautils.useId)();
    let dialogId = (0, $Xt1Bd$reactariautils.useId)();
    let groupProps = (0, $715562ad3b4cced4$exports.useDatePickerGroup)(state, ref);
    let ariaDescribedBy = [
        descProps['aria-describedby'],
        fieldProps['aria-describedby']
    ].filter(Boolean).join(' ') || undefined;
    let focusManager = (0, $Xt1Bd$react.useMemo)(()=>(0, $Xt1Bd$reactariafocus.createFocusManager)(ref, {
            // Exclude the button from the focus manager.
            accept: (element)=>element.id !== buttonId
        }), [
        ref,
        buttonId
    ]);
    let commonFieldProps = {
        [(0, $4acc2f407c169e55$exports.focusManagerSymbol)]: focusManager,
        [(0, $4acc2f407c169e55$exports.roleSymbol)]: 'presentation',
        'aria-describedby': ariaDescribedBy,
        placeholderValue: props.placeholderValue,
        hideTimeZone: props.hideTimeZone,
        hourCycle: props.hourCycle,
        granularity: props.granularity,
        shouldForceLeadingZeros: props.shouldForceLeadingZeros,
        isDisabled: props.isDisabled,
        isReadOnly: props.isReadOnly,
        isRequired: props.isRequired,
        validationBehavior: props.validationBehavior
    };
    let domProps = (0, $Xt1Bd$reactariautils.filterDOMProps)(props);
    let { focusWithinProps: focusWithinProps } = (0, $Xt1Bd$reactariainteractions.useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    let startFieldValidation = (0, $Xt1Bd$react.useRef)((0, $Xt1Bd$reactstatelyform.DEFAULT_VALIDATION_RESULT));
    let endFieldValidation = (0, $Xt1Bd$react.useRef)((0, $Xt1Bd$reactstatelyform.DEFAULT_VALIDATION_RESULT));
    return {
        groupProps: (0, $Xt1Bd$reactariautils.mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: 'group',
            'aria-disabled': props.isDisabled || null,
            'aria-describedby': ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        buttonProps: {
            ...descProps,
            id: buttonId,
            'aria-haspopup': 'dialog',
            'aria-label': stringFormatter.format('calendar'),
            'aria-labelledby': `${buttonId} ${labelledBy}`,
            'aria-describedby': ariaDescribedBy,
            'aria-expanded': state.isOpen,
            isDisabled: props.isDisabled || props.isReadOnly,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            'aria-labelledby': `${buttonId} ${labelledBy}`
        },
        startFieldProps: {
            ...startFieldProps,
            ...commonFieldProps,
            value: (_state_value = state.value) === null || _state_value === void 0 ? void 0 : _state_value.start,
            onChange: (start)=>state.setDateTime('start', start),
            autoFocus: props.autoFocus,
            name: props.startName,
            [(0, $Xt1Bd$reactstatelyform.privateValidationStateProp)]: {
                realtimeValidation: state.realtimeValidation,
                displayValidation: state.displayValidation,
                updateValidation (e) {
                    startFieldValidation.current = e;
                    state.updateValidation((0, $Xt1Bd$reactstatelyform.mergeValidation)(e, endFieldValidation.current));
                },
                resetValidation: state.resetValidation,
                commitValidation: state.commitValidation
            }
        },
        endFieldProps: {
            ...endFieldProps,
            ...commonFieldProps,
            value: (_state_value1 = state.value) === null || _state_value1 === void 0 ? void 0 : _state_value1.end,
            onChange: (end)=>state.setDateTime('end', end),
            name: props.endName,
            [(0, $Xt1Bd$reactstatelyform.privateValidationStateProp)]: {
                realtimeValidation: state.realtimeValidation,
                displayValidation: state.displayValidation,
                updateValidation (e) {
                    endFieldValidation.current = e;
                    state.updateValidation((0, $Xt1Bd$reactstatelyform.mergeValidation)(startFieldValidation.current, e));
                },
                resetValidation: state.resetValidation,
                commitValidation: state.commitValidation
            }
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        calendarProps: {
            autoFocus: true,
            value: state.dateRange,
            onChange: state.setDateRange,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            allowsNonContiguousRanges: props.allowsNonContiguousRanges,
            defaultFocusedValue: state.dateRange ? undefined : props.placeholderValue,
            isInvalid: state.isInvalid,
            errorMessage: typeof props.errorMessage === 'function' ? props.errorMessage(state.displayValidation) : props.errorMessage || state.displayValidation.validationErrors.join(' ')
        },
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


//# sourceMappingURL=useDateRangePicker.main.js.map
