/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */
import type { MutableRefObject } from 'react';
type CallbackRef<T> = (element: T) => void;
type ReactRef<T> = CallbackRef<T | null> | MutableRefObject<T | null> | null;
/**
 * Combine multiple react refs into one.
 */
export declare function mergeRefs<T>(...refs: Array<ReactRef<T>>): CallbackRef<T>;
export {};
