/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md.
 */
import type { Context, ContextWatchdog, Editor } from 'ckeditor5';
import type { ContextWatchdogValue } from './ckeditorcontext.js';
import { type CKEditorConfigContextMetadata } from './setCKEditorReactContextMetadata.js';
/**
 * A hook that listens for the editor initialization and destruction events and updates the editors map.
 *
 * @param config The configuration of the hook.
 * @param config.currentContextWatchdog The current context watchdog value.
 * @param config.onChangeInitializedEditors The function that updates the editors map.
 * @example
 * ```ts
 * useInitializedCKEditorsMap( {
 * 	currentContextWatchdog,
 * 	onChangeInitializedEditors: ( editors, context ) => {
 * 		console.log( 'Editors:', editors );
 * 	}
 * } );
 * ```
 */
export declare const useInitializedCKEditorsMap: <TContext extends Context>({ currentContextWatchdog, onChangeInitializedEditors }: InitializedContextEditorsConfig<TContext>) => void;
/**
 * A map of initialized editors.
 */
type InitializedEditorsMap = Record<string, {
    instance: Editor;
    metadata: CKEditorConfigContextMetadata | null;
}>;
/**
 * The configuration of the `useInitializedCKEditorsMap` hook.
 */
export type InitializedContextEditorsConfig<TContext extends Context> = {
    /**
     * The current context watchdog value.
     */
    currentContextWatchdog: ContextWatchdogValue<TContext>;
    /**
     * The callback called when the editors map changes.
     */
    onChangeInitializedEditors?: (editors: InitializedEditorsMap, watchdog: ContextWatchdog<TContext>) => void;
};
export {};
